/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.DataBoxException;
import cz.abclinuxu.datoveschranky.common.entities.Message;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.entities.MessageType;
import cz.abclinuxu.datoveschranky.common.interfaces.AttachmentStorer;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxDownloadService;
import cz.abclinuxu.datoveschranky.impl.ErrorHandling;
import cz.abclinuxu.datoveschranky.impl.MessageValidator;
import cz.abclinuxu.datoveschranky.ws.dm.DmOperationsPortType;
import cz.abclinuxu.datoveschranky.ws.dm.TReturnedMessage;
import cz.abclinuxu.datoveschranky.ws.dm.TStatus;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.ws.Holder;
import org.apache.log4j.Logger;

public class DataBoxDownloadServiceImpl
implements DataBoxDownloadService {
    private DmOperationsPortType dmOp = null;
    private MessageValidator validator = null;
    static Logger logger = Logger.getLogger(DataBoxDownloadServiceImpl.class);

    public DataBoxDownloadServiceImpl(DmOperationsPortType dmOpService, MessageValidator validate) {
        this.dmOp = dmOpService;
        this.validator = validate;
    }

    public Message downloadMessage(MessageEnvelope envelope, AttachmentStorer storer) {
        logger.info((Object)String.format("downloadMessage: id:%s", envelope.getMessageID()));
        if (envelope.getType() != MessageType.RECEIVED) {
            throw new DataBoxException("Mohu stahnout pouze prijatou zpravu.");
        }
        Holder status = new Holder();
        Holder hMessage = new Holder();
        this.dmOp.messageDownload(envelope.getMessageID(), (Holder<TReturnedMessage>)hMessage, (Holder<TStatus>)status);
        ErrorHandling.throwIfError("Nemohu stahnout prijatou zpravu.", (TStatus)status.value);
        logger.info((Object)String.format("downloadMessage successfull", new Object[0]));
        TReturnedMessage message = (TReturnedMessage)hMessage.value;
        return this.validator.buildMessage(envelope, message, storer);
    }

    public void downloadSignedMessage(MessageEnvelope env, OutputStream os) {
        logger.info((Object)String.format("downloadSignedMessage: id:%s", env.getMessageID()));
        String id = env.getMessageID();
        Holder messageAsPKCS7 = new Holder();
        Holder status = new Holder();
        switch (env.getType()) {
            case RECEIVED: {
                this.dmOp.signedMessageDownload(id, (Holder<byte[]>)messageAsPKCS7, (Holder<TStatus>)status);
                break;
            }
            case SENT: {
                this.dmOp.signedSentMessageDownload(id, (Holder<byte[]>)messageAsPKCS7, (Holder<TStatus>)status);
                break;
            }
            default: {
                throw new DataBoxException("Neodeslanou zpravu nelze stahnout");
            }
        }
        ErrorHandling.throwIfError("Nemohu stahnout podepsanou zpravu.", (TStatus)status.value);
        try {
            os.write((byte[])messageAsPKCS7.value);
            os.flush();
            logger.info((Object)String.format("downloadSignedMessage successfull", new Object[0]));
        }
        catch (IOException ioe) {
            throw new DataBoxException("Chyba pri zapisu do vystupniho proudu.", ioe);
        }
    }
}

