/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.common.entities;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;

public class Hash
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final byte[] hash;
    private final String algorithm;

    public Hash(String algorithm, byte[] hash) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm");
        }
        if (hash == null) {
            throw new NullPointerException("hash");
        }
        this.algorithm = algorithm;
        this.hash = hash;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public String toString() {
        return this.algorithm + " " + new BigInteger(1, this.hash).toString(16);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Hash other = (Hash)obj;
        return Arrays.equals(this.hash, other.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }
}

