/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.common.entities;

import cz.abclinuxu.datoveschranky.common.entities.Attachment;
import cz.abclinuxu.datoveschranky.common.entities.LegalTitle;
import cz.abclinuxu.datoveschranky.common.entities.Message;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import java.util.Arrays;
import java.util.List;

public class Validator {
    private static List<String> enabledMetaTypes = Arrays.asList("main", "enclosure", "signature", "meta");

    private Validator() {
    }

    public static void assertNotNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
    }

    public static void assertValidMessageID(String id) {
    }

    public static void assertValidDataBoxID(String id) {
    }

    public static void assertValidMessageAnnotation(String annotation) {
        if (annotation != null && annotation.length() > 255) {
            throw new IllegalArgumentException("P\u0159edm\u011bt zpr\u00e1vy sm\u00ed obsahovat nejv\u00fd\u0161e 255 znak\u016f.");
        }
    }

    public static void assertValidMessageForSending(Message message) {
        Attachment first;
        MessageEnvelope env = message.getEnvelope();
        if (env.getRecipient() == null) {
            throw new IllegalArgumentException("Zprava nema prijemce.");
        }
        if (env.getRecipient().getDataBoxID() == null) {
            throw new IllegalArgumentException("ID prijemce zpravy je null.");
        }
        List<Attachment> attachments = message.getAttachments();
        if (attachments == null || attachments.size() == 0) {
            throw new IllegalArgumentException("Zprava musi obsahovat alespon jednu prilohu.");
        }
        LegalTitle legalTitle = message.getEnvelope().getLegalTitle();
        if (legalTitle != null) {
            if (legalTitle.getLaw() != null) {
                try {
                    Long.parseLong(legalTitle.getLaw());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cislo paragrafu zmocneni neni prirozene cislo");
                }
            }
            if (legalTitle.getYear() != null) {
                try {
                    Long.parseLong(legalTitle.getYear());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Rok zmocneni neni prirozene cislo");
                }
            }
        }
        if ((first = attachments.get(0)).getMetaType() == null || !first.getMetaType().equals("main")) {
            throw new IllegalArgumentException(String.format("Druh (metatype) prvni pisemnosti  v prilohach mus\u00ed b\u00fdt main, tady je %s.", first.getMetaType()));
        }
        for (Attachment attach : attachments) {
            if (!enabledMetaTypes.contains(attach.getMetaType())) {
                throw new IllegalArgumentException(String.format("%s nen\u00ed povoleny druh pisemnosti (metatype). Povolen jsou: %s.", attach.getMetaType(), enabledMetaTypes.toString()));
            }
            if (attach.getDescription() == null) {
                throw new IllegalArgumentException("Popis p\u0159\u00edlohy je null");
            }
            if (attach.getMimeType() != null) continue;
            throw new IllegalArgumentException("P\u0159\u00edloha nem\u00e1 vypln\u011bn\u00fd MIME type.");
        }
    }
}

