/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.impl;

import cz.abclinuxu.datoveschranky.common.DataBoxException;
import cz.abclinuxu.datoveschranky.common.entities.Hash;
import cz.abclinuxu.datoveschranky.common.entities.TimeStamp;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.AlgorithmNameFinder;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    private final AlgorithmNameFinder algorithmNameFinder = new DefaultAlgorithmNameFinder();
    private Collection<X509Certificate> certs = null;
    private boolean isValidating = false;
    private Logger logger = Logger.getLogger((String)Validator.class.getCanonicalName());

    public Validator(Collection<X509Certificate> certs, boolean validating) {
        this.certs = certs;
        this.isValidating = validating;
    }

    public Validator() {
        this.certs = new ArrayList<X509Certificate>();
        this.isValidating = false;
    }

    public TimeStamp readTimeStamp(byte[] timeStamp) {
        try {
            CMSSignedData data = new CMSSignedData(timeStamp);
            TimeStampToken tst = new TimeStampToken(data);
            TimeStampTokenInfo tsti = tst.getTimeStampInfo();
            X509Certificate cert = this.findCertificate(tst.getSID());
            if (this.isValidating) {
                try {
                    SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert);
                    tst.validate(verifier);
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new DataBoxException(ex.toString(), ex);
                }
            }
            String algo = this.algorithmNameFinder.getAlgorithmName(tsti.getHashAlgorithm());
            byte[] hash = tsti.getMessageImprintDigest();
            return new TimeStamp(new Hash(algo, hash), cert, tsti.getGenTime());
        }
        catch (CMSException ex) {
            throw new DataBoxException("Chyba pri cteni casoveho razitka.", (Exception)((Object)ex));
        }
        catch (TSPException ioe) {
            throw new DataBoxException("Chyba pri cteni casoveho razitka.", (Exception)((Object)ioe));
        }
        catch (IOException ioe) {
            throw new DataBoxException("IO chyba pri cteni casoveho razitka.", ioe);
        }
    }

    public byte[] readPKCS7(byte[] signedBytes) throws DataBoxException {
        try {
            CMSSignedData data = new CMSSignedData(signedBytes);
            this.verifySignature(data);
            CMSTypedData signedContent = data.getSignedContent();
            return (byte[])signedContent.getContent();
        }
        catch (Exception ex) {
            throw new DataBoxException("Nemohu otevrit PKCS#7 obalku.", ex);
        }
    }

    public InputStream readPKCS7(InputStream is) throws DataBoxException {
        try {
            CMSSignedData data = new CMSSignedData(is);
            CMSTypedData signedContent = data.getSignedContent();
            this.verifySignature(data);
            return (InputStream)signedContent.getContent();
        }
        catch (Exception ex) {
            throw new DataBoxException("Nemohu otevrit PKCS#7 obalku.", ex);
        }
    }

    private void verifySignature(CMSSignedData data) throws Exception {
        if (this.isValidating) {
            SignerInformationStore signerStore = data.getSignerInfos();
            Collection signers = signerStore.getSigners();
            for (SignerInformation signer : signers) {
                X509Certificate cert = this.findCertificate(signer.getSID());
                if (cert == null) {
                    throw new DataBoxException("Nemohu najit certifikat.");
                }
                SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert);
                if (signer.verify(verifier)) continue;
                throw new DataBoxException("Nemohu overit oproti certifikatu stazenou zpravu.");
            }
        }
    }

    private X509Certificate findCertificate(SignerId signer) {
        JcaX509CertSelectorConverter converter = new JcaX509CertSelectorConverter();
        this.logger.debug((Object)("Hledam certifikat pro " + String.valueOf(signer)));
        return converter.getCertSelector(signer).getCertificate();
    }

    static {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        Security.addProvider((Provider)provider);
    }
}

