/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky;

import cz.abclinuxu.datoveschranky.AttachmentTableModel;
import cz.abclinuxu.datoveschranky.MessageTableModel;
import cz.abclinuxu.datoveschranky.common.entities.Attachment;
import cz.abclinuxu.datoveschranky.common.entities.Message;
import cz.abclinuxu.datoveschranky.common.entities.content.Content;
import cz.abclinuxu.datoveschranky.common.entities.content.FileContent;
import cz.abclinuxu.datoveschranky.common.impl.ByteArrayAttachmentStorer;
import cz.abclinuxu.datoveschranky.common.impl.Config;
import cz.abclinuxu.datoveschranky.common.impl.Utils;
import cz.abclinuxu.datoveschranky.common.interfaces.AttachmentStorer;
import cz.abclinuxu.datoveschranky.impl.MessageValidator;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MessageViewer
extends JFrame {
    private final JFileChooser chooseFile = new JFileChooser();
    private final JFileChooser saveAttachment = new JFileChooser();
    private final Logger logger = Logger.getLogger(MessageViewer.class.getCanonicalName());
    private final MessageValidator validator;
    private File openedFile = null;
    private JMenu attachmentMenu;
    private JTable attachmentsTable;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JInternalFrame jInternalFrame1;
    private JInternalFrame jInternalFrame2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JMenuBar menuBar;
    private JTable messageInfo;
    private JMenuItem openMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveAttachmentMenuItem;

    public MessageViewer() {
        this.initComponents();
        super.setTitle("Message Viewer");
        Config config = new Config("ws1.mojedatovaschranka.cz");
        this.validator = new MessageValidator(config);
        this.attachmentsTable.getSelectionModel().addListSelectionListener(new SelectionListener(this.attachmentsTable));
        this.attachmentsTable.setSelectionMode(0);
        this.attachmentMenu.setEnabled(false);
        this.saveAsMenuItem.setEnabled(false);
    }

    private void showFile(File file) {
        this.openedFile = file;
        FileContent content = new FileContent(file);
        try {
            Message mess = this.validator.createMessage((Content)content, (AttachmentStorer)new ByteArrayAttachmentStorer());
            this.messageInfo.setModel(new MessageTableModel(file, mess));
            this.attachmentsTable.setModel(new AttachmentTableModel(mess.getAttachments()));
            this.attachmentMenu.setEnabled(false);
            this.saveAsMenuItem.setEnabled(true);
        }
        catch (Exception ioe) {
            this.showError("Nemohu otev\u0159\u00edt sta\u017eenou zpr\u00e1vu. Jedn\u00e1 se opravdu o podepsanou zpr\u00e1vu z Datov\u00e9 schr\u00e1nky?");
            this.logger.log(Level.SEVERE, "Nemohu zobrazit zpravu.", ioe);
        }
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private void initComponents() {
        this.jInternalFrame1 = new JInternalFrame();
        this.jScrollPane1 = new JScrollPane();
        this.messageInfo = new JTable();
        this.jInternalFrame2 = new JInternalFrame();
        this.jScrollPane2 = new JScrollPane();
        this.attachmentsTable = new JTable();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.attachmentMenu = new JMenu();
        this.saveAttachmentMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.jInternalFrame1.setResizable(true);
        this.jInternalFrame1.setTitle("Ob\u00e1lka zpr\u00e1vy");
        this.jInternalFrame1.setVisible(true);
        this.messageInfo.setModel(new MessageTableModel());
        this.jScrollPane1.setViewportView(this.messageInfo);
        GroupLayout jInternalFrame1Layout = new GroupLayout(this.jInternalFrame1.getContentPane());
        this.jInternalFrame1.getContentPane().setLayout(jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 482, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 205, Short.MAX_VALUE));
        this.jInternalFrame2.setResizable(true);
        this.jInternalFrame2.setTitle("P\u0159\u00edlohy zpr\u00e1vy");
        this.jInternalFrame2.setVisible(true);
        this.attachmentsTable.setModel(new AttachmentTableModel());
        this.jScrollPane2.setViewportView(this.attachmentsTable);
        GroupLayout jInternalFrame2Layout = new GroupLayout(this.jInternalFrame2.getContentPane());
        this.jInternalFrame2.getContentPane().setLayout(jInternalFrame2Layout);
        jInternalFrame2Layout.setHorizontalGroup(jInternalFrame2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 482, Short.MAX_VALUE));
        jInternalFrame2Layout.setVerticalGroup(jInternalFrame2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 176, Short.MAX_VALUE));
        this.fileMenu.setText("Soubor");
        this.openMenuItem.setText("Otev\u0159\u00edt");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageViewer.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveAsMenuItem.setText("Ulo\u017eit jako");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageViewer.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.exitMenuItem.setText("Konec");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageViewer.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.attachmentMenu.setText("P\u0159\u00edloha");
        this.saveAttachmentMenuItem.setText("Ulo\u017eit jako");
        this.saveAttachmentMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MessageViewer.this.saveAttachmentMenuItemActionPerformed(evt);
            }
        });
        this.attachmentMenu.add(this.saveAttachmentMenuItem);
        this.menuBar.add(this.attachmentMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jInternalFrame2).addComponent(this.jInternalFrame1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jInternalFrame1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jInternalFrame2, -2, -1, -2)));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        int result = this.chooseFile.showOpenDialog(this);
        if (result == 0) {
            File file = this.chooseFile.getSelectedFile();
            this.showFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAttachmentMenuItemActionPerformed(ActionEvent evt) {
        int row = this.attachmentsTable.getSelectedRow();
        if (row == -1) {
            this.showError("\u017d\u00e1dn\u00e1 p\u0159\u00edloha nen\u00ed vybr\u00e1na.");
            return;
        }
        List<Attachment> attachments = ((AttachmentTableModel)this.attachmentsTable.getModel()).getData();
        Attachment attachment = attachments.get(row);
        this.saveAttachment.setSelectedFile(new File(attachment.getDescription()));
        int result = this.saveAttachment.showSaveDialog(this);
        if (result == 0) {
            File file = this.saveAttachment.getSelectedFile();
            InputStream in = null;
            FileOutputStream out = null;
            try {
                try {
                    in = attachment.getContent().getInputStream();
                    out = new FileOutputStream(file);
                    Utils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    Utils.close((Closeable[])new Closeable[]{in, out});
                    throw throwable;
                }
                Utils.close((Closeable[])new Closeable[]{in, out});
            }
            catch (Exception ex) {
                this.showError("Nemohu ulo\u017eit p\u0159\u00edlohu do souboru.");
                this.logger.log(Level.SEVERE, "Nemohu ulozit prilohu do souboru.", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        int result = this.saveAttachment.showSaveDialog(this);
        if (result == 0) {
            File file = this.saveAttachment.getSelectedFile();
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                try {
                    in = new FileInputStream(this.openedFile);
                    out = new FileOutputStream(file);
                    Utils.copy((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    Utils.close((Closeable[])new Closeable[]{in, out});
                    throw throwable;
                }
                Utils.close((Closeable[])new Closeable[]{in, out});
            }
            catch (Exception ex) {
                this.showError("Nemohu ulo\u017eit zpr\u00e1vu do souboru.");
                this.logger.log(Level.SEVERE, "Nemohu ulozit zpravu do souboru.", ex);
            }
        }
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MessageViewer app = new MessageViewer();
                app.setVisible(true);
                if (args.length == 1) {
                    app.showFile(new File(args[0]));
                }
            }
        });
    }

    private class SelectionListener
    implements ListSelectionListener {
        private JTable table;

        public SelectionListener(JTable table) {
            this.table = table;
        }

        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            MessageViewer.this.attachmentMenu.setEnabled(this.table.getSelectedRow() != -1);
        }
    }
}

