/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky;

import cz.abclinuxu.datoveschranky.common.entities.DocumentIdent;
import cz.abclinuxu.datoveschranky.common.entities.Message;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageTableModel
extends AbstractTableModel {
    private final List<List<String>> table;

    public MessageTableModel() {
        this.table = Collections.emptyList();
    }

    public MessageTableModel(File file, Message mess) {
        this.table = new ArrayList<List<String>>();
        MessageEnvelope envelope = mess.getEnvelope();
        this.table.add(MessageTableModel.pair("Soubor", file.getAbsolutePath()));
        this.table.add(MessageTableModel.pair("Jm\u00e9no odes\u00edlatele", envelope.getSender().getIdentity()));
        this.table.add(MessageTableModel.pair("Adresa odes\u00edlatele", envelope.getSender().getAddress()));
        this.table.add(MessageTableModel.pair("Jm\u00e9no p\u0159\u00edjemce", envelope.getRecipient().getIdentity()));
        this.table.add(MessageTableModel.pair("Adresa p\u0159\u00edjemce", envelope.getRecipient().getAddress()));
        this.table.add(MessageTableModel.pair("ID zpr\u00e1vy", envelope.getMessageID()));
        this.table.add(MessageTableModel.pair("P\u0159edm\u011bt zpr\u00e1vy", envelope.getAnnotation()));
        this.table.add(MessageTableModel.pair("Ozna\u010den\u00ed odes\u00edlatele", MessageTableModel.ident(envelope.getSenderIdent())));
        this.table.add(MessageTableModel.pair("Ozna\u010den\u00ed p\u0159\u00edjemce", MessageTableModel.ident(envelope.getRecipientIdent())));
        if (mess.getTimeStamp() != null) {
            this.table.add(MessageTableModel.pair("Otisk zpr\u00e1vy", mess.getTimeStamp().getHash().toString()));
        }
    }

    private static List<String> pair(String a, String b) {
        return Arrays.asList(a, b);
    }

    private static String ident(DocumentIdent ident) {
        if (ident != null && ident.getIdent() != null && ident.getRefNumber() != null) {
            return ident.getIdent() + "/" + ident.getRefNumber();
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.table.size();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "atribut";
            }
            case 1: {
                return "hodnota";
            }
        }
        throw new AssertionError((Object)"table has only two columns");
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.table.get(row).get(col);
    }
}

