/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.tinyDB.responseparsers;

import cz.abclinuxu.datoveschranky.common.Utils;
import cz.abclinuxu.datoveschranky.common.entities.Attachment;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.interfaces.AttachmentStorer;
import cz.abclinuxu.datoveschranky.tinyDB.holders.OutputHolder;
import cz.abclinuxu.datoveschranky.tinyDB.holders.OutputStreamHolder;
import cz.abclinuxu.datoveschranky.tinyDB.responseparsers.AbstractResponseParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadReceivedMessage
extends AbstractResponseParser {
    private Attachment attachment = null;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private AttachmentStorer storer = null;
    private MessageEnvelope envelope = null;

    public DownloadReceivedMessage(MessageEnvelope env, AttachmentStorer attachStorer) {
        this.envelope = env;
        this.storer = attachStorer;
    }

    @Override
    public OutputHolder startElementImpl(String elName, Attributes attributes) {
        if ("dmFile".equals(elName)) {
            this.attachment = new Attachment();
            this.attachment.setDescription(attributes.getValue("dmFileDescr"));
            this.attachment.setMetaType(attributes.getValue("dmFileMetaType"));
            this.attachment.setMimeType(attributes.getValue("dmMimeType"));
        }
        if ("dmEncodedContent".equals(elName)) {
            try {
                OutputStream os = this.storer.store(this.envelope, this.attachment);
                this.attachments.add(this.attachment);
                Base64OutputStream bos = new Base64OutputStream(os, false, 0, null);
                OutputStreamHolder input = new OutputStreamHolder((OutputStream)bos);
                return input;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Nemohu otevrit soubor", ioe);
            }
        }
        return null;
    }

    @Override
    public void endElementImpl(String elName, OutputHolder handle) {
        if (handle instanceof Closeable) {
            Utils.close((Closeable[])new Closeable[]{(Closeable)((Object)handle)});
        }
    }

    public List<Attachment> getResult() {
        return this.attachments;
    }
}

