/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.tinyDB;

import cz.abclinuxu.datoveschranky.tinyDB.holders.OutputHolder;
import cz.abclinuxu.datoveschranky.tinyDB.responseparsers.ResponseParser;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser
extends DefaultHandler {
    private Stack<State> path = new Stack();
    private ResponseParser delegate;

    public SimpleSAXParser(ResponseParser parser) {
        this.delegate = parser;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String elementName = qName.substring(qName.lastIndexOf(58) + 1).intern();
        OutputHolder handler = this.delegate.startElement(elementName, attributes);
        this.path.push(new State(elementName, handler));
    }

    public void characters(char[] array, int start, int length) throws SAXException {
        OutputHolder handler = this.state().handler;
        if (handler != null) {
            handler.write(array, start, length);
        }
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        State state = this.state();
        this.delegate.endElement(state.element, state.handler);
        this.path.pop();
    }

    private State state() {
        return this.path.peek();
    }

    public void endDocument() throws SAXException {
        this.delegate.done();
    }

    private static class State {
        public String element = null;
        public OutputHolder handler = null;

        public State(String el, OutputHolder handler) {
            this.element = el;
            this.handler = handler;
        }
    }
}

