/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.tinyDB.holders;

import cz.abclinuxu.datoveschranky.common.Utils;
import cz.abclinuxu.datoveschranky.tinyDB.holders.OutputHolder;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamHolder
implements OutputHolder<OutputStream>,
Closeable {
    private final OutputStream os;
    private final BufferedWriter bw;

    public OutputStreamHolder(OutputStream os) {
        this.os = os;
        this.bw = new BufferedWriter(new OutputStreamWriter(os));
    }

    @Override
    public void write(char[] array, int start, int length) {
        try {
            this.bw.write(array, start, length);
            this.bw.flush();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Nemohu zapisovat do bufferu", ioe);
        }
    }

    @Override
    public OutputStream getResult() {
        return this.os;
    }

    @Override
    public void close() {
        Utils.close((Closeable[])new Closeable[]{this.bw, this.os});
    }
}

