/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.tinyDB.responseparsers;

import cz.abclinuxu.datoveschranky.common.Status;
import cz.abclinuxu.datoveschranky.tinyDB.holders.OutputHolder;
import cz.abclinuxu.datoveschranky.tinyDB.holders.StringHolder;
import cz.abclinuxu.datoveschranky.tinyDB.responseparsers.ResponseParser;
import java.util.HashMap;
import org.xml.sax.Attributes;

public abstract class AbstractResponseParser
implements ResponseParser {
    private static final boolean debug = false;
    private static final int MAX_DEPTH = 128;
    private static final String[] wanting = new String[]{"dmStatusCode", "dmStatusMessage"};
    private String[] path = new String[128];
    private int pathIndex = 0;
    private HashMap<String, StringHolder> map = new HashMap();
    private Status status = null;

    public AbstractResponseParser() {
        for (String key : wanting) {
            this.map.put(key, new StringHolder());
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void done() {
        String dmStatusCode = this.map.get("dmStatusCode").toString();
        String dmStatusMessage = this.map.get("dmStatusMessage").toString();
        this.status = new Status(dmStatusCode, dmStatusMessage);
    }

    public OutputHolder startElement(String elName, Attributes attributes) {
        this.path[this.pathIndex] = elName.intern();
        ++this.pathIndex;
        OutputHolder handle = this.map.get(elName);
        if (handle == null) {
            return this.startElementImpl(elName, attributes);
        }
        return handle;
    }

    public void endElement(String elName, OutputHolder handle) {
        if (!this.map.containsKey(elName)) {
            this.endElementImpl(elName, handle);
        }
        this.path[this.pathIndex] = null;
        --this.pathIndex;
    }

    public boolean match(String ... args) {
        if (this.pathIndex >= args.length) {
            int start = this.pathIndex - args.length;
            for (int i = 0; i != args.length; ++i) {
                String a = this.path[start + i];
                String b = args[i];
                if ("*".equals(b) || a.equals(b)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String dumpState() {
        StringBuffer result = new StringBuffer("/");
        for (int i = 0; i != this.pathIndex; ++i) {
            result.append(this.path[i]);
            result.append("/");
        }
        return result.toString();
    }

    public abstract OutputHolder startElementImpl(String var1, Attributes var2);

    public abstract void endElementImpl(String var1, OutputHolder var2);
}

