/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.tinyDB;

import cz.abclinuxu.datoveschranky.common.Config;
import cz.abclinuxu.datoveschranky.common.FileAttachmentStorer;
import cz.abclinuxu.datoveschranky.common.Utils;
import cz.abclinuxu.datoveschranky.common.entities.Attachment;
import cz.abclinuxu.datoveschranky.common.entities.DataBox;
import cz.abclinuxu.datoveschranky.common.entities.Hash;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.interfaces.AttachmentStorer;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxDownloadService;
import cz.abclinuxu.datoveschranky.common.interfaces.DataBoxMessagesService;
import cz.abclinuxu.datoveschranky.tinyDB.DataBoxManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            String readMe = Utils.readResourceAsString(Main.class, (String)"/readme.txt");
            System.err.println(readMe);
            System.exit(1);
        }
        String type = args[0];
        String loginName = args[1];
        String password = args[2];
        String directory = args[3];
        Main.download(type, loginName, password, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(String type, String loginName, String password, String directory) throws Exception {
        File whereToPutFiles = new File(directory);
        String url = type.equals("production") ? "ws1.mojedatovaschranka.cz" : "ws1.czebox.cz";
        Config config = new Config(url);
        DataBoxManager services = DataBoxManager.login(config, loginName, password);
        DataBoxMessagesService messagesService = services.getDataBoxMessagesService();
        DataBoxDownloadService downloadService = services.getDataBoxDownloadService();
        GregorianCalendar begin = new GregorianCalendar();
        begin.roll(6, -28);
        GregorianCalendar end = new GregorianCalendar();
        end.roll(6, 1);
        List messages = messagesService.getListOfReceivedMessages(begin.getTime(), end.getTime(), null, 0, 15);
        FileAttachmentStorer storer = new FileAttachmentStorer(whereToPutFiles);
        for (MessageEnvelope envelope : messages) {
            FileOutputStream fos = new FileOutputStream(new File(whereToPutFiles, envelope.getMessageID() + ".bin"));
            try {
                downloadService.downloadSignedMessage(envelope, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            List attachments = downloadService.downloadMessage(envelope, (AttachmentStorer)storer).getAttachments();
            Hash hash = messagesService.verifyMessage(envelope);
            Main.print(envelope, attachments, hash);
        }
    }

    public static void print(MessageEnvelope envelope, List<Attachment> attachments, Hash hash) {
        String sep = "=======================================";
        sep = sep + sep;
        System.out.println(sep);
        DataBox sender = envelope.getSender();
        System.out.println(String.format("Odesilatel: %s (%s)", sender.getIdentity(), sender.getAddress()));
        System.out.println("Jednoznacne ID zpravy: " + envelope.getMessageID());
        System.out.println("Predmet zpravy: " + envelope.getAnnotation());
        System.out.println("Zprava byla prijata: " + envelope.getDeliveryTime().getTime());
        System.out.println("Zprava byla akceptovana: " + envelope.getAcceptanceTime().getTime());
        System.out.println("Hash zpravy je: " + hash);
        System.out.println("Seznam priloh zpravy:");
        for (Attachment attachment : attachments) {
            System.out.println("       " + attachment.getDescription() + " -> " + attachment.getContent().toString());
        }
        System.out.println(sep);
    }
}

