/*
 * Decompiled with CFR 0.152.
 */
package cz.abclinuxu.datoveschranky.tinyDB.responseparsers;

import cz.abclinuxu.datoveschranky.common.entities.DataBox;
import cz.abclinuxu.datoveschranky.common.entities.MessageEnvelope;
import cz.abclinuxu.datoveschranky.common.entities.MessageType;
import cz.abclinuxu.datoveschranky.tinyDB.XMLUtils;
import cz.abclinuxu.datoveschranky.tinyDB.holders.OutputHolder;
import cz.abclinuxu.datoveschranky.tinyDB.holders.StringHolder;
import cz.abclinuxu.datoveschranky.tinyDB.responseparsers.AbstractResponseParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetListOfReceivedMessages
extends AbstractResponseParser {
    private static final String[] wanting = new String[]{"dbIDSender", "dmSender", "dmSenderAddress", "dbIDRecipient", "dmRecipient", "dmRecipientAddress", "dmID", "dmAnnotation", "dmDeliveryTime", "dmAcceptanceTime"};
    private HashMap<String, StringHolder> map = new HashMap();
    private List<MessageEnvelope> messages = new ArrayList<MessageEnvelope>();

    public GetListOfReceivedMessages() {
        this.fillMap();
    }

    @Override
    public OutputHolder startElementImpl(String elName, Attributes attributes) {
        OutputHolder handle = null;
        if (super.match("dmRecords", "dmRecord", "*")) {
            handle = this.map.get(elName);
        }
        return handle;
    }

    @Override
    public void endElementImpl(String elName, OutputHolder handle) {
        if (super.match("dmRecords", "dmRecord")) {
            String delivered;
            String senderID = this.map.get("dbIDSender").toString();
            String senderName = this.map.get("dmSender").toString();
            String senderAddress = this.map.get("dmSenderAddress").toString();
            DataBox sender = new DataBox(senderID, senderName, senderAddress);
            String recipientID = this.map.get("dbIDRecipient").toString();
            String recipientName = this.map.get("dmRecipient").toString();
            String recipientAdress = this.map.get("dmRecipientAddress").toString();
            DataBox recipient = new DataBox(recipientID, recipientName, recipientAdress);
            String dmAnnotation = this.map.get("dmAnnotation").toString();
            String messageID = this.map.get("dmID").toString();
            MessageEnvelope env = new MessageEnvelope(MessageType.RECEIVED, sender, recipient, messageID, dmAnnotation);
            String accepted = this.map.get("dmAcceptanceTime").toString();
            if (accepted != null && !accepted.equals("")) {
                env.setAcceptanceTime(XMLUtils.toGregorianCalendar(accepted));
            }
            if ((delivered = this.map.get("dmDeliveryTime").toString()) != null && !delivered.equals("")) {
                env.setDeliveryTime(XMLUtils.toGregorianCalendar(delivered));
            }
            this.messages.add(env);
            this.fillMap();
        }
    }

    public List<MessageEnvelope> getMessages() {
        return this.messages;
    }

    private void fillMap() {
        this.map.clear();
        for (String key : wanting) {
            this.map.put(key, new StringHolder());
        }
    }
}

