/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.data.common.domain;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dozer.CustomConverter;
import org.dozer.MappingException;

public class DateToXmlGregorianCalendarCustomConverter
implements CustomConverter {
    public Object convert(Object destination, Object source, Class<?> destClass, Class<?> sourceClass) {
        if (source == null) {
            return null;
        }
        if (source instanceof Date) {
            Date date = (Date)source;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(format.format(date));
            }
            catch (DatatypeConfigurationException e) {
                throw new MappingException("Unable to get XML gregorian date for input " + date);
            }
        }
        if (source instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xmlDate = (XMLGregorianCalendar)source;
            return xmlDate.toGregorianCalendar().getTime();
        }
        throw new MappingException("Converter " + this.getClass().getSimpleName() + " used incorrectly!");
    }
}

