/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.data.list;

import cz.active24.client.fred.data.list.ListResponse;
import cz.active24.client.fred.data.list.ListResultsResponse;
import cz.active24.client.fred.eppclient.EppClient;
import cz.active24.client.fred.eppclient.EppCommandHelper;
import cz.active24.client.fred.exception.FredClientException;
import cz.nic.xml.epp.fred_1.ExtcommandType;
import cz.nic.xml.epp.fred_1.InfoResponseT;
import cz.nic.xml.epp.fred_1.ResultsListT;
import ietf.params.xml.ns.epp_1.EppType;
import ietf.params.xml.ns.epp_1.ResponseType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ListResultsHelper {
    private static final Log log = LogFactory.getLog(ListResultsHelper.class);
    private EppClient client;
    private EppCommandHelper eppCommandHelper;

    public ListResultsHelper(EppClient client, EppCommandHelper eppCommandHelper) {
        this.client = client;
        this.eppCommandHelper = eppCommandHelper;
    }

    public ListResponse prepareListAndGetResults(ExtcommandType extcommandType) throws FredClientException {
        if (extcommandType == null) {
            return new ListResultsResponse();
        }
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createFredExtensionEppCommand(extcommandType);
        ResponseType responseType = this.client.execute(requestElement);
        InfoResponseT countResponse = (InfoResponseT)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        if (countResponse.getCount().intValue() > 0) {
            return this.getResults(responseType.getTrID().getClTRID());
        }
        ListResultsResponse result = new ListResultsResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    private ListResponse getResults(String clientTransactionId) throws FredClientException {
        log.debug((Object)("getResults called for client transaction id " + clientTransactionId));
        ListResultsResponse result = new ListResultsResponse();
        boolean returnedListEmpty = false;
        do {
            ExtcommandType extcommandType = new ExtcommandType();
            extcommandType.setGetResults("");
            extcommandType.setClTRID(clientTransactionId);
            JAXBElement<EppType> requestElement = this.eppCommandHelper.createFredExtensionEppCommand(extcommandType);
            ResponseType responseType = this.client.execute(requestElement);
            result.addResponseInfo(responseType);
            if (responseType.getResData() == null) continue;
            ResultsListT resultsListT = (ResultsListT)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
            result.getResults().addAll(resultsListT.getItem());
            returnedListEmpty = resultsListT.getItem().isEmpty();
        } while (!returnedListEmpty);
        return result;
    }
}

