/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient;

import cz.active24.client.fred.eppclient.EppClient;
import cz.active24.client.fred.eppclient.EppClientMarshallerHelper;
import cz.active24.client.fred.eppclient.EppCommandHelper;
import cz.active24.client.fred.eppclient.ErrorResponse;
import cz.active24.client.fred.exception.FredClientException;
import cz.active24.client.fred.exception.ServerResponseException;
import cz.active24.client.fred.exception.SystemException;
import ietf.params.xml.ns.epp_1.CredsOptionsType;
import ietf.params.xml.ns.epp_1.EppType;
import ietf.params.xml.ns.epp_1.GreetingType;
import ietf.params.xml.ns.epp_1.LoginSvcType;
import ietf.params.xml.ns.epp_1.LoginType;
import ietf.params.xml.ns.epp_1.ObjectFactory;
import ietf.params.xml.ns.epp_1.ResponseType;
import ietf.params.xml.ns.epp_1.ResultType;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EppClientImpl
implements EppClient {
    private static final Log log = LogFactory.getLog(EppClientImpl.class);
    private static EppClientImpl eppClient;
    private static final int HEADER = 4;
    private SSLSocket socket;
    private BufferedInputStream reader;
    private BufferedOutputStream writer;
    private Properties properties;
    private EppClientMarshallerHelper marshallerHelper;
    private EppCommandHelper eppCommandHelper;

    private EppClientImpl(Properties properties) {
        this.properties = properties;
        this.marshallerHelper = new EppClientMarshallerHelper(properties);
        this.eppCommandHelper = new EppCommandHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EppClientImpl getInstance(Properties properties) {
        if (eppClient != null) return eppClient;
        Class<EppClientImpl> clazz = EppClientImpl.class;
        synchronized (EppClientImpl.class) {
            if (eppClient != null) return eppClient;
            eppClient = new EppClientImpl(properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return eppClient;
        }
    }

    @Override
    public ResponseType login(String newPw, String clientTransactionId) throws FredClientException {
        if (this.isConnected()) {
            this.disconnect();
        }
        return this.initialize(newPw, clientTransactionId);
    }

    @Override
    public ResponseType logout(String clientTransactionId) throws FredClientException {
        JAXBElement<EppType> logout = this.eppCommandHelper.createLogoutEppCommand(clientTransactionId);
        ResponseType response = this.execute(logout);
        this.disconnect();
        return response;
    }

    @Override
    public ResponseType execute(JAXBElement<EppType> request) throws FredClientException {
        String xml = this.marshallerHelper.marshal(request);
        this.checkSession();
        String response = this.proceedCommand(xml);
        EppType eppType = this.marshallerHelper.unmarshal(response);
        ResponseType responseType = eppType.getResponse();
        this.evaluateResponse(responseType);
        return responseType;
    }

    private void evaluateResponse(ResponseType responseType) throws ServerResponseException {
        ArrayList<ErrorResponse> errorResponses = new ArrayList<ErrorResponse>();
        for (ResultType result : responseType.getResult()) {
            if (!ErrorResponse.getAllErrorCodes().contains(result.getCode())) continue;
            errorResponses.add(ErrorResponse.fromValue(result.getCode()));
        }
        if (!errorResponses.isEmpty()) {
            throw new ServerResponseException(errorResponses);
        }
    }

    private void checkSession() throws FredClientException {
        if (!this.isConnected()) {
            log.debug((Object)"Connection not established or wrong, try to initialize");
            this.initialize(null, null);
        }
    }

    private boolean isConnected() {
        GreetingType greeting;
        if (this.reader == null || this.writer == null || this.socket == null) {
            return false;
        }
        try {
            greeting = this.hello();
        }
        catch (FredClientException e) {
            log.error((Object)"Checking with hello failed, we are not connected, returning false!");
            return false;
        }
        return greeting != null;
    }

    private GreetingType hello() throws FredClientException {
        ObjectFactory objectFactory = new ObjectFactory();
        EppType eppType = objectFactory.createEppType();
        eppType.setHello("");
        JAXBElement<EppType> hello = objectFactory.createEpp(eppType);
        String xml = this.marshallerHelper.marshal(hello);
        String response = this.proceedCommand(xml);
        EppType responseEppType = this.marshallerHelper.unmarshal(response);
        return responseEppType.getGreeting();
    }

    private ResponseType initialize(String newPw, String clientTransactionId) throws FredClientException {
        try {
            this.connect();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
        String greetingXml = this.read();
        EppType eppType = this.marshallerHelper.unmarshal(greetingXml);
        return this.login(eppType.getGreeting(), newPw, clientTransactionId);
    }

    private void connect() throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        String sslContextInstance = this.properties.getProperty("sslsocket.instance");
        String keyStoreInstance = this.properties.getProperty("keystore.instance");
        String certificateFile = this.properties.getProperty("certificate.file");
        String certificatePassword = this.properties.getProperty("certificate.secret");
        String keyManagerInstance = this.properties.getProperty("keymanager.instance");
        String server = this.properties.getProperty("host");
        String port = this.properties.getProperty("port");
        String timeout = this.properties.getProperty("timeout");
        SSLContext sslContext = SSLContext.getInstance(sslContextInstance);
        KeyStore keyStore = KeyStore.getInstance(keyStoreInstance);
        keyStore.load(new FileInputStream(certificateFile), certificatePassword.toCharArray());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerInstance);
        keyManagerFactory.init(keyStore, certificatePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(keyManagerInstance);
        tmf.init(keyStore);
        TrustManager[] tm = tmf.getTrustManagers();
        sslContext.init(keyManagerFactory.getKeyManagers(), tm, null);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        this.socket = (SSLSocket)sslSocketFactory.createSocket(server, Integer.parseInt(port));
        this.socket.startHandshake();
        this.socket.setSoTimeout(Integer.parseInt(timeout));
        this.reader = new BufferedInputStream(this.socket.getInputStream());
        this.writer = new BufferedOutputStream(this.socket.getOutputStream());
        log.debug((Object)("Connected to: " + this.socket.getInetAddress()));
    }

    private ResponseType login(GreetingType greeting, String newPw, String clientTransactionId) throws FredClientException {
        String apiKey = this.properties.getProperty("apiKey.id");
        String apiKeyPassword = this.properties.getProperty("apiKey.secret");
        LoginType loginType = new LoginType();
        LoginSvcType loginSvcType = new LoginSvcType();
        loginSvcType.getObjURI().addAll(greeting.getSvcMenu().getObjURI());
        loginSvcType.setSvcExtension(greeting.getSvcMenu().getSvcExtension());
        loginType.setSvcs(loginSvcType);
        loginType.setClID(apiKey);
        loginType.setPw(apiKeyPassword);
        if (newPw != null && !newPw.isEmpty()) {
            loginType.setNewPW(newPw);
        }
        CredsOptionsType credsOptionsType = new CredsOptionsType();
        credsOptionsType.setLang(greeting.getSvcMenu().getLang().get(0));
        credsOptionsType.setVersion(greeting.getSvcMenu().getVersion().get(0));
        loginType.setOptions(credsOptionsType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createLoginEppCommand(loginType, clientTransactionId);
        return this.execute(requestElement);
    }

    private void disconnect() throws SystemException {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            if (eppClient != null) {
                eppClient = null;
            }
        }
        catch (IOException e) {
            log.debug((Object)"Unable to close socket");
            throw new SystemException("Unable to close socket");
        }
        finally {
            this.socket = null;
            this.reader = null;
            this.writer = null;
            eppClient = null;
        }
    }

    private synchronized String proceedCommand(String xmlCommand) throws FredClientException {
        log.debug((Object)("REQUEST:\n" + xmlCommand));
        this.write(xmlCommand);
        String xmlResponse = this.read();
        log.debug((Object)("RESPONSE:\n" + xmlResponse));
        return xmlResponse;
    }

    private synchronized void write(String xml) throws SystemException {
        try {
            byte[] byteArr = xml.getBytes("UTF-8");
            this.writeBufferSize(byteArr.length + 4);
            this.writer.write(byteArr, 0, byteArr.length);
            this.writer.flush();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    private synchronized void writeBufferSize(int buf_sz) throws IOException {
        byte[] out_buf = new byte[]{(byte)(0xFF & buf_sz >> 24), (byte)(0xFF & buf_sz >> 16), (byte)(0xFF & buf_sz >> 8), (byte)(0xFF & buf_sz)};
        this.writer.write(out_buf, 0, 4);
    }

    private synchronized String read() throws FredClientException {
        int len = this.readBufferSize();
        if ((len -= 4) < 0) {
            String message = "Length of response without header cant be negative!";
            log.error((Object)message);
            throw new SystemException(message);
        }
        return this.readInputBuffer(len);
    }

    private synchronized int readBufferSize() throws SystemException {
        int len;
        byte[] in_buf = new byte[4];
        for (int bytesRead = 0; bytesRead < 4; bytesRead += len) {
            try {
                len = this.reader.read(in_buf, bytesRead, 4 - bytesRead);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new SystemException(e.getMessage(), e);
            }
            if (len >= 0) continue;
            String message = "EOF reading buffer size!";
            log.error((Object)message);
            throw new SystemException(message);
        }
        return (in_buf[0] & 0xFF) << 24 | (in_buf[1] & 0xFF) << 16 | (in_buf[2] & 0xFF) << 8 | in_buf[3] & 0xFF;
    }

    private synchronized String readInputBuffer(int length) throws FredClientException {
        StringBuilder sb = new StringBuilder();
        try {
            int totalBytesRead;
            int bytesRead;
            ByteArrayOutputStream wholeMessage = new ByteArrayOutputStream();
            for (totalBytesRead = 0; length != totalBytesRead; totalBytesRead += bytesRead) {
                byte[] buffer = new byte[128];
                bytesRead = this.reader.read(buffer);
                wholeMessage.write(buffer);
            }
            sb.append(new String(wholeMessage.toByteArray(), 0, totalBytesRead, "UTF-8"));
            return sb.toString();
        }
        catch (IOException e) {
            String message = "Problem while reading input stream, disconnecting! Corrupted message: " + sb.toString();
            log.error((Object)message);
            throw new SystemException(message);
        }
    }
}

