/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient.objectstrategy;

import cz.active24.client.fred.data.check.CheckRequest;
import cz.active24.client.fred.data.check.CheckResponse;
import cz.active24.client.fred.data.check.domain.DomainCheckRequest;
import cz.active24.client.fred.data.check.domain.DomainCheckResponse;
import cz.active24.client.fred.data.common.domain.EnumValData;
import cz.active24.client.fred.data.create.CreateRequest;
import cz.active24.client.fred.data.create.CreateResponse;
import cz.active24.client.fred.data.create.domain.DomainCreateRequest;
import cz.active24.client.fred.data.create.domain.DomainCreateResponse;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoRequest;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoResponse;
import cz.active24.client.fred.data.delete.DeleteRequest;
import cz.active24.client.fred.data.delete.DeleteResponse;
import cz.active24.client.fred.data.delete.domain.DomainDeleteRequest;
import cz.active24.client.fred.data.delete.domain.DomainDeleteResponse;
import cz.active24.client.fred.data.info.InfoRequest;
import cz.active24.client.fred.data.info.InfoResponse;
import cz.active24.client.fred.data.info.domain.DomainInfoRequest;
import cz.active24.client.fred.data.info.domain.DomainInfoResponse;
import cz.active24.client.fred.data.list.ListRequest;
import cz.active24.client.fred.data.list.ListResponse;
import cz.active24.client.fred.data.list.ListResultsHelper;
import cz.active24.client.fred.data.list.ListType;
import cz.active24.client.fred.data.list.domain.DomainsByContactListRequest;
import cz.active24.client.fred.data.list.domain.DomainsByKeysetListRequest;
import cz.active24.client.fred.data.list.domain.DomainsByNssetListRequest;
import cz.active24.client.fred.data.list.domain.DomainsListRequest;
import cz.active24.client.fred.data.login.other.LoginRequest;
import cz.active24.client.fred.data.login.other.LoginResponse;
import cz.active24.client.fred.data.logout.other.LogoutRequest;
import cz.active24.client.fred.data.logout.other.LogoutResponse;
import cz.active24.client.fred.data.poll.PollAcknowledgementRequest;
import cz.active24.client.fred.data.poll.PollAcknowledgementResponse;
import cz.active24.client.fred.data.poll.PollRequest;
import cz.active24.client.fred.data.poll.PollResponse;
import cz.active24.client.fred.data.renew.domain.DomainRenewRequest;
import cz.active24.client.fred.data.renew.domain.DomainRenewResponse;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoResponse;
import cz.active24.client.fred.data.sendauthinfo.domain.DomainSendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.domain.DomainSendAuthInfoResponse;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetRequest;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetResponse;
import cz.active24.client.fred.data.transfer.TransferRequest;
import cz.active24.client.fred.data.transfer.TransferResponse;
import cz.active24.client.fred.data.transfer.domain.DomainTransferRequest;
import cz.active24.client.fred.data.transfer.domain.DomainTransferResponse;
import cz.active24.client.fred.data.update.UpdateRequest;
import cz.active24.client.fred.data.update.UpdateResponse;
import cz.active24.client.fred.data.update.domain.DomainUpdateRequest;
import cz.active24.client.fred.data.update.domain.DomainUpdateResponse;
import cz.active24.client.fred.eppclient.EppClient;
import cz.active24.client.fred.eppclient.EppClientImpl;
import cz.active24.client.fred.eppclient.EppCommandHelper;
import cz.active24.client.fred.eppclient.objectstrategy.ServerObjectStrategy;
import cz.active24.client.fred.exception.FredClientException;
import cz.active24.client.fred.mapper.FredClientDozerMapper;
import cz.nic.xml.epp.domain_1.ChkDataType;
import cz.nic.xml.epp.domain_1.CreDataType;
import cz.nic.xml.epp.domain_1.CreateType;
import cz.nic.xml.epp.domain_1.InfDataType;
import cz.nic.xml.epp.domain_1.MNameType;
import cz.nic.xml.epp.domain_1.ObjectFactory;
import cz.nic.xml.epp.domain_1.RenDataType;
import cz.nic.xml.epp.domain_1.RenewType;
import cz.nic.xml.epp.domain_1.SNameType;
import cz.nic.xml.epp.domain_1.SendAuthInfoType;
import cz.nic.xml.epp.domain_1.TransferType;
import cz.nic.xml.epp.domain_1.UpdateType;
import cz.nic.xml.epp.enumval_1.ExValType;
import cz.nic.xml.epp.fred_1.DomainsByContactT;
import cz.nic.xml.epp.fred_1.DomainsByNssetT;
import cz.nic.xml.epp.fred_1.ExtcommandType;
import ietf.params.xml.ns.epp_1.EppType;
import ietf.params.xml.ns.epp_1.ExtAnyType;
import ietf.params.xml.ns.epp_1.ResponseType;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainStrategy
implements ServerObjectStrategy {
    private static final Log log = LogFactory.getLog(DomainStrategy.class);
    private EppClient client;
    private EppCommandHelper eppCommandHelper;
    private ListResultsHelper listResultsHelper;
    private FredClientDozerMapper mapper = FredClientDozerMapper.getInstance();

    DomainStrategy(Properties properties) {
        this.client = EppClientImpl.getInstance(properties);
        this.eppCommandHelper = new EppCommandHelper();
        this.listResultsHelper = new ListResultsHelper(this.client, this.eppCommandHelper);
    }

    @Override
    public InfoResponse callInfo(InfoRequest infoRequest) throws FredClientException {
        log.debug((Object)("domainInfo called with request(" + infoRequest + ")"));
        DomainInfoRequest domainInfoRequest = (DomainInfoRequest)infoRequest;
        SNameType sNameType = new SNameType();
        sNameType.setName(domainInfoRequest.getDomainName());
        JAXBElement<SNameType> wrapper = new ObjectFactory().createInfo(sNameType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createInfoEppCommand(wrapper, domainInfoRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        JAXBElement wrapperBack = (JAXBElement)responseType.getResData().getAny().get(0);
        InfDataType infDataType = (InfDataType)wrapperBack.getValue();
        DomainInfoResponse result = this.mapper.map(infDataType, DomainInfoResponse.class);
        result.addResponseInfo(responseType);
        if (responseType.getExtension() != null) {
            ExValType exValType = (ExValType)JAXBIntrospector.getValue((Object)responseType.getExtension().getAny().get(0));
            EnumValData enumValData = this.mapper.map(exValType, EnumValData.class);
            result.setEnumval(enumValData);
        }
        return result;
    }

    @Override
    public SendAuthInfoResponse callSendAuthInfo(SendAuthInfoRequest sendAuthInfoRequest) throws FredClientException {
        log.debug((Object)("sendAuthInfo for domain called with request(" + sendAuthInfoRequest + ")"));
        DomainSendAuthInfoRequest request = (DomainSendAuthInfoRequest)sendAuthInfoRequest;
        SendAuthInfoType sendAuthInfoType = new SendAuthInfoType();
        sendAuthInfoType.setName(request.getDomainName());
        JAXBElement<SendAuthInfoType> wrapper = new ObjectFactory().createSendAuthInfo(sendAuthInfoType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createSendAuthInfoEppCommand(wrapper, request.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        DomainSendAuthInfoResponse result = new DomainSendAuthInfoResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public ListResponse callList(ListRequest listRequest) throws FredClientException {
        log.debug((Object)("callList for domain called with request(" + listRequest + ")"));
        ExtcommandType extcommandType = null;
        if (ListType.LIST_ALL.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareListDomainsCommand((DomainsListRequest)listRequest);
        }
        if (ListType.DOMAINS_BY_CONTACTS.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareDomainsByContactCommand((DomainsByContactListRequest)listRequest);
        }
        if (ListType.DOMAINS_BY_KEYSET.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareDomainsByKeysetCommand((DomainsByKeysetListRequest)listRequest);
        }
        if (ListType.DOMAINS_BY_NSSETS.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareDomainsByNssetCommand((DomainsByNssetListRequest)listRequest);
        }
        return this.listResultsHelper.prepareListAndGetResults(extcommandType);
    }

    @Override
    public CheckResponse callCheck(CheckRequest checkRequest) throws FredClientException {
        log.debug((Object)("domainCheck called with request(" + checkRequest + ")"));
        DomainCheckRequest domainCheckRequest = (DomainCheckRequest)checkRequest;
        MNameType mNameType = new MNameType();
        mNameType.getName().addAll(domainCheckRequest.getNames());
        JAXBElement<MNameType> wrapper = new ObjectFactory().createCheck(mNameType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCheckEppCommand(wrapper, domainCheckRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        ChkDataType chkDataType = (ChkDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        DomainCheckResponse result = this.mapper.map(chkDataType, DomainCheckResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public CreateResponse callCreate(CreateRequest createRequest) throws FredClientException {
        log.debug((Object)("domainCreate called with request(" + createRequest + ")"));
        DomainCreateRequest domainCreateRequest = (DomainCreateRequest)createRequest;
        CreateType createType = this.mapper.map(domainCreateRequest, CreateType.class);
        JAXBElement<CreateType> wrapper = new ObjectFactory().createCreate(createType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCreateEppCommand(wrapper, domainCreateRequest.getClientTransactionId());
        if (domainCreateRequest.getEnumValData() != null) {
            ExValType exValType = this.mapper.map(domainCreateRequest.getEnumValData(), ExValType.class);
            JAXBElement<ExValType> enumWrapper = new cz.nic.xml.epp.enumval_1.ObjectFactory().createCreate(exValType);
            ExtAnyType extAnyType = new ExtAnyType();
            extAnyType.getAny().add(enumWrapper);
            ((EppType)requestElement.getValue()).getCommand().setExtension(extAnyType);
        }
        ResponseType responseType = this.client.execute(requestElement);
        CreDataType creDataType = (CreDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        DomainCreateResponse result = this.mapper.map(creDataType, DomainCreateResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public DomainRenewResponse callRenew(DomainRenewRequest renewRequest) throws FredClientException {
        log.debug((Object)("callRenew called with request(" + renewRequest + ")"));
        RenewType renewType = this.mapper.map(renewRequest, RenewType.class);
        JAXBElement<RenewType> wrapper = new ObjectFactory().createRenew(renewType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createRenewEppCommand(wrapper, renewRequest.getClientTransactionId());
        if (renewRequest.getEnumValData() != null) {
            ExValType exValType = this.mapper.map(renewRequest.getEnumValData(), ExValType.class);
            JAXBElement<ExValType> enumWrapper = new cz.nic.xml.epp.enumval_1.ObjectFactory().createRenew(exValType);
            ExtAnyType extAnyType = new ExtAnyType();
            extAnyType.getAny().add(enumWrapper);
            ((EppType)requestElement.getValue()).getCommand().setExtension(extAnyType);
        }
        ResponseType responseType = this.client.execute(requestElement);
        RenDataType renDataType = (RenDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        DomainRenewResponse result = this.mapper.map(renDataType, DomainRenewResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public TransferResponse callTransfer(TransferRequest transferRequest) throws FredClientException {
        log.debug((Object)("callTransfer called with request(" + transferRequest + ")"));
        DomainTransferRequest domainTransferRequest = (DomainTransferRequest)transferRequest;
        TransferType transferType = this.mapper.map(domainTransferRequest, TransferType.class);
        JAXBElement<TransferType> wrapper = new ObjectFactory().createTransfer(transferType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createTransferEppCommand(wrapper, domainTransferRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        DomainTransferResponse result = new DomainTransferResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public DeleteResponse callDelete(DeleteRequest deleteRequest) throws FredClientException {
        log.debug((Object)("callDelete called with request(" + deleteRequest + ")"));
        DomainDeleteRequest domainDeleteRequest = (DomainDeleteRequest)deleteRequest;
        SNameType sNameType = new SNameType();
        sNameType.setName(domainDeleteRequest.getDomainName());
        JAXBElement<SNameType> wrapper = new ObjectFactory().createDelete(sNameType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createDeleteEppCommand(wrapper, domainDeleteRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        DomainDeleteResponse result = new DomainDeleteResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public CreditInfoResponse callCreditInfo(CreditInfoRequest creditInfoRequest) throws FredClientException {
        log.debug((Object)("callCreditInfo called with request(" + creditInfoRequest + ")"));
        throw new UnsupportedOperationException("callCreditInfo operation is not supported for object " + (Object)((Object)creditInfoRequest.getServerObjectType()));
    }

    @Override
    public TestNssetResponse callTestNsset(TestNssetRequest testNssetRequest) throws FredClientException {
        log.debug((Object)("callTestNsset called with request(" + testNssetRequest + ")"));
        throw new UnsupportedOperationException("callTestNsset operation is not supported for object " + (Object)((Object)testNssetRequest.getServerObjectType()));
    }

    @Override
    public PollResponse callPollRequest(PollRequest pollRequest) throws FredClientException {
        log.debug((Object)("callPollRequest called with request(" + pollRequest + ")"));
        throw new UnsupportedOperationException("callPollRequest operation is not supported for object " + (Object)((Object)pollRequest.getServerObjectType()));
    }

    @Override
    public PollAcknowledgementResponse callPollAcknowledgement(PollAcknowledgementRequest pollAcknowledgementRequest) throws FredClientException {
        log.debug((Object)("callPollAcknowledgement called with request(" + pollAcknowledgementRequest + ")"));
        throw new UnsupportedOperationException("callPollAcknowledgement operation is not supported for object " + (Object)((Object)pollAcknowledgementRequest.getServerObjectType()));
    }

    @Override
    public UpdateResponse callUpdate(UpdateRequest updateRequest) throws FredClientException {
        log.debug((Object)("callUpdate called with request(" + updateRequest + ")"));
        DomainUpdateRequest domainUpdateRequest = (DomainUpdateRequest)updateRequest;
        UpdateType updateType = this.mapper.map(domainUpdateRequest, UpdateType.class);
        JAXBElement<UpdateType> wrapper = new ObjectFactory().createUpdate(updateType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createUpdateEppCommand(wrapper, domainUpdateRequest.getClientTransactionId());
        if (domainUpdateRequest.getEnumValUpdateData() != null) {
            ExValType exValType = this.mapper.map(domainUpdateRequest.getEnumValUpdateData(), ExValType.class);
            cz.nic.xml.epp.enumval_1.UpdateType enumUpdate = new cz.nic.xml.epp.enumval_1.UpdateType();
            enumUpdate.setChg(exValType);
            JAXBElement<cz.nic.xml.epp.enumval_1.UpdateType> enumWrapper = new cz.nic.xml.epp.enumval_1.ObjectFactory().createUpdate(enumUpdate);
            ExtAnyType extAnyType = new ExtAnyType();
            extAnyType.getAny().add(enumWrapper);
            ((EppType)requestElement.getValue()).getCommand().setExtension(extAnyType);
        }
        ResponseType responseType = this.client.execute(requestElement);
        DomainUpdateResponse result = new DomainUpdateResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public LoginResponse callLogin(LoginRequest loginRequest) throws FredClientException {
        log.debug((Object)("callLogin called with request(" + loginRequest + ")"));
        throw new UnsupportedOperationException("callLogin operation is not supported for object " + (Object)((Object)loginRequest.getServerObjectType()));
    }

    @Override
    public LogoutResponse callLogout(LogoutRequest logoutRequest) throws FredClientException {
        log.debug((Object)("callLogout called with request(" + logoutRequest + ")"));
        throw new UnsupportedOperationException("callLogin operation is not supported for object " + (Object)((Object)logoutRequest.getServerObjectType()));
    }

    private ExtcommandType prepareDomainsByNssetCommand(DomainsByNssetListRequest domainsByNssetListRequest) {
        log.debug((Object)("listDomainsByNsset called with request(" + domainsByNssetListRequest + ")"));
        DomainsByNssetT domainsByNssetT = new DomainsByNssetT();
        domainsByNssetT.setId(domainsByNssetListRequest.getNssetId());
        return this.eppCommandHelper.createDomainsByNssetExtCommand(domainsByNssetT, domainsByNssetListRequest.getClientTransactionId());
    }

    private ExtcommandType prepareDomainsByKeysetCommand(DomainsByKeysetListRequest domainsByKeysetListRequest) {
        log.debug((Object)("listDomainsByKeyset called with request(" + domainsByKeysetListRequest + ")"));
        DomainsByNssetT domainsByKeyset = new DomainsByNssetT();
        domainsByKeyset.setId(domainsByKeysetListRequest.getKeysetId());
        return this.eppCommandHelper.createDomainsByKeysetExtCommand(domainsByKeyset, domainsByKeysetListRequest.getClientTransactionId());
    }

    private ExtcommandType prepareDomainsByContactCommand(DomainsByContactListRequest domainsByContactListRequest) {
        log.debug((Object)("listDomainsByContact called with request(" + domainsByContactListRequest + ")"));
        DomainsByContactT domainsByContactT = new DomainsByContactT();
        domainsByContactT.setId(domainsByContactListRequest.getContactId());
        return this.eppCommandHelper.createDomainsByContactExtCommand(domainsByContactT, domainsByContactListRequest.getClientTransactionId());
    }

    private ExtcommandType prepareListDomainsCommand(DomainsListRequest domainsListRequest) {
        log.debug((Object)("listAllDomains called with request(" + domainsListRequest + ")"));
        return this.eppCommandHelper.createListDomainsExtCommand(domainsListRequest.getClientTransactionId());
    }
}

