/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient;

import java.util.ArrayList;
import java.util.List;

public enum SuccessfulResponse {
    RESPONSE_1000(1000, "Command completed successfully"),
    RESPONSE_1001(1001, "Command completed successfully; action pending"),
    RESPONSE_1300(1300, "Command completed successfully; no messages"),
    RESPONSE_1301(1301, "Command completed successfully; ack to dequeue"),
    RESPONSE_1500(1500, "Command completed successfully; ending session");

    private int code;
    private String message;

    private SuccessfulResponse(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static List<Integer> getAllSuccessfulCodes() {
        ArrayList<Integer> successfulCodes = new ArrayList<Integer>();
        for (SuccessfulResponse successfulResponse : SuccessfulResponse.values()) {
            successfulCodes.add(successfulResponse.getCode());
        }
        return successfulCodes;
    }

    public static SuccessfulResponse fromValue(int code) {
        for (SuccessfulResponse value : SuccessfulResponse.values()) {
            if (value.getCode() != code) continue;
            return value;
        }
        throw new IllegalArgumentException(String.valueOf(code));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(SuccessfulResponse.class.getSimpleName());
        sb.append("{code=").append(this.code);
        sb.append(", message='").append(this.message).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

