/*
 * Decompiled with CFR 0.152.
 */
package cz.active24.client.fred.eppclient.objectstrategy;

import cz.active24.client.fred.data.check.CheckRequest;
import cz.active24.client.fred.data.check.CheckResponse;
import cz.active24.client.fred.data.check.nsset.NssetCheckRequest;
import cz.active24.client.fred.data.check.nsset.NssetCheckResponse;
import cz.active24.client.fred.data.create.CreateRequest;
import cz.active24.client.fred.data.create.CreateResponse;
import cz.active24.client.fred.data.create.nsset.NssetCreateRequest;
import cz.active24.client.fred.data.create.nsset.NssetCreateResponse;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoRequest;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoResponse;
import cz.active24.client.fred.data.delete.DeleteRequest;
import cz.active24.client.fred.data.delete.DeleteResponse;
import cz.active24.client.fred.data.delete.nsset.NssetDeleteRequest;
import cz.active24.client.fred.data.delete.nsset.NssetDeleteResponse;
import cz.active24.client.fred.data.info.InfoRequest;
import cz.active24.client.fred.data.info.InfoResponse;
import cz.active24.client.fred.data.info.nsset.NssetInfoRequest;
import cz.active24.client.fred.data.info.nsset.NssetInfoResponse;
import cz.active24.client.fred.data.list.ListRequest;
import cz.active24.client.fred.data.list.ListResponse;
import cz.active24.client.fred.data.list.ListResultsHelper;
import cz.active24.client.fred.data.list.ListType;
import cz.active24.client.fred.data.list.nsset.NssetsByContactListRequest;
import cz.active24.client.fred.data.list.nsset.NssetsByNsListRequest;
import cz.active24.client.fred.data.list.nsset.NssetsListRequest;
import cz.active24.client.fred.data.login.other.LoginRequest;
import cz.active24.client.fred.data.login.other.LoginResponse;
import cz.active24.client.fred.data.logout.other.LogoutRequest;
import cz.active24.client.fred.data.logout.other.LogoutResponse;
import cz.active24.client.fred.data.poll.PollAcknowledgementRequest;
import cz.active24.client.fred.data.poll.PollAcknowledgementResponse;
import cz.active24.client.fred.data.poll.PollRequest;
import cz.active24.client.fred.data.poll.PollResponse;
import cz.active24.client.fred.data.renew.domain.DomainRenewRequest;
import cz.active24.client.fred.data.renew.domain.DomainRenewResponse;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.SendAuthInfoResponse;
import cz.active24.client.fred.data.sendauthinfo.nsset.NssetSendAuthInfoRequest;
import cz.active24.client.fred.data.sendauthinfo.nsset.NssetSendAuthInfoResponse;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetRequest;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetResponse;
import cz.active24.client.fred.data.transfer.TransferRequest;
import cz.active24.client.fred.data.transfer.TransferResponse;
import cz.active24.client.fred.data.transfer.nsset.NssetTransferRequest;
import cz.active24.client.fred.data.transfer.nsset.NssetTransferResponse;
import cz.active24.client.fred.data.update.UpdateRequest;
import cz.active24.client.fred.data.update.UpdateResponse;
import cz.active24.client.fred.data.update.nsset.NssetUpdateRequest;
import cz.active24.client.fred.data.update.nsset.NssetUpdateResponse;
import cz.active24.client.fred.eppclient.EppClientImpl;
import cz.active24.client.fred.eppclient.EppCommandHelper;
import cz.active24.client.fred.eppclient.objectstrategy.ServerObjectStrategy;
import cz.active24.client.fred.exception.FredClientException;
import cz.active24.client.fred.mapper.FredClientDozerMapper;
import cz.nic.xml.epp.fred_1.ExtcommandType;
import cz.nic.xml.epp.fred_1.NssetsByContactT;
import cz.nic.xml.epp.fred_1.NssetsByNsT;
import cz.nic.xml.epp.nsset_1.ChkDataType;
import cz.nic.xml.epp.nsset_1.CrType;
import cz.nic.xml.epp.nsset_1.CreDataType;
import cz.nic.xml.epp.nsset_1.InfDataType;
import cz.nic.xml.epp.nsset_1.MNameType;
import cz.nic.xml.epp.nsset_1.ObjectFactory;
import cz.nic.xml.epp.nsset_1.SIDType;
import cz.nic.xml.epp.nsset_1.SendAuthInfoType;
import cz.nic.xml.epp.nsset_1.TestType;
import cz.nic.xml.epp.nsset_1.TransferType;
import cz.nic.xml.epp.nsset_1.UpdateType;
import ietf.params.xml.ns.epp_1.EppType;
import ietf.params.xml.ns.epp_1.ResponseType;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NssetStrategy
implements ServerObjectStrategy {
    private static final Log log = LogFactory.getLog(NssetStrategy.class);
    private EppClientImpl client;
    private EppCommandHelper eppCommandHelper;
    private FredClientDozerMapper mapper = FredClientDozerMapper.getInstance();
    private ListResultsHelper listResultsHelper;

    NssetStrategy(Properties properties) {
        this.client = EppClientImpl.getInstance(properties);
        this.eppCommandHelper = new EppCommandHelper();
        this.listResultsHelper = new ListResultsHelper(this.client, this.eppCommandHelper);
    }

    @Override
    public InfoResponse callInfo(InfoRequest infoRequest) throws FredClientException {
        log.debug((Object)("nssetInfo called with request(" + infoRequest + ")"));
        NssetInfoRequest nssetInfoRequest = (NssetInfoRequest)infoRequest;
        SIDType sidType = new SIDType();
        sidType.setId(nssetInfoRequest.getId());
        JAXBElement<SIDType> wrapper = new ObjectFactory().createInfo(sidType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createInfoEppCommand(wrapper, nssetInfoRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        InfDataType infDataType = (InfDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        NssetInfoResponse result = this.mapper.map(infDataType, NssetInfoResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public SendAuthInfoResponse callSendAuthInfo(SendAuthInfoRequest sendAuthInfoRequest) throws FredClientException {
        log.debug((Object)("sendAuthInfo for nsset called with request(" + sendAuthInfoRequest + ")"));
        NssetSendAuthInfoRequest request = (NssetSendAuthInfoRequest)sendAuthInfoRequest;
        SendAuthInfoType sendAuthInfoType = new SendAuthInfoType();
        sendAuthInfoType.setId(request.getNssetId());
        JAXBElement<SendAuthInfoType> wrapper = new ObjectFactory().createSendAuthInfo(sendAuthInfoType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createSendAuthInfoEppCommand(wrapper, request.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        NssetSendAuthInfoResponse result = new NssetSendAuthInfoResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public ListResponse callList(ListRequest listRequest) throws FredClientException {
        log.debug((Object)("callList for nsset called with request(" + listRequest + ")"));
        ExtcommandType extcommandType = null;
        if (ListType.LIST_ALL.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareListNssetsCommand((NssetsListRequest)listRequest);
        }
        if (ListType.NSSETS_BY_CONTACT.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareNssetsByContactCommand((NssetsByContactListRequest)listRequest);
        }
        if (ListType.NSSETS_BY_NS.equals((Object)listRequest.getListType())) {
            extcommandType = this.prepareNssetsByNsCommand((NssetsByNsListRequest)listRequest);
        }
        return this.listResultsHelper.prepareListAndGetResults(extcommandType);
    }

    @Override
    public CheckResponse callCheck(CheckRequest checkRequest) throws FredClientException {
        log.debug((Object)("nssetCheck called with request(" + checkRequest + ")"));
        NssetCheckRequest nssetCheckRequest = (NssetCheckRequest)checkRequest;
        MNameType mNameType = new MNameType();
        mNameType.getId().addAll(nssetCheckRequest.getNssetIds());
        JAXBElement<MNameType> wrapper = new ObjectFactory().createCheck(mNameType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCheckEppCommand(wrapper, nssetCheckRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        ChkDataType chkDataType = (ChkDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        NssetCheckResponse result = this.mapper.map(chkDataType, NssetCheckResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public CreateResponse callCreate(CreateRequest createRequest) throws FredClientException {
        log.debug((Object)("nssetCreate called with request(" + createRequest + ")"));
        NssetCreateRequest nssetCreateRequest = (NssetCreateRequest)createRequest;
        CrType crType = this.mapper.map(nssetCreateRequest, CrType.class);
        JAXBElement<CrType> wrapper = new ObjectFactory().createCreate(crType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createCreateEppCommand(wrapper, nssetCreateRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        CreDataType creDataType = (CreDataType)JAXBIntrospector.getValue((Object)responseType.getResData().getAny().get(0));
        NssetCreateResponse result = this.mapper.map(creDataType, NssetCreateResponse.class);
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public DomainRenewResponse callRenew(DomainRenewRequest renewRequest) throws FredClientException {
        log.debug((Object)("callRenew called with request(" + renewRequest + ")"));
        throw new UnsupportedOperationException("callRenew operation is not supported for object " + (Object)((Object)renewRequest.getServerObjectType()));
    }

    @Override
    public TransferResponse callTransfer(TransferRequest transferRequest) throws FredClientException {
        log.debug((Object)("callTransfer called with request(" + transferRequest + ")"));
        NssetTransferRequest nssetTransferRequest = (NssetTransferRequest)transferRequest;
        TransferType transferType = this.mapper.map(nssetTransferRequest, TransferType.class);
        JAXBElement<TransferType> wrapper = new ObjectFactory().createTransfer(transferType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createTransferEppCommand(wrapper, nssetTransferRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        NssetTransferResponse result = new NssetTransferResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public DeleteResponse callDelete(DeleteRequest deleteRequest) throws FredClientException {
        log.debug((Object)("callDelete called with request(" + deleteRequest + ")"));
        NssetDeleteRequest nssetDeleteRequest = (NssetDeleteRequest)deleteRequest;
        SIDType sidType = new SIDType();
        sidType.setId(nssetDeleteRequest.getNssetId());
        JAXBElement<SIDType> wrapper = new ObjectFactory().createDelete(sidType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createDeleteEppCommand(wrapper, nssetDeleteRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        NssetDeleteResponse result = new NssetDeleteResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public CreditInfoResponse callCreditInfo(CreditInfoRequest creditInfoRequest) throws FredClientException {
        log.debug((Object)("callCreditInfo called with request(" + creditInfoRequest + ")"));
        throw new UnsupportedOperationException("callCreditInfo operation is not supported for object " + (Object)((Object)creditInfoRequest.getServerObjectType()));
    }

    @Override
    public TestNssetResponse callTestNsset(TestNssetRequest testNssetRequest) throws FredClientException {
        log.debug((Object)("callTestNsset called with request(" + testNssetRequest + ")"));
        TestType testType = this.mapper.map(testNssetRequest, TestType.class);
        JAXBElement<TestType> wrapper = new ObjectFactory().createTest(testType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createTestNssetEppCommand(wrapper, testNssetRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        TestNssetResponse result = new TestNssetResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public PollResponse callPollRequest(PollRequest pollRequest) throws FredClientException {
        log.debug((Object)("callPollRequest called with request(" + pollRequest + ")"));
        throw new UnsupportedOperationException("callPollRequest operation is not supported for object " + (Object)((Object)pollRequest.getServerObjectType()));
    }

    @Override
    public PollAcknowledgementResponse callPollAcknowledgement(PollAcknowledgementRequest pollAcknowledgementRequest) throws FredClientException {
        log.debug((Object)("callPollAcknowledgement called with request(" + pollAcknowledgementRequest + ")"));
        throw new UnsupportedOperationException("callPollAcknowledgement operation is not supported for object " + (Object)((Object)pollAcknowledgementRequest.getServerObjectType()));
    }

    @Override
    public UpdateResponse callUpdate(UpdateRequest updateRequest) throws FredClientException {
        log.debug((Object)("callUpdate called with request(" + updateRequest + ")"));
        NssetUpdateRequest nssetUpdateRequest = (NssetUpdateRequest)updateRequest;
        UpdateType updateType = this.mapper.map(nssetUpdateRequest, UpdateType.class);
        JAXBElement<UpdateType> wrapper = new ObjectFactory().createUpdate(updateType);
        JAXBElement<EppType> requestElement = this.eppCommandHelper.createUpdateEppCommand(wrapper, nssetUpdateRequest.getClientTransactionId());
        ResponseType responseType = this.client.execute(requestElement);
        NssetUpdateResponse result = new NssetUpdateResponse();
        result.addResponseInfo(responseType);
        return result;
    }

    @Override
    public LoginResponse callLogin(LoginRequest loginRequest) throws FredClientException {
        log.debug((Object)("callLogin called with request(" + loginRequest + ")"));
        throw new UnsupportedOperationException("callLogin operation is not supported for object " + (Object)((Object)loginRequest.getServerObjectType()));
    }

    @Override
    public LogoutResponse callLogout(LogoutRequest logoutRequest) throws FredClientException {
        log.debug((Object)("callLogout called with request(" + logoutRequest + ")"));
        throw new UnsupportedOperationException("callLogin operation is not supported for object " + (Object)((Object)logoutRequest.getServerObjectType()));
    }

    private ExtcommandType prepareNssetsByNsCommand(NssetsByNsListRequest nssetsByNsListRequest) {
        log.debug((Object)("listNssetsByNs called with request(" + nssetsByNsListRequest + ")"));
        NssetsByNsT nssetsByNsT = new NssetsByNsT();
        nssetsByNsT.setName(nssetsByNsListRequest.getNameserver());
        return this.eppCommandHelper.createNssetsByNsExtCommand(nssetsByNsT, nssetsByNsListRequest.getClientTransactionId());
    }

    private ExtcommandType prepareNssetsByContactCommand(NssetsByContactListRequest nssetsByContactListRequest) {
        log.debug((Object)("listNssetsByContact called with request(" + nssetsByContactListRequest + ")"));
        NssetsByContactT nssetsByContactT = new NssetsByContactT();
        nssetsByContactT.setId(nssetsByContactListRequest.getContactId());
        return this.eppCommandHelper.createNssetsByContactExtCommand(nssetsByContactT, nssetsByContactListRequest.getClientTransactionId());
    }

    private ExtcommandType prepareListNssetsCommand(NssetsListRequest nssetsListRequest) {
        log.debug((Object)("listAllNssets called with request(" + nssetsListRequest + ")"));
        return this.eppCommandHelper.createListNssetsExtCommand(nssetsListRequest.getClientTransactionId());
    }
}

