package cz.active24.client.fred.data.create.nsset;

import cz.active24.client.fred.data.EppRequest;
import cz.active24.client.fred.data.common.nsset.NameserverData;
import cz.active24.client.fred.data.create.CreateRequest;
import cz.active24.client.fred.eppclient.objectstrategy.ServerObjectType;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * A nsset create command is used to register a new nsset.
 *
 * <ul>
 * <li>{@link NssetCreateRequest#id} - the nsset handle</li>
 * <li>{@link NssetCreateRequest#ns} - a nameserver, see {@link NameserverData}</li>
 * <li>{@link NssetCreateRequest#tech} - a handle of a contact that will be assigned as a technical contact</li>
 * <li>{@link NssetCreateRequest#authInfo} - authorization information (transfer password); if omitted, the password will be generated by the server</li>
 * <li>{@link NssetCreateRequest#reportLevel} - the default highest level of technical checks to be performed</li>
 * </ul>
 *
 * @see <a href="https://fred.nic.cz/documentation/html/EPPReference/CommandStructure/Create/CreateNsset.html">FRED documentation</a>
 */
public class NssetCreateRequest extends EppRequest implements Serializable, CreateRequest {

    private String id;

    private List<NameserverData> ns;

    private List<String> tech;

    private String authInfo;

    private Short reportLevel;

    public NssetCreateRequest(String nssetId, List<NameserverData> nameservers, List<String> technicalContacts) {
        setServerObjectType(ServerObjectType.NSSET);

        this.setId(nssetId);
        this.setNs(nameservers);
        this.setTech(technicalContacts == null ? new ArrayList<String>() : technicalContacts);
    }

    public String getId() {
        return id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public List<NameserverData> getNs() {
        return ns;
    }

    protected void setNs(List<NameserverData> ns) {
        this.ns = ns;
    }

    public List<String> getTech() {
        return tech;
    }

    protected void setTech(List<String> tech) {
        this.tech = tech;
    }

    public String getAuthInfo() {
        return authInfo;
    }

    public void setAuthInfo(String authInfo) {
        this.authInfo = authInfo;
    }

    public Short getReportLevel() {
        return reportLevel;
    }

    public void setReportLevel(Short reportLevel) {
        this.reportLevel = reportLevel;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("NssetCreateRequest{");
        sb.append("id='").append(id).append('\'');
        sb.append(", ns=").append(ns);
        sb.append(", tech=").append(tech);
        sb.append(", authInfo='").append(authInfo).append('\'');
        sb.append(", reportLevel=").append(reportLevel);
        sb.append('}');
        return sb.toString();
    }
}
