package cz.active24.client.fred.data.create.nsset;

import cz.active24.client.fred.data.EppRequest;
import cz.active24.client.fred.data.common.nsset.NameserverData;
import cz.active24.client.fred.data.create.CreateRequest;
import cz.active24.client.fred.eppclient.objectstrategy.ServerObjectType;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * A nsset create command is used to register a new nsset.
 *
 * <ul>
 * <li>{@link NssetCreateRequest#nssetId} - the nsset handle</li>
 * <li>{@link NssetCreateRequest#nameservers} - a nameserver, see {@link NameserverData}</li>
 * <li>{@link NssetCreateRequest#technicalContacts} - a handle of a contact that will be assigned as a technical contact</li>
 * <li>{@link NssetCreateRequest#authInfo} - authorization information (transfer password); if omitted, the password will be generated by the server; deprecated, ignored since 2.48</li>
 * <li>{@link NssetCreateRequest#reportLevel} - the default highest level of technical checks to be performed</li>
 * </ul>
 *
 * @see <a href="https://fred.nic.cz/documentation/html/EPPReference/CommandStructure/Create/CreateNsset.html">FRED documentation</a>
 */
public class NssetCreateRequest extends EppRequest implements Serializable, CreateRequest {

    private String nssetId;

    private List<NameserverData> nameservers;

    private List<String> technicalContacts;

    @Deprecated
    private String authInfo;

    private Short reportLevel;

    public NssetCreateRequest(String nssetId, List<NameserverData> nameservers, List<String> technicalContacts) {
        setServerObjectType(ServerObjectType.NSSET);

        this.setNssetId(nssetId);
        this.setNameservers(nameservers);
        this.setTechnicalContacts(technicalContacts == null ? new ArrayList<String>() : technicalContacts);
    }

    public String getNssetId() {
        return nssetId;
    }

    protected void setNssetId(String nssetId) {
        this.nssetId = nssetId;
    }

    public List<NameserverData> getNameservers() {
        return nameservers;
    }

    protected void setNameservers(List<NameserverData> nameservers) {
        this.nameservers = nameservers;
    }

    public List<String> getTechnicalContacts() {
        return technicalContacts;
    }

    protected void setTechnicalContacts(List<String> technicalContacts) {
        this.technicalContacts = technicalContacts;
    }

    public String getAuthInfo() {
        return authInfo;
    }

    public void setAuthInfo(String authInfo) {
        this.authInfo = authInfo;
    }

    public Short getReportLevel() {
        return reportLevel;
    }

    public void setReportLevel(Short reportLevel) {
        this.reportLevel = reportLevel;
    }

    @Override
    public String toString() {
        final StringBuffer sb = new StringBuffer("NssetCreateRequest{");
        sb.append("nssetId='").append(nssetId).append('\'');
        sb.append(", nameservers=").append(nameservers);
        sb.append(", technicalContacts=").append(technicalContacts);
        sb.append(", authInfo='").append(authInfo).append('\'');
        sb.append(", reportLevel=").append(reportLevel);
        sb.append('}');
        return sb.toString();
    }
}
