package cz.active24.client.fred.mapper;

import cz.active24.client.fred.data.check.contact.ContactCheckData;
import cz.active24.client.fred.data.check.contact.ContactCheckResponse;
import cz.active24.client.fred.data.check.domain.DomainCheckData;
import cz.active24.client.fred.data.check.domain.DomainCheckResponse;
import cz.active24.client.fred.data.check.keyset.KeysetCheckData;
import cz.active24.client.fred.data.check.keyset.KeysetCheckResponse;
import cz.active24.client.fred.data.check.nsset.NssetCheckData;
import cz.active24.client.fred.data.check.nsset.NssetCheckResponse;
import cz.active24.client.fred.data.common.contact.AddressData;
import cz.active24.client.fred.data.common.contact.IdentType;
import cz.active24.client.fred.data.common.contact.IdentificationData;
import cz.active24.client.fred.data.common.contact.PostalInfoData;
import cz.active24.client.fred.data.common.domain.EnumValData;
import cz.active24.client.fred.data.common.domain.PeriodType;
import cz.active24.client.fred.data.common.domain.PeriodUnit;
import cz.active24.client.fred.data.common.keyset.DnsKeyData;
import cz.active24.client.fred.data.common.nsset.NameserverData;
import cz.active24.client.fred.data.common.other.ZoneCredit;
import cz.active24.client.fred.data.create.contact.ContactCreateRequest;
import cz.active24.client.fred.data.create.contact.ContactCreateResponse;
import cz.active24.client.fred.data.create.domain.DomainCreateRequest;
import cz.active24.client.fred.data.create.domain.DomainCreateResponse;
import cz.active24.client.fred.data.create.keyset.KeysetCreateRequest;
import cz.active24.client.fred.data.create.keyset.KeysetCreateResponse;
import cz.active24.client.fred.data.create.nsset.NssetCreateRequest;
import cz.active24.client.fred.data.create.nsset.NssetCreateResponse;
import cz.active24.client.fred.data.creditinfo.other.CreditInfoResponse;
import cz.active24.client.fred.data.info.contact.ContactInfoResponse;
import cz.active24.client.fred.data.info.domain.DomainInfoResponse;
import cz.active24.client.fred.data.info.keyset.KeysetInfoResponse;
import cz.active24.client.fred.data.info.nsset.NssetInfoResponse;
import cz.active24.client.fred.data.poll.contact.ContactDeletionPollResponse;
import cz.active24.client.fred.data.poll.contact.ContactTransferPollResponse;
import cz.active24.client.fred.data.poll.contact.ContactUpdatePollResponse;
import cz.active24.client.fred.data.poll.domain.DomainExpirationEventType;
import cz.active24.client.fred.data.poll.domain.DomainExpirationPollResponse;
import cz.active24.client.fred.data.poll.domain.DomainTransferPollResponse;
import cz.active24.client.fred.data.poll.domain.DomainUpdatePollResponse;
import cz.active24.client.fred.data.poll.domain.EnumDomainValidationEventType;
import cz.active24.client.fred.data.poll.domain.EnumDomainValidationPollResponse;
import cz.active24.client.fred.data.poll.keyset.KeysetDeletionPollResponse;
import cz.active24.client.fred.data.poll.keyset.KeysetTransferPollResponse;
import cz.active24.client.fred.data.poll.keyset.KeysetUpdatePollResponse;
import cz.active24.client.fred.data.poll.nsset.NssetDeletionPollResponse;
import cz.active24.client.fred.data.poll.nsset.NssetTransferPollResponse;
import cz.active24.client.fred.data.poll.nsset.NssetUpdatePollResponse;
import cz.active24.client.fred.data.poll.nsset.TechnicalCheckResult;
import cz.active24.client.fred.data.poll.nsset.TechnicalCheckResultsPollResponse;
import cz.active24.client.fred.data.poll.other.LowCreditPollResponse;
import cz.active24.client.fred.data.poll.other.RequestUsagePollResponse;
import cz.active24.client.fred.data.renew.domain.DomainRenewRequest;
import cz.active24.client.fred.data.renew.domain.DomainRenewResponse;
import cz.active24.client.fred.data.sendauthinfo.contact.ContactSendAuthInfoResponse;
import cz.active24.client.fred.data.sendauthinfo.domain.DomainSendAuthInfoResponse;
import cz.active24.client.fred.data.sendauthinfo.keyset.KeysetSendAuthInfoResponse;
import cz.active24.client.fred.data.sendauthinfo.nsset.NssetSendAuthInfoResponse;
import cz.active24.client.fred.data.testnsset.nsset.TestNssetRequest;
import cz.active24.client.fred.data.transfer.contact.ContactTransferRequest;
import cz.active24.client.fred.data.transfer.domain.DomainTransferRequest;
import cz.active24.client.fred.data.transfer.keyset.KeysetTransferRequest;
import cz.active24.client.fred.data.transfer.nsset.NssetTransferRequest;
import cz.active24.client.fred.data.update.contact.ContactChangeData;
import cz.active24.client.fred.data.update.contact.ContactUpdateRequest;
import cz.active24.client.fred.data.update.domain.DomainAddData;
import cz.active24.client.fred.data.update.domain.DomainChangeData;
import cz.active24.client.fred.data.update.domain.DomainRemData;
import cz.active24.client.fred.data.update.domain.DomainUpdateRequest;
import cz.active24.client.fred.data.update.keyset.KeysetAddData;
import cz.active24.client.fred.data.update.keyset.KeysetChangeData;
import cz.active24.client.fred.data.update.keyset.KeysetRemData;
import cz.active24.client.fred.data.update.keyset.KeysetUpdateRequest;
import cz.active24.client.fred.data.update.nsset.NssetAddData;
import cz.active24.client.fred.data.update.nsset.NssetChangeData;
import cz.active24.client.fred.data.update.nsset.NssetRemData;
import cz.active24.client.fred.data.update.nsset.NssetUpdateRequest;
import cz.nic.xml.epp.contact_1.AddrReadType;
import cz.nic.xml.epp.contact_1.CheckIDType;
import cz.nic.xml.epp.contact_1.ChgPostalInfoType;
import cz.nic.xml.epp.contact_1.HandleDateT;
import cz.nic.xml.epp.contact_1.IdentT;
import cz.nic.xml.epp.contact_1.IdentTypeT;
import cz.nic.xml.epp.contact_1.IdentUpdT;
import cz.nic.xml.epp.contact_1.IdleDelDataT;
import cz.nic.xml.epp.contact_1.PostalInfoReadType;
import cz.nic.xml.epp.contact_1.PostalInfoType;
import cz.nic.xml.epp.contact_1.SendAuthInfoDataType;
import cz.nic.xml.epp.domain_1.CreateType;
import cz.nic.xml.epp.domain_1.DelDataT;
import cz.nic.xml.epp.domain_1.DnsOutageDataT;
import cz.nic.xml.epp.domain_1.ExpDataT;
import cz.nic.xml.epp.domain_1.ImpendingExpDataT;
import cz.nic.xml.epp.domain_1.InfDataType;
import cz.nic.xml.epp.domain_1.NewData;
import cz.nic.xml.epp.domain_1.OldData;
import cz.nic.xml.epp.domain_1.PUnitType;
import cz.nic.xml.epp.domain_1.RenDataType;
import cz.nic.xml.epp.domain_1.RenewType;
import cz.nic.xml.epp.domain_1.UpdateDataT;
import cz.nic.xml.epp.enumval_1.ExValType;
import cz.nic.xml.epp.enumval_1.ImpendingValExpDataT;
import cz.nic.xml.epp.enumval_1.ValExpDataT;
import cz.nic.xml.epp.extra_addr_1.AddrType;
import cz.nic.xml.epp.fred_1.CreditType;
import cz.nic.xml.epp.fred_1.LowCreditDataT;
import cz.nic.xml.epp.fred_1.RequestFeeInfoDataT;
import cz.nic.xml.epp.fred_1.ResCreditType;
import cz.nic.xml.epp.fredcom_1.MsgType;
import cz.nic.xml.epp.keyset_1.CheckNameType;
import cz.nic.xml.epp.keyset_1.CheckType;
import cz.nic.xml.epp.keyset_1.ChkDataType;
import cz.nic.xml.epp.keyset_1.CreDataType;
import cz.nic.xml.epp.keyset_1.DnskeyT;
import cz.nic.xml.epp.nsset_1.AddType;
import cz.nic.xml.epp.nsset_1.ChgType;
import cz.nic.xml.epp.nsset_1.CrType;
import cz.nic.xml.epp.nsset_1.NsT;
import cz.nic.xml.epp.nsset_1.RemType;
import cz.nic.xml.epp.nsset_1.ResultType;
import cz.nic.xml.epp.nsset_1.TestDataT;
import cz.nic.xml.epp.nsset_1.TestType;
import cz.nic.xml.epp.nsset_1.TransferType;
import cz.nic.xml.epp.nsset_1.UpdateType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import javax.xml.datatype.XMLGregorianCalendar;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2024-05-07T12:14:30+0200",
    comments = "version: 1.5.2.Final, compiler: javac, environment: Java 1.8.0_231 (Oracle Corporation)"
)
public class FredClientMapStructMapperImpl extends FredClientMapStructMapper {

    @Override
    public KeysetCheckData map(CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }

        KeysetCheckData keysetCheckData = new KeysetCheckData();

        keysetCheckData.setId( checkTypeIdValue( checkType ) );
        keysetCheckData.setAvail( checkTypeIdAvail( checkType ) );
        keysetCheckData.setReason( checkTypeReasonValue( checkType ) );

        return keysetCheckData;
    }

    @Override
    public KeysetCheckResponse map(ChkDataType chkDataType) {
        if ( chkDataType == null ) {
            return null;
        }

        KeysetCheckResponse keysetCheckResponse = new KeysetCheckResponse();

        keysetCheckResponse.setCheckData( checkTypeListToKeysetCheckDataList( chkDataType.getCd() ) );

        return keysetCheckResponse;
    }

    @Override
    public RenewType map(DomainRenewRequest renewRequest) {
        if ( renewRequest == null ) {
            return null;
        }

        RenewType renewType = new RenewType();

        renewType.setName( renewRequest.getDomainName() );
        renewType.setCurExpDate( toXmlGregorianCalendar( renewRequest.getCurExpDate() ) );
        renewType.setPeriod( periodTypeToPeriodType( renewRequest.getPeriod() ) );

        return renewType;
    }

    @Override
    public ExValType map(EnumValData enumValData) {
        if ( enumValData == null ) {
            return null;
        }

        ExValType exValType = new ExValType();

        exValType.setValExDate( toXmlGregorianCalendar( enumValData.getValExDate() ) );
        exValType.setPublish( enumValData.getPublish() );

        return exValType;
    }

    @Override
    public DomainInfoResponse map(InfDataType infDataType) {
        if ( infDataType == null ) {
            return null;
        }

        DomainInfoResponse domainInfoResponse = new DomainInfoResponse();

        domainInfoResponse.setStatus( toDomainStatusValueType( infDataType.getStatus() ) );
        domainInfoResponse.setName( infDataType.getName() );
        domainInfoResponse.setRoid( infDataType.getRoid() );
        domainInfoResponse.setRegistrant( infDataType.getRegistrant() );
        List<String> list1 = infDataType.getAdmin();
        if ( list1 != null ) {
            domainInfoResponse.setAdmin( new ArrayList<String>( list1 ) );
        }
        domainInfoResponse.setNsset( infDataType.getNsset() );
        domainInfoResponse.setKeyset( infDataType.getKeyset() );
        domainInfoResponse.setClID( infDataType.getClID() );
        domainInfoResponse.setCrID( infDataType.getCrID() );
        domainInfoResponse.setCrDate( xmlGregorianCalendarToDate( infDataType.getCrDate() ) );
        domainInfoResponse.setUpID( infDataType.getUpID() );
        domainInfoResponse.setUpDate( xmlGregorianCalendarToDate( infDataType.getUpDate() ) );
        domainInfoResponse.setExDate( xmlGregorianCalendarToDate( infDataType.getExDate() ) );
        domainInfoResponse.setTrDate( xmlGregorianCalendarToDate( infDataType.getTrDate() ) );
        domainInfoResponse.setAuthInfo( infDataType.getAuthInfo() );
        List<String> list2 = infDataType.getTempcontact();
        if ( list2 != null ) {
            domainInfoResponse.setTempcontact( new ArrayList<String>( list2 ) );
        }

        return domainInfoResponse;
    }

    @Override
    public ContactInfoResponse map(cz.nic.xml.epp.contact_1.InfDataType infDataType) {
        if ( infDataType == null ) {
            return null;
        }

        ContactInfoResponse contactInfoResponse = new ContactInfoResponse();

        contactInfoResponse.setStatus( toContactStatusValueType( infDataType.getStatus() ) );
        contactInfoResponse.setDisclose( toDiscloseData( infDataType.getDisclose() ) );
        contactInfoResponse.setId( infDataType.getId() );
        contactInfoResponse.setRoid( infDataType.getRoid() );
        contactInfoResponse.setPostalInfo( postalInfoReadTypeToPostalInfoData( infDataType.getPostalInfo() ) );
        contactInfoResponse.setVoice( infDataType.getVoice() );
        contactInfoResponse.setFax( infDataType.getFax() );
        contactInfoResponse.setEmail( infDataType.getEmail() );
        contactInfoResponse.setClID( infDataType.getClID() );
        contactInfoResponse.setCrID( infDataType.getCrID() );
        contactInfoResponse.setCrDate( xmlGregorianCalendarToDate( infDataType.getCrDate() ) );
        contactInfoResponse.setUpID( infDataType.getUpID() );
        contactInfoResponse.setUpDate( xmlGregorianCalendarToDate( infDataType.getUpDate() ) );
        contactInfoResponse.setTrDate( xmlGregorianCalendarToDate( infDataType.getTrDate() ) );
        contactInfoResponse.setAuthInfo( infDataType.getAuthInfo() );
        contactInfoResponse.setVat( infDataType.getVat() );
        contactInfoResponse.setIdent( identTToIdentificationData( infDataType.getIdent() ) );
        contactInfoResponse.setNotifyEmail( infDataType.getNotifyEmail() );

        return contactInfoResponse;
    }

    @Override
    public KeysetInfoResponse map(cz.nic.xml.epp.keyset_1.InfDataType infDataType) {
        if ( infDataType == null ) {
            return null;
        }

        KeysetInfoResponse keysetInfoResponse = new KeysetInfoResponse();

        keysetInfoResponse.setStatus( toKeysetStatusValueType( infDataType.getStatus() ) );
        keysetInfoResponse.setId( infDataType.getId() );
        keysetInfoResponse.setRoid( infDataType.getRoid() );
        keysetInfoResponse.setClID( infDataType.getClID() );
        keysetInfoResponse.setCrID( infDataType.getCrID() );
        keysetInfoResponse.setCrDate( xmlGregorianCalendarToDate( infDataType.getCrDate() ) );
        keysetInfoResponse.setUpID( infDataType.getUpID() );
        keysetInfoResponse.setUpDate( xmlGregorianCalendarToDate( infDataType.getUpDate() ) );
        keysetInfoResponse.setTrDate( xmlGregorianCalendarToDate( infDataType.getTrDate() ) );
        keysetInfoResponse.setAuthInfo( infDataType.getAuthInfo() );
        keysetInfoResponse.setDnskey( dnskeyTListToDnsKeyDataList( infDataType.getDnskey() ) );
        List<String> list2 = infDataType.getTech();
        if ( list2 != null ) {
            keysetInfoResponse.setTech( new ArrayList<String>( list2 ) );
        }

        return keysetInfoResponse;
    }

    @Override
    public NssetInfoResponse map(cz.nic.xml.epp.nsset_1.InfDataType infDataType) {
        if ( infDataType == null ) {
            return null;
        }

        NssetInfoResponse nssetInfoResponse = new NssetInfoResponse();

        nssetInfoResponse.setStatus( toNssetStatusValueType( infDataType.getStatus() ) );
        nssetInfoResponse.setReportLevel( infDataType.getReportlevel() );
        nssetInfoResponse.setId( infDataType.getId() );
        nssetInfoResponse.setRoid( infDataType.getRoid() );
        nssetInfoResponse.setClID( infDataType.getClID() );
        nssetInfoResponse.setCrID( infDataType.getCrID() );
        nssetInfoResponse.setCrDate( xmlGregorianCalendarToDate( infDataType.getCrDate() ) );
        nssetInfoResponse.setUpID( infDataType.getUpID() );
        nssetInfoResponse.setUpDate( xmlGregorianCalendarToDate( infDataType.getUpDate() ) );
        nssetInfoResponse.setTrDate( xmlGregorianCalendarToDate( infDataType.getTrDate() ) );
        nssetInfoResponse.setAuthInfo( infDataType.getAuthInfo() );
        nssetInfoResponse.setNs( nsTListToNameserverDataList( infDataType.getNs() ) );
        List<String> list2 = infDataType.getTech();
        if ( list2 != null ) {
            nssetInfoResponse.setTech( new ArrayList<String>( list2 ) );
        }

        return nssetInfoResponse;
    }

    @Override
    public ContactCheckResponse map(cz.nic.xml.epp.contact_1.ChkDataType chkDataType) {
        if ( chkDataType == null ) {
            return null;
        }

        ContactCheckResponse contactCheckResponse = new ContactCheckResponse();

        contactCheckResponse.setCheckData( checkTypeListToContactCheckDataList( chkDataType.getCd() ) );

        return contactCheckResponse;
    }

    @Override
    public ContactCheckData map(cz.nic.xml.epp.contact_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }

        ContactCheckData contactCheckData = new ContactCheckData();

        contactCheckData.setId( checkTypeIdValue1( checkType ) );
        contactCheckData.setAvail( checkTypeIdAvail1( checkType ) );
        contactCheckData.setReason( checkTypeReasonValue1( checkType ) );

        return contactCheckData;
    }

    @Override
    public DomainCheckResponse map(cz.nic.xml.epp.domain_1.ChkDataType chkDataType) {
        if ( chkDataType == null ) {
            return null;
        }

        DomainCheckResponse domainCheckResponse = new DomainCheckResponse();

        domainCheckResponse.setCheckData( checkTypeListToDomainCheckDataList( chkDataType.getCd() ) );

        return domainCheckResponse;
    }

    @Override
    public DomainCheckData map(cz.nic.xml.epp.domain_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }

        DomainCheckData domainCheckData = new DomainCheckData();

        domainCheckData.setId( checkTypeNameValue( checkType ) );
        domainCheckData.setAvail( checkTypeNameAvail( checkType ) );
        domainCheckData.setReason( checkTypeReasonValue2( checkType ) );

        return domainCheckData;
    }

    @Override
    public NssetCheckResponse map(cz.nic.xml.epp.nsset_1.ChkDataType chkDataType) {
        if ( chkDataType == null ) {
            return null;
        }

        NssetCheckResponse nssetCheckResponse = new NssetCheckResponse();

        nssetCheckResponse.setCheckData( checkTypeListToNssetCheckDataList( chkDataType.getCd() ) );

        return nssetCheckResponse;
    }

    @Override
    public NssetCheckData map(cz.nic.xml.epp.nsset_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }

        NssetCheckData nssetCheckData = new NssetCheckData();

        nssetCheckData.setId( checkTypeIdValue2( checkType ) );
        nssetCheckData.setAvail( checkTypeIdAvail2( checkType ) );
        nssetCheckData.setReason( checkTypeReasonValue3( checkType ) );

        return nssetCheckData;
    }

    @Override
    public AddrType.Addr mapToExtraAddrType(AddressData addressData) {
        if ( addressData == null ) {
            return null;
        }

        AddrType.Addr addr = new AddrType.Addr();

        addr.setCity( addressData.getCity() );
        addr.setSp( addressData.getSp() );
        addr.setPc( addressData.getPc() );
        addr.setCc( addressData.getCc() );
        if ( addr.getStreet() != null ) {
            List<String> list = addressData.getStreet();
            if ( list != null ) {
                addr.getStreet().addAll( list );
            }
        }

        return addr;
    }

    @Override
    public cz.nic.xml.epp.contact_1.AddrType map(AddressData addressData) {
        if ( addressData == null ) {
            return null;
        }

        cz.nic.xml.epp.contact_1.AddrType addrType = new cz.nic.xml.epp.contact_1.AddrType();

        addrType.setCity( addressData.getCity() );
        addrType.setSp( addressData.getSp() );
        addrType.setPc( addressData.getPc() );
        addrType.setCc( addressData.getCc() );
        if ( addrType.getStreet() != null ) {
            List<String> list = addressData.getStreet();
            if ( list != null ) {
                addrType.getStreet().addAll( list );
            }
        }

        return addrType;
    }

    @Override
    public AddrType.Addr mapAddressExtension(AddressData addressData) {
        if ( addressData == null ) {
            return null;
        }

        AddrType.Addr addr = new AddrType.Addr();

        addr.setCity( addressData.getCity() );
        addr.setSp( addressData.getSp() );
        addr.setPc( addressData.getPc() );
        addr.setCc( addressData.getCc() );
        if ( addr.getStreet() != null ) {
            List<String> list = addressData.getStreet();
            if ( list != null ) {
                addr.getStreet().addAll( list );
            }
        }

        return addr;
    }

    @Override
    public CrType map(NssetCreateRequest nssetCreateRequest) {
        if ( nssetCreateRequest == null ) {
            return null;
        }

        CrType crType = new CrType();

        crType.setReportlevel( nssetCreateRequest.getReportLevel() );
        crType.setId( nssetCreateRequest.getNssetId() );
        if ( crType.getNs() != null ) {
            List<NsT> list = nameserverDataListToNsTList( nssetCreateRequest.getNameservers() );
            if ( list != null ) {
                crType.getNs().addAll( list );
            }
        }
        if ( crType.getTech() != null ) {
            List<String> list1 = nssetCreateRequest.getTechnicalContacts();
            if ( list1 != null ) {
                crType.getTech().addAll( list1 );
            }
        }

        return crType;
    }

    @Override
    public NsT map(NameserverData nameserverData) {
        if ( nameserverData == null ) {
            return null;
        }

        NsT nsT = new NsT();

        nsT.setName( nameserverData.getName() );
        if ( nsT.getAddr() != null ) {
            List<String> list = nameserverData.getAddr();
            if ( list != null ) {
                nsT.getAddr().addAll( list );
            }
        }

        return nsT;
    }

    @Override
    public cz.nic.xml.epp.keyset_1.CrType map(KeysetCreateRequest keysetCreateRequest) {
        if ( keysetCreateRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.keyset_1.CrType crType = new cz.nic.xml.epp.keyset_1.CrType();

        crType.setId( keysetCreateRequest.getKeysetId() );
        if ( crType.getDnskey() != null ) {
            List<DnskeyT> list = dnsKeyDataListToDnskeyTList( keysetCreateRequest.getDnskey() );
            if ( list != null ) {
                crType.getDnskey().addAll( list );
            }
        }
        if ( crType.getTech() != null ) {
            List<String> list1 = keysetCreateRequest.getTech();
            if ( list1 != null ) {
                crType.getTech().addAll( list1 );
            }
        }

        return crType;
    }

    @Override
    public CreateType map(DomainCreateRequest domainCreateRequest) {
        if ( domainCreateRequest == null ) {
            return null;
        }

        CreateType createType = new CreateType();

        createType.setName( domainCreateRequest.getDomainName() );
        createType.setPeriod( periodTypeToPeriodType( domainCreateRequest.getPeriod() ) );
        createType.setNsset( domainCreateRequest.getNsset() );
        createType.setKeyset( domainCreateRequest.getKeyset() );
        createType.setRegistrant( domainCreateRequest.getRegistrant() );
        if ( createType.getAdmin() != null ) {
            List<String> list = domainCreateRequest.getAdmin();
            if ( list != null ) {
                createType.getAdmin().addAll( list );
            }
        }

        return createType;
    }

    @Override
    public cz.nic.xml.epp.contact_1.CreateType map(ContactCreateRequest contactCreateRequest) {
        if ( contactCreateRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.contact_1.CreateType createType = new cz.nic.xml.epp.contact_1.CreateType();

        createType.setDisclose( toDiscloseType( contactCreateRequest.getDisclose() ) );
        createType.setId( contactCreateRequest.getContactId() );
        createType.setPostalInfo( postalInfoDataToPostalInfoType( contactCreateRequest.getPostalInfoData() ) );
        createType.setVoice( contactCreateRequest.getVoice() );
        createType.setFax( contactCreateRequest.getFax() );
        createType.setEmail( contactCreateRequest.getEmail() );
        createType.setVat( contactCreateRequest.getVat() );
        createType.setIdent( identificationDataToIdentT( contactCreateRequest.getIdent() ) );
        createType.setNotifyEmail( contactCreateRequest.getNotifyEmail() );

        return createType;
    }

    @Override
    public TransferType map(NssetTransferRequest nssetTransferRequest) {
        if ( nssetTransferRequest == null ) {
            return null;
        }

        TransferType transferType = new TransferType();

        transferType.setId( nssetTransferRequest.getNssetId() );
        transferType.setAuthInfo( nssetTransferRequest.getAuthInfo() );

        return transferType;
    }

    @Override
    public cz.nic.xml.epp.keyset_1.TransferType map(KeysetTransferRequest keysetTransferRequest) {
        if ( keysetTransferRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.keyset_1.TransferType transferType = new cz.nic.xml.epp.keyset_1.TransferType();

        transferType.setId( keysetTransferRequest.getKeysetId() );
        transferType.setAuthInfo( keysetTransferRequest.getAuthInfo() );

        return transferType;
    }

    @Override
    public cz.nic.xml.epp.domain_1.TransferType map(DomainTransferRequest domainTransferRequest) {
        if ( domainTransferRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.domain_1.TransferType transferType = new cz.nic.xml.epp.domain_1.TransferType();

        transferType.setName( domainTransferRequest.getDomainName() );
        transferType.setAuthInfo( domainTransferRequest.getAuthInfo() );

        return transferType;
    }

    @Override
    public cz.nic.xml.epp.contact_1.TransferType map(ContactTransferRequest contactTransferRequest) {
        if ( contactTransferRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.contact_1.TransferType transferType = new cz.nic.xml.epp.contact_1.TransferType();

        transferType.setId( contactTransferRequest.getContactId() );
        transferType.setAuthInfo( contactTransferRequest.getAuthInfo() );

        return transferType;
    }

    @Override
    public TestType map(TestNssetRequest testNssetRequest) {
        if ( testNssetRequest == null ) {
            return null;
        }

        TestType testType = new TestType();

        testType.setId( testNssetRequest.getNssetId() );
        testType.setLevel( testNssetRequest.getLevel() );
        if ( testType.getName() != null ) {
            List<String> list = testNssetRequest.getName();
            if ( list != null ) {
                testType.getName().addAll( list );
            }
        }

        return testType;
    }

    @Override
    public LowCreditPollResponse map(LowCreditDataT lowCreditDataT) {
        if ( lowCreditDataT == null ) {
            return null;
        }

        LowCreditPollResponse lowCreditPollResponse = new LowCreditPollResponse();

        lowCreditPollResponse.setZone( lowCreditDataT.getZone() );
        lowCreditPollResponse.setLimit( creditTypeToZoneCredit( lowCreditDataT.getLimit() ) );
        lowCreditPollResponse.setCredit( creditTypeToZoneCredit( lowCreditDataT.getCredit() ) );

        return lowCreditPollResponse;
    }

    @Override
    public ContactTransferPollResponse map(HandleDateT handleDateT) {
        if ( handleDateT == null ) {
            return null;
        }

        ContactTransferPollResponse contactTransferPollResponse = new ContactTransferPollResponse();

        contactTransferPollResponse.setId( handleDateT.getId() );
        contactTransferPollResponse.setTrDate( xmlGregorianCalendarToDate( handleDateT.getTrDate() ) );
        contactTransferPollResponse.setClID( handleDateT.getClID() );

        return contactTransferPollResponse;
    }

    @Override
    public DomainTransferPollResponse map(cz.nic.xml.epp.domain_1.HandleDateT handleDateT) {
        if ( handleDateT == null ) {
            return null;
        }

        DomainTransferPollResponse domainTransferPollResponse = new DomainTransferPollResponse();

        domainTransferPollResponse.setName( handleDateT.getName() );
        domainTransferPollResponse.setTrDate( xmlGregorianCalendarToDate( handleDateT.getTrDate() ) );
        domainTransferPollResponse.setClID( handleDateT.getClID() );

        return domainTransferPollResponse;
    }

    @Override
    public NssetTransferPollResponse map(cz.nic.xml.epp.nsset_1.HandleDateT handleDateT) {
        if ( handleDateT == null ) {
            return null;
        }

        NssetTransferPollResponse nssetTransferPollResponse = new NssetTransferPollResponse();

        nssetTransferPollResponse.setId( handleDateT.getId() );
        nssetTransferPollResponse.setTrDate( xmlGregorianCalendarToDate( handleDateT.getTrDate() ) );
        nssetTransferPollResponse.setClID( handleDateT.getClID() );

        return nssetTransferPollResponse;
    }

    @Override
    public KeysetTransferPollResponse map(cz.nic.xml.epp.keyset_1.HandleDateT handleDateT) {
        if ( handleDateT == null ) {
            return null;
        }

        KeysetTransferPollResponse keysetTransferPollResponse = new KeysetTransferPollResponse();

        keysetTransferPollResponse.setId( handleDateT.getId() );
        keysetTransferPollResponse.setTrDate( xmlGregorianCalendarToDate( handleDateT.getTrDate() ) );
        keysetTransferPollResponse.setClID( handleDateT.getClID() );

        return keysetTransferPollResponse;
    }

    @Override
    public RequestUsagePollResponse map(RequestFeeInfoDataT requestFeeInfoDataT) {
        if ( requestFeeInfoDataT == null ) {
            return null;
        }

        RequestUsagePollResponse requestUsagePollResponse = new RequestUsagePollResponse();

        requestUsagePollResponse.setPeriodFrom( xmlGregorianCalendarToDate( requestFeeInfoDataT.getPeriodFrom() ) );
        requestUsagePollResponse.setPeriodTo( xmlGregorianCalendarToDate( requestFeeInfoDataT.getPeriodTo() ) );
        if ( requestFeeInfoDataT.getTotalFreeCount() != null ) {
            requestUsagePollResponse.setTotalFreeCount( requestFeeInfoDataT.getTotalFreeCount().intValue() );
        }
        if ( requestFeeInfoDataT.getUsedCount() != null ) {
            requestUsagePollResponse.setUsedCount( requestFeeInfoDataT.getUsedCount().intValue() );
        }
        requestUsagePollResponse.setPrice( requestFeeInfoDataT.getPrice() );

        return requestUsagePollResponse;
    }

    @Override
    public DomainUpdatePollResponse map(UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }

        DomainUpdatePollResponse domainUpdatePollResponse = new DomainUpdatePollResponse();

        domainUpdatePollResponse.setOldData( map( updateDataTOldDataInfData( updateDataT ) ) );
        domainUpdatePollResponse.setNewData( map( updateDataTNewDataInfData( updateDataT ) ) );
        domainUpdatePollResponse.setOpTRID( updateDataT.getOpTRID() );

        return domainUpdatePollResponse;
    }

    @Override
    public ContactUpdatePollResponse map(cz.nic.xml.epp.contact_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }

        ContactUpdatePollResponse contactUpdatePollResponse = new ContactUpdatePollResponse();

        contactUpdatePollResponse.setOldData( map( updateDataTOldDataInfData1( updateDataT ) ) );
        contactUpdatePollResponse.setNewData( map( updateDataTNewDataInfData1( updateDataT ) ) );
        contactUpdatePollResponse.setOpTRID( updateDataT.getOpTRID() );

        return contactUpdatePollResponse;
    }

    @Override
    public NssetUpdatePollResponse map(cz.nic.xml.epp.nsset_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }

        NssetUpdatePollResponse nssetUpdatePollResponse = new NssetUpdatePollResponse();

        nssetUpdatePollResponse.setOldData( map( updateDataTOldDataInfData2( updateDataT ) ) );
        nssetUpdatePollResponse.setNewData( map( updateDataTNewDataInfData2( updateDataT ) ) );
        nssetUpdatePollResponse.setOpTRID( updateDataT.getOpTRID() );

        return nssetUpdatePollResponse;
    }

    @Override
    public KeysetUpdatePollResponse map(cz.nic.xml.epp.keyset_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }

        KeysetUpdatePollResponse keysetUpdatePollResponse = new KeysetUpdatePollResponse();

        keysetUpdatePollResponse.setOldData( map( updateDataTOldDataInfData3( updateDataT ) ) );
        keysetUpdatePollResponse.setNewData( map( updateDataTNewDataInfData3( updateDataT ) ) );
        keysetUpdatePollResponse.setOpTRID( updateDataT.getOpTRID() );

        return keysetUpdatePollResponse;
    }

    @Override
    public ContactDeletionPollResponse map(IdleDelDataT idleDelDataT) {
        if ( idleDelDataT == null ) {
            return null;
        }

        ContactDeletionPollResponse contactDeletionPollResponse = new ContactDeletionPollResponse();

        contactDeletionPollResponse.setId( idleDelDataT.getId() );

        return contactDeletionPollResponse;
    }

    @Override
    public KeysetDeletionPollResponse map(cz.nic.xml.epp.keyset_1.IdleDelDataT idleDelDataT) {
        if ( idleDelDataT == null ) {
            return null;
        }

        KeysetDeletionPollResponse keysetDeletionPollResponse = new KeysetDeletionPollResponse();

        keysetDeletionPollResponse.setId( idleDelDataT.getId() );

        return keysetDeletionPollResponse;
    }

    @Override
    public NssetDeletionPollResponse map(cz.nic.xml.epp.nsset_1.IdleDelDataT idleDelDataT) {
        if ( idleDelDataT == null ) {
            return null;
        }

        NssetDeletionPollResponse nssetDeletionPollResponse = new NssetDeletionPollResponse();

        nssetDeletionPollResponse.setId( idleDelDataT.getId() );

        return nssetDeletionPollResponse;
    }

    @Override
    public TechnicalCheckResultsPollResponse map(TestDataT testDataT) {
        if ( testDataT == null ) {
            return null;
        }

        TechnicalCheckResultsPollResponse technicalCheckResultsPollResponse = new TechnicalCheckResultsPollResponse();

        technicalCheckResultsPollResponse.setTestResult( resultTypeListToTechnicalCheckResultList( testDataT.getResult() ) );
        technicalCheckResultsPollResponse.setId( testDataT.getId() );
        technicalCheckResultsPollResponse.setCltestid( testDataT.getCltestid() );
        List<String> list1 = testDataT.getName();
        if ( list1 != null ) {
            technicalCheckResultsPollResponse.setName( new ArrayList<String>( list1 ) );
        }

        return technicalCheckResultsPollResponse;
    }

    @Override
    public UpdateType map(NssetUpdateRequest nssetUpdateRequest) {
        if ( nssetUpdateRequest == null ) {
            return null;
        }

        UpdateType updateType = new UpdateType();

        updateType.setId( nssetUpdateRequest.getNssetId() );
        updateType.setAdd( nssetAddDataToAddType( nssetUpdateRequest.getAdd() ) );
        updateType.setRem( nssetRemDataToRemType( nssetUpdateRequest.getRem() ) );
        updateType.setChg( nssetChangeDataToChgType( nssetUpdateRequest.getChg() ) );

        return updateType;
    }

    @Override
    public cz.nic.xml.epp.domain_1.UpdateType map(DomainUpdateRequest domainUpdateRequest) {
        if ( domainUpdateRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.domain_1.UpdateType updateType = new cz.nic.xml.epp.domain_1.UpdateType();

        updateType.setName( domainUpdateRequest.getDomainName() );
        updateType.setAdd( domainAddDataToAddType( domainUpdateRequest.getAdd() ) );
        updateType.setRem( domainRemDataToRemType( domainUpdateRequest.getRem() ) );
        updateType.setChg( domainChangeDataToChgType( domainUpdateRequest.getChg() ) );

        return updateType;
    }

    @Override
    public cz.nic.xml.epp.keyset_1.UpdateType map(KeysetUpdateRequest keysetUpdateRequest) {
        if ( keysetUpdateRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.keyset_1.UpdateType updateType = new cz.nic.xml.epp.keyset_1.UpdateType();

        updateType.setId( keysetUpdateRequest.getKeysetId() );
        updateType.setAdd( keysetAddDataToAddType( keysetUpdateRequest.getAdd() ) );
        updateType.setRem( keysetRemDataToAddType( keysetUpdateRequest.getRem() ) );
        updateType.setChg( keysetChangeDataToChgType( keysetUpdateRequest.getChg() ) );

        return updateType;
    }

    @Override
    public cz.nic.xml.epp.contact_1.UpdateType map(ContactUpdateRequest contactUpdateRequest) {
        if ( contactUpdateRequest == null ) {
            return null;
        }

        cz.nic.xml.epp.contact_1.UpdateType updateType = new cz.nic.xml.epp.contact_1.UpdateType();

        updateType.setChg( contactChangeDataToChgType( contactUpdateRequest.getChg() ) );
        updateType.setId( contactUpdateRequest.getContactId() );

        return updateType;
    }

    @Override
    public AddressData map(AddrType.Addr addr) {
        if ( addr == null ) {
            return null;
        }

        List<String> street = null;
        String city = null;
        String pc = null;
        String cc = null;

        List<String> list = addr.getStreet();
        if ( list != null ) {
            street = new ArrayList<String>( list );
        }
        city = addr.getCity();
        pc = addr.getPc();
        cc = addr.getCc();

        AddressData addressData = new AddressData( city, pc, cc, street );

        addressData.setSp( addr.getSp() );

        return addressData;
    }

    @Override
    protected EnumDomainValidationPollResponse map(ValExpDataT message) {
        if ( message == null ) {
            return null;
        }

        EnumDomainValidationPollResponse enumDomainValidationPollResponse = new EnumDomainValidationPollResponse();

        enumDomainValidationPollResponse.setName( message.getName() );
        enumDomainValidationPollResponse.setValExDate( xmlGregorianCalendarToDate( message.getValExDate() ) );

        enumDomainValidationPollResponse.setEventType( EnumDomainValidationEventType.VAL_EXP_DATA );

        return enumDomainValidationPollResponse;
    }

    @Override
    protected EnumDomainValidationPollResponse map(ImpendingValExpDataT message) {
        if ( message == null ) {
            return null;
        }

        EnumDomainValidationPollResponse enumDomainValidationPollResponse = new EnumDomainValidationPollResponse();

        enumDomainValidationPollResponse.setName( message.getName() );
        enumDomainValidationPollResponse.setValExDate( xmlGregorianCalendarToDate( message.getValExDate() ) );

        enumDomainValidationPollResponse.setEventType( EnumDomainValidationEventType.IMPENDING_VAL_EXP_DATA );

        return enumDomainValidationPollResponse;
    }

    @Override
    protected DomainExpirationPollResponse map(DelDataT message) {
        if ( message == null ) {
            return null;
        }

        DomainExpirationPollResponse domainExpirationPollResponse = new DomainExpirationPollResponse();

        domainExpirationPollResponse.setName( message.getName() );
        domainExpirationPollResponse.setExDate( xmlGregorianCalendarToDate( message.getExDate() ) );

        domainExpirationPollResponse.setEventType( DomainExpirationEventType.DEL_DATA );

        return domainExpirationPollResponse;
    }

    @Override
    protected DomainExpirationPollResponse map(DnsOutageDataT message) {
        if ( message == null ) {
            return null;
        }

        DomainExpirationPollResponse domainExpirationPollResponse = new DomainExpirationPollResponse();

        domainExpirationPollResponse.setName( message.getName() );
        domainExpirationPollResponse.setExDate( xmlGregorianCalendarToDate( message.getExDate() ) );

        domainExpirationPollResponse.setEventType( DomainExpirationEventType.DNS_OUTAGE_DATA );

        return domainExpirationPollResponse;
    }

    @Override
    protected DomainExpirationPollResponse map(ExpDataT message) {
        if ( message == null ) {
            return null;
        }

        DomainExpirationPollResponse domainExpirationPollResponse = new DomainExpirationPollResponse();

        domainExpirationPollResponse.setName( message.getName() );
        domainExpirationPollResponse.setExDate( xmlGregorianCalendarToDate( message.getExDate() ) );

        domainExpirationPollResponse.setEventType( DomainExpirationEventType.EXP_DATA );

        return domainExpirationPollResponse;
    }

    @Override
    protected DomainExpirationPollResponse map(ImpendingExpDataT message) {
        if ( message == null ) {
            return null;
        }

        DomainExpirationPollResponse domainExpirationPollResponse = new DomainExpirationPollResponse();

        domainExpirationPollResponse.setName( message.getName() );
        domainExpirationPollResponse.setExDate( xmlGregorianCalendarToDate( message.getExDate() ) );

        domainExpirationPollResponse.setEventType( DomainExpirationEventType.IMPENDING_EXP_DATA );

        return domainExpirationPollResponse;
    }

    @Override
    public CreditInfoResponse map(ResCreditType resCreditType) {
        if ( resCreditType == null ) {
            return null;
        }

        CreditInfoResponse creditInfoResponse = new CreditInfoResponse();

        creditInfoResponse.setZoneCredit( creditTypeListToZoneCreditList( resCreditType.getZoneCredit() ) );

        return creditInfoResponse;
    }

    @Override
    public KeysetCreateResponse map(CreDataType creDataType) {
        if ( creDataType == null ) {
            return null;
        }

        KeysetCreateResponse keysetCreateResponse = new KeysetCreateResponse();

        keysetCreateResponse.setId( creDataType.getId() );
        keysetCreateResponse.setCrDate( xmlGregorianCalendarToDate( creDataType.getCrDate() ) );

        return keysetCreateResponse;
    }

    @Override
    public NssetCreateResponse map(cz.nic.xml.epp.nsset_1.CreDataType creDataType) {
        if ( creDataType == null ) {
            return null;
        }

        NssetCreateResponse nssetCreateResponse = new NssetCreateResponse();

        nssetCreateResponse.setId( creDataType.getId() );
        nssetCreateResponse.setCrDate( xmlGregorianCalendarToDate( creDataType.getCrDate() ) );

        return nssetCreateResponse;
    }

    @Override
    public ContactCreateResponse map(cz.nic.xml.epp.contact_1.CreDataType creDataType) {
        if ( creDataType == null ) {
            return null;
        }

        ContactCreateResponse contactCreateResponse = new ContactCreateResponse();

        contactCreateResponse.setId( creDataType.getId() );
        contactCreateResponse.setCrDate( xmlGregorianCalendarToDate( creDataType.getCrDate() ) );

        return contactCreateResponse;
    }

    @Override
    public EnumValData map(ExValType exValType) {
        if ( exValType == null ) {
            return null;
        }

        EnumValData enumValData = new EnumValData();

        enumValData.setValExDate( xmlGregorianCalendarToDate( exValType.getValExDate() ) );
        enumValData.setPublish( exValType.getPublish() );

        return enumValData;
    }

    @Override
    public DomainCreateResponse map(cz.nic.xml.epp.domain_1.CreDataType creDataType) {
        if ( creDataType == null ) {
            return null;
        }

        DomainCreateResponse domainCreateResponse = new DomainCreateResponse();

        domainCreateResponse.setName( creDataType.getName() );
        domainCreateResponse.setCrDate( xmlGregorianCalendarToDate( creDataType.getCrDate() ) );
        domainCreateResponse.setExDate( xmlGregorianCalendarToDate( creDataType.getExDate() ) );

        return domainCreateResponse;
    }

    @Override
    public DomainRenewResponse map(RenDataType renDataType) {
        if ( renDataType == null ) {
            return null;
        }

        DomainRenewResponse domainRenewResponse = new DomainRenewResponse();

        domainRenewResponse.setName( renDataType.getName() );
        domainRenewResponse.setExDate( xmlGregorianCalendarToDate( renDataType.getExDate() ) );

        return domainRenewResponse;
    }

    @Override
    public ContactSendAuthInfoResponse map(SendAuthInfoDataType authInfoDataType) {
        if ( authInfoDataType == null ) {
            return null;
        }

        ContactSendAuthInfoResponse contactSendAuthInfoResponse = new ContactSendAuthInfoResponse();

        contactSendAuthInfoResponse.setEmail( authInfoDataType.getEmail() );

        return contactSendAuthInfoResponse;
    }

    @Override
    public DomainSendAuthInfoResponse map(cz.nic.xml.epp.domain_1.SendAuthInfoDataType authInfoDataType) {
        if ( authInfoDataType == null ) {
            return null;
        }

        DomainSendAuthInfoResponse domainSendAuthInfoResponse = new DomainSendAuthInfoResponse();

        domainSendAuthInfoResponse.setEmail( authInfoDataType.getEmail() );

        return domainSendAuthInfoResponse;
    }

    @Override
    public NssetSendAuthInfoResponse map(cz.nic.xml.epp.nsset_1.SendAuthInfoDataType authInfoDataType) {
        if ( authInfoDataType == null ) {
            return null;
        }

        NssetSendAuthInfoResponse nssetSendAuthInfoResponse = new NssetSendAuthInfoResponse();

        nssetSendAuthInfoResponse.setEmail( authInfoDataType.getEmail() );

        return nssetSendAuthInfoResponse;
    }

    @Override
    public KeysetSendAuthInfoResponse map(cz.nic.xml.epp.keyset_1.SendAuthInfoDataType authInfoDataType) {
        if ( authInfoDataType == null ) {
            return null;
        }

        KeysetSendAuthInfoResponse keysetSendAuthInfoResponse = new KeysetSendAuthInfoResponse();

        keysetSendAuthInfoResponse.setEmail( authInfoDataType.getEmail() );

        return keysetSendAuthInfoResponse;
    }

    private static Date xmlGregorianCalendarToDate( XMLGregorianCalendar xcal ) {
        if ( xcal == null ) {
            return null;
        }

        return xcal.toGregorianCalendar().getTime();
    }

    private String checkTypeIdValue(CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        CheckNameType id = checkType.getId();
        if ( id == null ) {
            return null;
        }
        String value = id.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    private Boolean checkTypeIdAvail(CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        CheckNameType id = checkType.getId();
        if ( id == null ) {
            return null;
        }
        boolean avail = id.isAvail();
        return avail;
    }

    private String checkTypeReasonValue(CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        MsgType reason = checkType.getReason();
        if ( reason == null ) {
            return null;
        }
        String value = reason.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    protected List<KeysetCheckData> checkTypeListToKeysetCheckDataList(List<CheckType> list) {
        if ( list == null ) {
            return null;
        }

        List<KeysetCheckData> list1 = new ArrayList<KeysetCheckData>( list.size() );
        for ( CheckType checkType : list ) {
            list1.add( map( checkType ) );
        }

        return list1;
    }

    protected PUnitType periodUnitToPUnitType(PeriodUnit periodUnit) {
        if ( periodUnit == null ) {
            return null;
        }

        PUnitType pUnitType;

        switch ( periodUnit ) {
            case Y: pUnitType = PUnitType.Y;
            break;
            case M: pUnitType = PUnitType.M;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + periodUnit );
        }

        return pUnitType;
    }

    protected cz.nic.xml.epp.domain_1.PeriodType periodTypeToPeriodType(PeriodType periodType) {
        if ( periodType == null ) {
            return null;
        }

        cz.nic.xml.epp.domain_1.PeriodType periodType1 = new cz.nic.xml.epp.domain_1.PeriodType();

        periodType1.setValue( periodType.getValue() );
        periodType1.setUnit( periodUnitToPUnitType( periodType.getUnit() ) );

        return periodType1;
    }

    protected AddressData addrReadTypeToAddressData(AddrReadType addrReadType) {
        if ( addrReadType == null ) {
            return null;
        }

        List<String> street = null;
        String city = null;
        String pc = null;
        String cc = null;

        List<String> list = addrReadType.getStreet();
        if ( list != null ) {
            street = new ArrayList<String>( list );
        }
        city = addrReadType.getCity();
        pc = addrReadType.getPc();
        cc = addrReadType.getCc();

        AddressData addressData = new AddressData( city, pc, cc, street );

        addressData.setSp( addrReadType.getSp() );

        return addressData;
    }

    protected PostalInfoData postalInfoReadTypeToPostalInfoData(PostalInfoReadType postalInfoReadType) {
        if ( postalInfoReadType == null ) {
            return null;
        }

        PostalInfoData postalInfoData = new PostalInfoData();

        postalInfoData.setName( postalInfoReadType.getName() );
        postalInfoData.setOrg( postalInfoReadType.getOrg() );
        postalInfoData.setAddr( addrReadTypeToAddressData( postalInfoReadType.getAddr() ) );

        return postalInfoData;
    }

    protected IdentType identTypeTToIdentType(IdentTypeT identTypeT) {
        if ( identTypeT == null ) {
            return null;
        }

        IdentType identType;

        switch ( identTypeT ) {
            case OP: identType = IdentType.OP;
            break;
            case PASSPORT: identType = IdentType.PASSPORT;
            break;
            case MPSV: identType = IdentType.MPSV;
            break;
            case ICO: identType = IdentType.ICO;
            break;
            case BIRTHDAY: identType = IdentType.BIRTHDAY;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + identTypeT );
        }

        return identType;
    }

    protected IdentificationData identTToIdentificationData(IdentT identT) {
        if ( identT == null ) {
            return null;
        }

        IdentType type = null;
        String value = null;

        type = identTypeTToIdentType( identT.getType() );
        value = identT.getValue();

        IdentificationData identificationData = new IdentificationData( type, value );

        return identificationData;
    }

    protected DnsKeyData dnskeyTToDnsKeyData(DnskeyT dnskeyT) {
        if ( dnskeyT == null ) {
            return null;
        }

        DnsKeyData dnsKeyData = new DnsKeyData();

        dnsKeyData.setFlags( dnskeyT.getFlags() );
        dnsKeyData.setProtocol( dnskeyT.getProtocol() );
        dnsKeyData.setAlg( dnskeyT.getAlg() );
        byte[] pubKey = dnskeyT.getPubKey();
        if ( pubKey != null ) {
            dnsKeyData.setPubKey( Arrays.copyOf( pubKey, pubKey.length ) );
        }

        return dnsKeyData;
    }

    protected List<DnsKeyData> dnskeyTListToDnsKeyDataList(List<DnskeyT> list) {
        if ( list == null ) {
            return null;
        }

        List<DnsKeyData> list1 = new ArrayList<DnsKeyData>( list.size() );
        for ( DnskeyT dnskeyT : list ) {
            list1.add( dnskeyTToDnsKeyData( dnskeyT ) );
        }

        return list1;
    }

    protected NameserverData nsTToNameserverData(NsT nsT) {
        if ( nsT == null ) {
            return null;
        }

        String name = null;

        name = nsT.getName();

        NameserverData nameserverData = new NameserverData( name );

        List<String> list = nsT.getAddr();
        if ( list != null ) {
            nameserverData.setAddr( new ArrayList<String>( list ) );
        }

        return nameserverData;
    }

    protected List<NameserverData> nsTListToNameserverDataList(List<NsT> list) {
        if ( list == null ) {
            return null;
        }

        List<NameserverData> list1 = new ArrayList<NameserverData>( list.size() );
        for ( NsT nsT : list ) {
            list1.add( nsTToNameserverData( nsT ) );
        }

        return list1;
    }

    protected List<ContactCheckData> checkTypeListToContactCheckDataList(List<cz.nic.xml.epp.contact_1.CheckType> list) {
        if ( list == null ) {
            return null;
        }

        List<ContactCheckData> list1 = new ArrayList<ContactCheckData>( list.size() );
        for ( cz.nic.xml.epp.contact_1.CheckType checkType : list ) {
            list1.add( map( checkType ) );
        }

        return list1;
    }

    private String checkTypeIdValue1(cz.nic.xml.epp.contact_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        CheckIDType id = checkType.getId();
        if ( id == null ) {
            return null;
        }
        String value = id.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    private Boolean checkTypeIdAvail1(cz.nic.xml.epp.contact_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        CheckIDType id = checkType.getId();
        if ( id == null ) {
            return null;
        }
        boolean avail = id.isAvail();
        return avail;
    }

    private String checkTypeReasonValue1(cz.nic.xml.epp.contact_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        MsgType reason = checkType.getReason();
        if ( reason == null ) {
            return null;
        }
        String value = reason.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    protected List<DomainCheckData> checkTypeListToDomainCheckDataList(List<cz.nic.xml.epp.domain_1.CheckType> list) {
        if ( list == null ) {
            return null;
        }

        List<DomainCheckData> list1 = new ArrayList<DomainCheckData>( list.size() );
        for ( cz.nic.xml.epp.domain_1.CheckType checkType : list ) {
            list1.add( map( checkType ) );
        }

        return list1;
    }

    private String checkTypeNameValue(cz.nic.xml.epp.domain_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        cz.nic.xml.epp.domain_1.CheckNameType name = checkType.getName();
        if ( name == null ) {
            return null;
        }
        String value = name.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    private Boolean checkTypeNameAvail(cz.nic.xml.epp.domain_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        cz.nic.xml.epp.domain_1.CheckNameType name = checkType.getName();
        if ( name == null ) {
            return null;
        }
        boolean avail = name.isAvail();
        return avail;
    }

    private String checkTypeReasonValue2(cz.nic.xml.epp.domain_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        MsgType reason = checkType.getReason();
        if ( reason == null ) {
            return null;
        }
        String value = reason.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    protected List<NssetCheckData> checkTypeListToNssetCheckDataList(List<cz.nic.xml.epp.nsset_1.CheckType> list) {
        if ( list == null ) {
            return null;
        }

        List<NssetCheckData> list1 = new ArrayList<NssetCheckData>( list.size() );
        for ( cz.nic.xml.epp.nsset_1.CheckType checkType : list ) {
            list1.add( map( checkType ) );
        }

        return list1;
    }

    private String checkTypeIdValue2(cz.nic.xml.epp.nsset_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        cz.nic.xml.epp.nsset_1.CheckNameType id = checkType.getId();
        if ( id == null ) {
            return null;
        }
        String value = id.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    private Boolean checkTypeIdAvail2(cz.nic.xml.epp.nsset_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        cz.nic.xml.epp.nsset_1.CheckNameType id = checkType.getId();
        if ( id == null ) {
            return null;
        }
        boolean avail = id.isAvail();
        return avail;
    }

    private String checkTypeReasonValue3(cz.nic.xml.epp.nsset_1.CheckType checkType) {
        if ( checkType == null ) {
            return null;
        }
        MsgType reason = checkType.getReason();
        if ( reason == null ) {
            return null;
        }
        String value = reason.getValue();
        if ( value == null ) {
            return null;
        }
        return value;
    }

    protected List<NsT> nameserverDataListToNsTList(List<NameserverData> list) {
        if ( list == null ) {
            return null;
        }

        List<NsT> list1 = new ArrayList<NsT>( list.size() );
        for ( NameserverData nameserverData : list ) {
            list1.add( map( nameserverData ) );
        }

        return list1;
    }

    protected DnskeyT dnsKeyDataToDnskeyT(DnsKeyData dnsKeyData) {
        if ( dnsKeyData == null ) {
            return null;
        }

        DnskeyT dnskeyT = new DnskeyT();

        dnskeyT.setFlags( dnsKeyData.getFlags() );
        dnskeyT.setProtocol( dnsKeyData.getProtocol() );
        dnskeyT.setAlg( dnsKeyData.getAlg() );
        byte[] pubKey = dnsKeyData.getPubKey();
        if ( pubKey != null ) {
            dnskeyT.setPubKey( Arrays.copyOf( pubKey, pubKey.length ) );
        }

        return dnskeyT;
    }

    protected List<DnskeyT> dnsKeyDataListToDnskeyTList(List<DnsKeyData> list) {
        if ( list == null ) {
            return null;
        }

        List<DnskeyT> list1 = new ArrayList<DnskeyT>( list.size() );
        for ( DnsKeyData dnsKeyData : list ) {
            list1.add( dnsKeyDataToDnskeyT( dnsKeyData ) );
        }

        return list1;
    }

    protected PostalInfoType postalInfoDataToPostalInfoType(PostalInfoData postalInfoData) {
        if ( postalInfoData == null ) {
            return null;
        }

        PostalInfoType postalInfoType = new PostalInfoType();

        postalInfoType.setName( postalInfoData.getName() );
        postalInfoType.setOrg( postalInfoData.getOrg() );
        postalInfoType.setAddr( map( postalInfoData.getAddr() ) );

        return postalInfoType;
    }

    protected IdentTypeT identTypeToIdentTypeT(IdentType identType) {
        if ( identType == null ) {
            return null;
        }

        IdentTypeT identTypeT;

        switch ( identType ) {
            case OP: identTypeT = IdentTypeT.OP;
            break;
            case PASSPORT: identTypeT = IdentTypeT.PASSPORT;
            break;
            case MPSV: identTypeT = IdentTypeT.MPSV;
            break;
            case ICO: identTypeT = IdentTypeT.ICO;
            break;
            case BIRTHDAY: identTypeT = IdentTypeT.BIRTHDAY;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + identType );
        }

        return identTypeT;
    }

    protected IdentT identificationDataToIdentT(IdentificationData identificationData) {
        if ( identificationData == null ) {
            return null;
        }

        IdentT identT = new IdentT();

        identT.setValue( identificationData.getValue() );
        identT.setType( identTypeToIdentTypeT( identificationData.getType() ) );

        return identT;
    }

    protected ZoneCredit creditTypeToZoneCredit(CreditType creditType) {
        if ( creditType == null ) {
            return null;
        }

        ZoneCredit zoneCredit = new ZoneCredit();

        zoneCredit.setZone( creditType.getZone() );
        zoneCredit.setCredit( creditType.getCredit() );

        return zoneCredit;
    }

    private InfDataType updateDataTOldDataInfData(UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        OldData oldData = updateDataT.getOldData();
        if ( oldData == null ) {
            return null;
        }
        InfDataType infData = oldData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private InfDataType updateDataTNewDataInfData(UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        NewData newData = updateDataT.getNewData();
        if ( newData == null ) {
            return null;
        }
        InfDataType infData = newData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private cz.nic.xml.epp.contact_1.InfDataType updateDataTOldDataInfData1(cz.nic.xml.epp.contact_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        cz.nic.xml.epp.contact_1.OldData oldData = updateDataT.getOldData();
        if ( oldData == null ) {
            return null;
        }
        cz.nic.xml.epp.contact_1.InfDataType infData = oldData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private cz.nic.xml.epp.contact_1.InfDataType updateDataTNewDataInfData1(cz.nic.xml.epp.contact_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        cz.nic.xml.epp.contact_1.NewData newData = updateDataT.getNewData();
        if ( newData == null ) {
            return null;
        }
        cz.nic.xml.epp.contact_1.InfDataType infData = newData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private cz.nic.xml.epp.nsset_1.InfDataType updateDataTOldDataInfData2(cz.nic.xml.epp.nsset_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        cz.nic.xml.epp.nsset_1.OldData oldData = updateDataT.getOldData();
        if ( oldData == null ) {
            return null;
        }
        cz.nic.xml.epp.nsset_1.InfDataType infData = oldData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private cz.nic.xml.epp.nsset_1.InfDataType updateDataTNewDataInfData2(cz.nic.xml.epp.nsset_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        cz.nic.xml.epp.nsset_1.NewData newData = updateDataT.getNewData();
        if ( newData == null ) {
            return null;
        }
        cz.nic.xml.epp.nsset_1.InfDataType infData = newData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private cz.nic.xml.epp.keyset_1.InfDataType updateDataTOldDataInfData3(cz.nic.xml.epp.keyset_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        cz.nic.xml.epp.keyset_1.OldData oldData = updateDataT.getOldData();
        if ( oldData == null ) {
            return null;
        }
        cz.nic.xml.epp.keyset_1.InfDataType infData = oldData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    private cz.nic.xml.epp.keyset_1.InfDataType updateDataTNewDataInfData3(cz.nic.xml.epp.keyset_1.UpdateDataT updateDataT) {
        if ( updateDataT == null ) {
            return null;
        }
        cz.nic.xml.epp.keyset_1.NewData newData = updateDataT.getNewData();
        if ( newData == null ) {
            return null;
        }
        cz.nic.xml.epp.keyset_1.InfDataType infData = newData.getInfData();
        if ( infData == null ) {
            return null;
        }
        return infData;
    }

    protected TechnicalCheckResult resultTypeToTechnicalCheckResult(ResultType resultType) {
        if ( resultType == null ) {
            return null;
        }

        TechnicalCheckResult technicalCheckResult = new TechnicalCheckResult();

        technicalCheckResult.setTestname( resultType.getTestname() );
        technicalCheckResult.setStatus( resultType.isStatus() );
        technicalCheckResult.setNote( resultType.getNote() );

        return technicalCheckResult;
    }

    protected List<TechnicalCheckResult> resultTypeListToTechnicalCheckResultList(List<ResultType> list) {
        if ( list == null ) {
            return null;
        }

        List<TechnicalCheckResult> list1 = new ArrayList<TechnicalCheckResult>( list.size() );
        for ( ResultType resultType : list ) {
            list1.add( resultTypeToTechnicalCheckResult( resultType ) );
        }

        return list1;
    }

    protected List<NsT> nameserverDataListToNsTList1(List<NameserverData> list) {
        if ( list == null ) {
            return null;
        }

        List<NsT> list1 = new ArrayList<NsT>( list.size() );
        for ( NameserverData nameserverData : list ) {
            list1.add( map( nameserverData ) );
        }

        return list1;
    }

    protected AddType nssetAddDataToAddType(NssetAddData nssetAddData) {
        if ( nssetAddData == null ) {
            return null;
        }

        AddType addType = new AddType();

        if ( addType.getNs() != null ) {
            List<NsT> list = nameserverDataListToNsTList1( nssetAddData.getNs() );
            if ( list != null ) {
                addType.getNs().addAll( list );
            }
        }
        if ( addType.getTech() != null ) {
            List<String> list1 = nssetAddData.getTech();
            if ( list1 != null ) {
                addType.getTech().addAll( list1 );
            }
        }

        return addType;
    }

    protected RemType nssetRemDataToRemType(NssetRemData nssetRemData) {
        if ( nssetRemData == null ) {
            return null;
        }

        RemType remType = new RemType();

        if ( remType.getName() != null ) {
            List<String> list = nssetRemData.getName();
            if ( list != null ) {
                remType.getName().addAll( list );
            }
        }
        if ( remType.getTech() != null ) {
            List<String> list1 = nssetRemData.getTech();
            if ( list1 != null ) {
                remType.getTech().addAll( list1 );
            }
        }

        return remType;
    }

    protected ChgType nssetChangeDataToChgType(NssetChangeData nssetChangeData) {
        if ( nssetChangeData == null ) {
            return null;
        }

        ChgType chgType = new ChgType();

        chgType.setAuthInfo( nssetChangeData.getAuthInfo() );

        return chgType;
    }

    protected cz.nic.xml.epp.domain_1.AddType domainAddDataToAddType(DomainAddData domainAddData) {
        if ( domainAddData == null ) {
            return null;
        }

        cz.nic.xml.epp.domain_1.AddType addType = new cz.nic.xml.epp.domain_1.AddType();

        if ( addType.getAdmin() != null ) {
            List<String> list = domainAddData.getAdmin();
            if ( list != null ) {
                addType.getAdmin().addAll( list );
            }
        }

        return addType;
    }

    protected cz.nic.xml.epp.domain_1.RemType domainRemDataToRemType(DomainRemData domainRemData) {
        if ( domainRemData == null ) {
            return null;
        }

        cz.nic.xml.epp.domain_1.RemType remType = new cz.nic.xml.epp.domain_1.RemType();

        if ( remType.getAdmin() != null ) {
            List<String> list = domainRemData.getAdmin();
            if ( list != null ) {
                remType.getAdmin().addAll( list );
            }
        }

        return remType;
    }

    protected cz.nic.xml.epp.domain_1.ChgType domainChangeDataToChgType(DomainChangeData domainChangeData) {
        if ( domainChangeData == null ) {
            return null;
        }

        cz.nic.xml.epp.domain_1.ChgType chgType = new cz.nic.xml.epp.domain_1.ChgType();

        chgType.setNsset( domainChangeData.getNsset() );
        chgType.setKeyset( domainChangeData.getKeyset() );
        chgType.setRegistrant( domainChangeData.getRegistrant() );
        chgType.setAuthInfo( domainChangeData.getAuthInfo() );

        return chgType;
    }

    protected cz.nic.xml.epp.keyset_1.AddType keysetAddDataToAddType(KeysetAddData keysetAddData) {
        if ( keysetAddData == null ) {
            return null;
        }

        cz.nic.xml.epp.keyset_1.AddType addType = new cz.nic.xml.epp.keyset_1.AddType();

        if ( addType.getDnskey() != null ) {
            List<DnskeyT> list = dnsKeyDataListToDnskeyTList( keysetAddData.getDnskey() );
            if ( list != null ) {
                addType.getDnskey().addAll( list );
            }
        }
        if ( addType.getTech() != null ) {
            List<String> list1 = keysetAddData.getTech();
            if ( list1 != null ) {
                addType.getTech().addAll( list1 );
            }
        }

        return addType;
    }

    protected cz.nic.xml.epp.keyset_1.AddType keysetRemDataToAddType(KeysetRemData keysetRemData) {
        if ( keysetRemData == null ) {
            return null;
        }

        cz.nic.xml.epp.keyset_1.AddType addType = new cz.nic.xml.epp.keyset_1.AddType();

        if ( addType.getDnskey() != null ) {
            List<DnskeyT> list = dnsKeyDataListToDnskeyTList( keysetRemData.getDnskey() );
            if ( list != null ) {
                addType.getDnskey().addAll( list );
            }
        }
        if ( addType.getTech() != null ) {
            List<String> list1 = keysetRemData.getTech();
            if ( list1 != null ) {
                addType.getTech().addAll( list1 );
            }
        }

        return addType;
    }

    protected cz.nic.xml.epp.keyset_1.ChgType keysetChangeDataToChgType(KeysetChangeData keysetChangeData) {
        if ( keysetChangeData == null ) {
            return null;
        }

        cz.nic.xml.epp.keyset_1.ChgType chgType = new cz.nic.xml.epp.keyset_1.ChgType();

        chgType.setAuthInfo( keysetChangeData.getAuthInfo() );

        return chgType;
    }

    protected ChgPostalInfoType postalInfoDataToChgPostalInfoType(PostalInfoData postalInfoData) {
        if ( postalInfoData == null ) {
            return null;
        }

        ChgPostalInfoType chgPostalInfoType = new ChgPostalInfoType();

        chgPostalInfoType.setName( postalInfoData.getName() );
        chgPostalInfoType.setOrg( postalInfoData.getOrg() );
        chgPostalInfoType.setAddr( map( postalInfoData.getAddr() ) );

        return chgPostalInfoType;
    }

    protected IdentUpdT identificationDataToIdentUpdT(IdentificationData identificationData) {
        if ( identificationData == null ) {
            return null;
        }

        IdentUpdT identUpdT = new IdentUpdT();

        identUpdT.setValue( identificationData.getValue() );
        identUpdT.setType( identTypeToIdentTypeT( identificationData.getType() ) );

        return identUpdT;
    }

    protected cz.nic.xml.epp.contact_1.ChgType contactChangeDataToChgType(ContactChangeData contactChangeData) {
        if ( contactChangeData == null ) {
            return null;
        }

        cz.nic.xml.epp.contact_1.ChgType chgType = new cz.nic.xml.epp.contact_1.ChgType();

        chgType.setDisclose( toInfupdDiscloseType( contactChangeData.getDisclose() ) );
        chgType.setPostalInfo( postalInfoDataToChgPostalInfoType( contactChangeData.getPostalInfo() ) );
        chgType.setVoice( contactChangeData.getVoice() );
        chgType.setFax( contactChangeData.getFax() );
        chgType.setEmail( contactChangeData.getEmail() );
        chgType.setAuthInfo( contactChangeData.getAuthInfo() );
        chgType.setVat( contactChangeData.getVat() );
        chgType.setIdent( identificationDataToIdentUpdT( contactChangeData.getIdent() ) );
        chgType.setNotifyEmail( contactChangeData.getNotifyEmail() );

        return chgType;
    }

    protected List<ZoneCredit> creditTypeListToZoneCreditList(List<CreditType> list) {
        if ( list == null ) {
            return null;
        }

        List<ZoneCredit> list1 = new ArrayList<ZoneCredit>( list.size() );
        for ( CreditType creditType : list ) {
            list1.add( creditTypeToZoneCredit( creditType ) );
        }

        return list1;
    }
}
