/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.collect.Sets;
import cz.afri.smg.graphs.CLangSMGConsistencyVerifier;
import cz.afri.smg.graphs.CLangStackFrame;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGValues;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.types.CFunctionDeclaration;
import cz.afri.smg.types.CType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class CLangSMG
extends SMG
implements WritableSMG {
    private final ArrayDeque<CLangStackFrame> stackObjects = new ArrayDeque();
    private final HashSet<SMGObject> heapObjects = new HashSet();
    private final HashMap<String, SMGRegion> globalObjects = new HashMap();
    private boolean hasLeaks = false;
    private static boolean performChecks = false;

    public static void setPerformChecks(boolean pSetting) {
        performChecks = pSetting;
    }

    public static boolean performChecks() {
        return performChecks;
    }

    public CLangSMG() {
        this.heapObjects.add(this.getNullObject());
    }

    public CLangSMG(CLangSMG pHeap) {
        super(pHeap);
        for (CLangStackFrame stackFrame : pHeap.stackObjects) {
            CLangStackFrame newFrame = new CLangStackFrame(stackFrame);
            this.stackObjects.add(newFrame);
        }
        this.heapObjects.addAll(pHeap.heapObjects);
        this.globalObjects.putAll(pHeap.globalObjects);
        this.hasLeaks = pHeap.hasLeaks;
    }

    @Override
    public void addHeapObject(SMGObject pObject) {
        if (CLangSMG.performChecks() && this.heapObjects.contains(pObject)) {
            throw new IllegalArgumentException("Heap object already in the SMG: [" + pObject + "]");
        }
        this.heapObjects.add(pObject);
        this.addObject(pObject);
    }

    private void addGlobalObject(SMGRegion pObject) {
        if (CLangSMG.performChecks() && this.globalObjects.values().contains(pObject)) {
            throw new IllegalArgumentException("Global object already in the SMG: [" + pObject + "]");
        }
        if (CLangSMG.performChecks() && this.globalObjects.containsKey(pObject.getLabel())) {
            throw new IllegalArgumentException("Global object with label [" + pObject.getLabel() + "] already in the SMG");
        }
        this.globalObjects.put(pObject.getLabel(), pObject);
        super.addObject(pObject);
    }

    private void addStackObject(SMGRegion pObject) {
        super.addObject(pObject);
        this.stackObjects.peek().addStackVariable(pObject.getLabel(), pObject);
    }

    @Override
    public void addStackFrame(CFunctionDeclaration pFunctionDeclaration) {
        CLangStackFrame newFrame = new CLangStackFrame(pFunctionDeclaration);
        SMGRegion returnObject = newFrame.getReturnObject();
        if (returnObject != null) {
            super.addObject(newFrame.getReturnObject());
        }
        this.stackObjects.push(newFrame);
    }

    @Override
    public void setMemoryLeak() {
        this.hasLeaks = true;
    }

    @Override
    public void dropStackFrame() {
        CLangStackFrame frame = this.stackObjects.pop();
        for (SMGObject object : frame.getAllObjects()) {
            this.removeObjectAndEdges(object);
        }
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(this);
        }
    }

    @Override
    public void pruneUnreachable() {
        HashSet<SMGObject> seenObjects = new HashSet<SMGObject>();
        HashSet<Integer> seenValues = new HashSet<Integer>();
        ArrayDeque<SMGObject> workqueue = new ArrayDeque<SMGObject>();
        for (CLangStackFrame frame : this.getStackFrames()) {
            for (SMGObject stackObject : frame.getAllObjects()) {
                workqueue.add(stackObject);
            }
        }
        workqueue.addAll(this.getGlobalObjects().values());
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        while (!workqueue.isEmpty()) {
            SMGObject processed = (SMGObject)workqueue.remove();
            if (seenObjects.contains(processed)) continue;
            seenObjects.add(processed);
            filter.filterByObject(processed);
            for (SMGEdgeHasValue outbound : this.getHVEdges(filter)) {
                SMGObject pointedObject = this.getObjectPointedBy(outbound.getValue());
                if (pointedObject != null && !seenObjects.contains(pointedObject)) {
                    workqueue.add(pointedObject);
                }
                if (seenValues.contains(outbound.getValue())) continue;
                seenValues.add(outbound.getValue());
            }
        }
        HashSet strayObjects = new HashSet(Sets.difference(this.getObjects(), seenObjects));
        for (SMGObject strayObject : strayObjects) {
            if (!strayObject.notNull()) continue;
            if (this.isObjectValid(strayObject)) {
                this.setMemoryLeak();
            }
            this.removeObjectAndEdges(strayObject);
            this.heapObjects.remove(strayObject);
        }
        HashSet strayValues = new HashSet(Sets.difference(this.getValues(), seenValues));
        for (Integer strayValue : strayValues) {
            if (strayValue.intValue() == this.getNullValue()) continue;
            if (this.isPointer(strayValue)) {
                this.removePointsToEdge(strayValue);
            }
            this.removeValue(strayValue);
        }
    }

    public String toString() {
        return "CLangSMG [\n stack_objects=" + this.stackObjects + "\n heap_objects=" + this.heapObjects + "\n global_objects=" + this.globalObjects + "\n " + this.valuesToString() + "\n " + this.ptToString() + "\n " + this.hvToString() + "\n]";
    }

    @Override
    public SMGRegion getObjectForVisibleVariable(String pVariableName) {
        if (this.stackObjects.size() != 0 && this.stackObjects.peek().containsVariable(pVariableName)) {
            return this.stackObjects.peek().getVariable(pVariableName);
        }
        if (this.globalObjects.containsKey(pVariableName)) {
            return this.globalObjects.get(pVariableName);
        }
        throw new UnsupportedOperationException("No object for variable name: " + pVariableName);
    }

    @Override
    public boolean hasLocalVariable(String pVariableName) {
        return this.stackObjects.size() > 0 && this.stackObjects.peek().containsVariable(pVariableName);
    }

    @Override
    public ArrayDeque<CLangStackFrame> getStackFrames() {
        return this.stackObjects;
    }

    @Override
    public Set<SMGObject> getHeapObjects() {
        return Collections.unmodifiableSet(this.heapObjects);
    }

    @Override
    public boolean isHeapObject(SMGObject object) {
        return this.heapObjects.contains(object);
    }

    @Override
    public Map<String, SMGRegion> getGlobalObjects() {
        return Collections.unmodifiableMap(this.globalObjects);
    }

    @Override
    public boolean hasMemoryLeaks() {
        return this.hasLeaks;
    }

    @Override
    public SMGRegion getStackReturnObject(int pUp) {
        return this.stackObjects.peek().getReturnObject();
    }

    @Override
    public String getFunctionName(SMGRegion pObject) {
        for (CLangStackFrame cLangStack : this.stackObjects) {
            if (!cLangStack.getAllObjects().contains(pObject)) continue;
            return cLangStack.getFunctionDeclaration().getName();
        }
        throw new IllegalArgumentException("No function name for non-stack object");
    }

    @Override
    public void mergeValues(int v1, int v2) {
        super.mergeValues(v1, v2);
    }

    @Override
    public final void removeHeapObject(SMGObject pObject) {
        if (!this.isHeapObject(pObject)) {
            throw new IllegalArgumentException("Cannot directly remove non-heap objects");
        }
        this.heapObjects.remove(pObject);
        this.removeObjectAndEdges(pObject);
    }

    @Override
    public boolean containsValue(Integer pValue) {
        return this.getValues().contains(pValue);
    }

    @Override
    public boolean isUnequal(int value1, int value2) {
        if (this.isPointer(value1) && this.isPointer(value2) && value1 != value2) {
            SMGEdgePointsTo edge1 = this.getPointer(value1);
            SMGEdgePointsTo edge2 = this.getPointer(value2);
            return edge1.getObject() != edge2.getObject() || edge1.getOffset() != edge2.getOffset();
        }
        return false;
    }

    @Override
    public Integer getAddress(SMGObject pMemory, Integer pOffset) {
        Iterable pointsToEdges = this.getPTEdges();
        for (SMGEdgePointsTo edge : pointsToEdges) {
            if (!edge.getObject().equals(pMemory) || edge.getOffset() != pOffset.intValue()) continue;
            return edge.getValue();
        }
        return null;
    }

    @Override
    public SMGValues.SMGSymbolicValue readValue(SMGObject pObject, int pOffset, CType pType) {
        if (!this.isObjectValid(pObject)) {
            throw new UnsupportedOperationException("No value can be read from an invalid object");
        }
        SMGEdgeHasValue edge = new SMGEdgeHasValue(pType, pOffset, pObject, 0);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject).filterAtOffset(pOffset);
        for (SMGEdgeHasValue objectEdge : this.getHVEdges(filter)) {
            if (!edge.isCompatibleFieldOnSameObject(objectEdge)) continue;
            return SMGValues.SMGKnownSymValue.valueOf(objectEdge.getValue());
        }
        if (this.isCoveredByNullifiedBlocks(edge)) {
            return SMGValues.SMGKnownSymValue.ZERO;
        }
        return SMGValues.SMGUnknownValue.getInstance();
    }

    public void free(Integer pAddress, Integer pOffset, SMGRegion pRegion) {
        if (!this.isHeapObject(pRegion)) {
            return;
        }
        if (pOffset != 0) {
            return;
        }
        if (!this.isObjectValid(pRegion)) {
            return;
        }
        this.setValidity(pRegion, false);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pRegion);
        ArrayList<SMGEdgeHasValue> toRemove = new ArrayList<SMGEdgeHasValue>();
        for (SMGEdgeHasValue edge : this.getHVEdges(filter)) {
            toRemove.add(edge);
        }
        for (SMGEdgeHasValue edge : toRemove) {
            this.removeHasValueEdge(edge);
        }
    }

    @Override
    public boolean isGlobalObject(SMGObject pObject) {
        if (pObject.isAbstract()) {
            return false;
        }
        return this.getGlobalObjects().containsValue(pObject);
    }

    @Override
    public SMGRegion addGlobalVariable(CType pType, String pVarName) {
        int size = pType.getSize();
        SMGRegion newObject = new SMGRegion(size, pVarName);
        this.addGlobalObject(newObject);
        return newObject;
    }

    @Override
    public SMGRegion addLocalVariable(CType pType, String pVarName) {
        int size = pType.getSize();
        SMGRegion newObject = new SMGRegion(size, pVarName);
        this.addStackObject(newObject);
        return newObject;
    }

    @Override
    public boolean isIdenticalTo(ReadableSMG pOther) {
        if (!(pOther instanceof CLangSMG)) {
            throw new IllegalArgumentException("Cannot compare CLangSMG to non-CLangSMG");
        }
        CLangSMG other = (CLangSMG)pOther;
        if (!super.isIdenticalTo(other)) {
            return false;
        }
        boolean stackIdentical = Arrays.equals(this.stackObjects.toArray(), other.stackObjects.toArray());
        boolean heapIdentical = this.heapObjects.equals(other.heapObjects);
        boolean globalIdentical = this.globalObjects.equals(other.globalObjects);
        return stackIdentical && heapIdentical && globalIdentical;
    }
}

