/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.collect.Sets;
import cz.afri.smg.graphs.CLangSMG;
import cz.afri.smg.graphs.CLangStackFrame;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGConsistencyVerifier;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class CLangSMGConsistencyVerifier {
    private CLangSMGConsistencyVerifier() {
    }

    private static boolean verifyCLangSMGProperty(boolean pResult, String pMessage) {
        return pResult;
    }

    private static boolean verifyDisjunctHeapAndGlobal(ReadableSMG pSmg) {
        Map<String, SMGRegion> globals = pSmg.getGlobalObjects();
        Set<SMGObject> heap = pSmg.getHeapObjects();
        boolean toReturn = Collections.disjoint(globals.values(), heap);
        if (!toReturn) {
            throw new IllegalStateException("CLangSMG inconsistent, heap and global objects are not disjoint");
        }
        return toReturn;
    }

    private static boolean verifyDisjunctHeapAndStack(ReadableSMG pSmg) {
        ArrayDeque<CLangStackFrame> stackFrames = pSmg.getStackFrames();
        HashSet<SMGObject> stack = new HashSet<SMGObject>();
        for (CLangStackFrame frame : stackFrames) {
            stack.addAll(frame.getAllObjects());
        }
        Set<SMGObject> heap = pSmg.getHeapObjects();
        boolean toReturn = Collections.disjoint(stack, heap);
        if (!toReturn) {
            Sets.SetView intersection = Sets.intersection(stack, heap);
            String message = "CLangSMG inconsistent, heap and stack objects are not disjoint: " + intersection;
            throw new IllegalStateException(message);
        }
        return toReturn;
    }

    private static boolean verifyDisjunctGlobalAndStack(ReadableSMG pSmg) {
        ArrayDeque<CLangStackFrame> stackFrames = pSmg.getStackFrames();
        HashSet<SMGObject> stack = new HashSet<SMGObject>();
        for (CLangStackFrame frame : stackFrames) {
            stack.addAll(frame.getAllObjects());
        }
        Map<String, SMGRegion> globals = pSmg.getGlobalObjects();
        boolean toReturn = Collections.disjoint(stack, globals.values());
        if (!toReturn) {
            throw new IllegalStateException("CLangSMG inconsistent, global and stack objects are not disjoint");
        }
        return toReturn;
    }

    private static boolean verifyStackGlobalHeapUnion(ReadableSMG pSmg) {
        boolean toReturn;
        HashSet<SMGObject> objectUnion = new HashSet<SMGObject>();
        objectUnion.addAll(pSmg.getHeapObjects());
        objectUnion.addAll(pSmg.getGlobalObjects().values());
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            objectUnion.addAll(frame.getAllObjects());
        }
        boolean bl = toReturn = objectUnion.containsAll(pSmg.getObjects()) && pSmg.getObjects().containsAll(objectUnion);
        if (!toReturn) {
            String message = "CLangSMG inconsistent: stack, heap and global object set union not identical to SMG object set";
            throw new IllegalStateException(message);
        }
        return toReturn;
    }

    private static boolean verifyNullObjectCLangProperties(ReadableSMG pSmg) {
        for (SMGObject sMGObject : pSmg.getGlobalObjects().values()) {
            if (sMGObject.notNull()) continue;
            return false;
        }
        SMGObject firstNull = null;
        for (SMGObject obj : pSmg.getHeapObjects()) {
            if (obj.notNull()) continue;
            if (firstNull != null) {
                String message = "CLangSMG inconsistent: second null object in heap object set [first=" + firstNull + ", second=" + obj + "]";
                throw new IllegalStateException(message);
            }
            firstNull = obj;
        }
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            for (SMGObject obj : frame.getAllObjects()) {
                if (obj.notNull()) continue;
                return false;
            }
        }
        return firstNull != null;
    }

    private static boolean verifyGlobalNamespace(ReadableSMG pSmg) {
        Map<String, SMGRegion> globals = pSmg.getGlobalObjects();
        for (String label : pSmg.getGlobalObjects().keySet()) {
            String globalLabel = globals.get(label).getLabel();
            if (globalLabel.equals(label)) continue;
            String message = "CLangSMG inconsistent: label [" + label + "] points to an object with label [" + pSmg.getGlobalObjects().get(label).getLabel() + "]";
            throw new IllegalStateException(message);
        }
        return true;
    }

    private static boolean verifyStackNamespaces(ReadableSMG pSmg) {
        HashSet<SMGObject> stackObjects = new HashSet<SMGObject>();
        for (CLangStackFrame frame : pSmg.getStackFrames()) {
            for (SMGObject object : frame.getAllObjects()) {
                if (stackObjects.contains(object)) {
                    String message = "CLangSMG inconsistent: object [" + object + "] present multiple times in the stack";
                    throw new IllegalStateException(message);
                }
                stackObjects.add(object);
            }
        }
        return true;
    }

    public static boolean verifyCLangSMG(ReadableSMG pReadableSMG) {
        if (!(pReadableSMG instanceof CLangSMG)) {
            throw new IllegalArgumentException("Attempted to check consistency of something that is not CLangSMG instance");
        }
        CLangSMG pSmg = (CLangSMG)pReadableSMG;
        boolean toReturn = SMGConsistencyVerifier.verifySMG(pSmg);
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctHeapAndGlobal(pSmg), "Checking CLangSMG consistency: heap and global object sets are disjunt");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctHeapAndStack(pSmg), "Checking CLangSMG consistency: heap and stack objects are disjunct");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyDisjunctGlobalAndStack(pSmg), "Checking CLangSMG consistency: global and stack objects are disjunct");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyStackGlobalHeapUnion(pSmg), "Checking CLangSMG consistency: global, stack and heap object union contains all objects in SMG");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyNullObjectCLangProperties(pSmg), "Checking CLangSMG consistency: null object invariants hold");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyGlobalNamespace(pSmg), "Checking CLangSMG consistency: global namespace problem");
        toReturn = toReturn && CLangSMGConsistencyVerifier.verifyCLangSMGProperty(CLangSMGConsistencyVerifier.verifyStackNamespaces(pSmg), "Checking CLangSMG consistency: stack namespace");
        return toReturn;
    }
}

