/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.types.CFunctionDeclaration;
import cz.afri.smg.types.CType;
import cz.afri.smg.types.CVoidType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class CLangStackFrame {
    static final String RETVAL_LABEL = "___cpa_temp_result_var_";
    private final CFunctionDeclaration stackFunction;
    private final HashMap<String, SMGRegion> stackVariables = new HashMap();
    private final SMGRegion returnValueObject;

    public CLangStackFrame(CFunctionDeclaration pDeclaration) {
        this.stackFunction = pDeclaration;
        CType returnType = pDeclaration.getType().getReturnType();
        if (returnType instanceof CVoidType) {
            this.returnValueObject = null;
        } else {
            int returnValueSize = returnType.getSize();
            this.returnValueObject = new SMGRegion(returnValueSize, RETVAL_LABEL);
        }
    }

    public CLangStackFrame(CLangStackFrame pFrame) {
        this.stackFunction = pFrame.stackFunction;
        this.stackVariables.putAll(pFrame.stackVariables);
        this.returnValueObject = pFrame.returnValueObject;
    }

    public void addStackVariable(String pVariableName, SMGRegion pObject) {
        if (this.stackVariables.containsKey(pVariableName)) {
            throw new IllegalArgumentException("Stack frame for function '" + this.stackFunction.toString() + "' already contains a variable '" + pVariableName + "'");
        }
        this.stackVariables.put(pVariableName, pObject);
    }

    public String toString() {
        StringBuilder toReturn = new StringBuilder("<");
        for (Map.Entry<String, SMGRegion> entry : this.stackVariables.entrySet()) {
            toReturn.append(" ").append(entry);
        }
        toReturn.append(" >");
        return toReturn.toString();
    }

    public SMGRegion getVariable(String pName) {
        SMGRegion toReturn = this.stackVariables.get(pName);
        if (toReturn == null) {
            throw new NoSuchElementException("No variable with name '" + pName + "' in stack frame for function '" + this.stackFunction.toString() + "'");
        }
        return toReturn;
    }

    public boolean containsVariable(String pName) {
        return this.stackVariables.containsKey(pName);
    }

    public CFunctionDeclaration getFunctionDeclaration() {
        return this.stackFunction;
    }

    public Map<String, SMGRegion> getVariables() {
        return Collections.unmodifiableMap(this.stackVariables);
    }

    public Set<SMGObject> getAllObjects() {
        HashSet<SMGRegion> retset = new HashSet<SMGRegion>();
        retset.addAll(this.stackVariables.values());
        if (this.returnValueObject != null) {
            retset.add(this.returnValueObject);
        }
        return Collections.unmodifiableSet(retset);
    }

    public SMGRegion getReturnObject() {
        return this.returnValueObject;
    }
}

