/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class NeqRelation {
    private final SetMultimap<Integer, Integer> smgValues = HashMultimap.create();

    NeqRelation() {
    }

    public int hashCode() {
        return this.smgValues.hashCode();
    }

    public Set<Integer> getNeqsForValue(Integer pV) {
        return Collections.unmodifiableSet(this.smgValues.get((Object)pV));
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NeqRelation other = (NeqRelation)obj;
        return other.smgValues != null && this.smgValues.equals(other.smgValues);
    }

    public void addRelation(Integer pOne, Integer pTwo) {
        if (pOne.intValue() == pTwo.intValue()) {
            return;
        }
        this.smgValues.put((Object)pOne, (Object)pTwo);
        this.smgValues.put((Object)pTwo, (Object)pOne);
    }

    public void putAll(NeqRelation pNeq) {
        this.smgValues.putAll(pNeq.smgValues);
    }

    public void removeRelation(Integer pOne, Integer pTwo) {
        this.smgValues.remove((Object)pOne, (Object)pTwo);
        this.smgValues.remove((Object)pTwo, (Object)pOne);
    }

    public boolean neqExists(Integer pOne, Integer pTwo) {
        return this.smgValues.containsEntry((Object)pOne, (Object)pTwo);
    }

    public void removeValue(Integer pOne) {
        for (Integer other : this.smgValues.get((Object)pOne)) {
            this.smgValues.get((Object)other).remove(pOne);
        }
        this.smgValues.removeAll((Object)pOne);
    }

    public void mergeValues(Integer pB, Integer pC) {
        ImmutableList values = ImmutableList.copyOf((Collection)this.smgValues.get((Object)pC));
        this.removeValue(pC);
        for (Integer value : values) {
            this.addRelation(pB, value);
        }
    }

    public String toString() {
        return "neq_rel=" + this.smgValues.toString();
    }
}

