/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.collect.Iterables;
import cz.afri.smg.graphs.NeqRelation;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGValues;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.types.CType;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class SMG {
    private final HashSet<SMGObject> objects = new HashSet();
    private final HashSet<Integer> values = new HashSet();
    private final HashSet<SMGEdgeHasValue> hvEdges = new HashSet();
    private final HashMap<Integer, SMGEdgePointsTo> ptEdges = new HashMap();
    private final HashMap<SMGObject, Boolean> objectValidity = new HashMap();
    private final NeqRelation neq = new NeqRelation();
    private final Map<SMGValues.SMGKnownSymValue, SMGValues.SMGKnownExpValue> explicitValues = new HashMap<SMGValues.SMGKnownSymValue, SMGValues.SMGKnownExpValue>();
    private static final SMGObject NULL_OBJECT = SMGObject.getNullObject();
    private static final int NULL_ADDRESS = 0;

    public SMG() {
        SMGEdgePointsTo nullPointer = new SMGEdgePointsTo(0, NULL_OBJECT, 0);
        this.addObject(NULL_OBJECT);
        this.objectValidity.put(NULL_OBJECT, false);
        this.addValue(0);
        this.addPointsToEdge(nullPointer);
    }

    public SMG(SMG pHeap) {
        this.objects.addAll(pHeap.objects);
        this.values.addAll(pHeap.values);
        this.hvEdges.addAll(pHeap.hvEdges);
        this.ptEdges.putAll(pHeap.ptEdges);
        this.objectValidity.putAll(pHeap.objectValidity);
        this.explicitValues.putAll(pHeap.explicitValues);
        this.neq.putAll(pHeap.neq);
    }

    public int hashCode() {
        return Objects.hash(this.hvEdges, this.neq, this.objectValidity, this.objects, this.ptEdges, this.values, this.explicitValues);
    }

    public final void addObject(SMGObject pObj) {
        this.addObject(pObj, true);
    }

    public final void removeValue(Integer pValue) {
        this.values.remove(pValue);
        this.neq.removeValue(pValue);
    }

    public final void removeObject(SMGObject pObj) {
        this.objects.remove(pObj);
        this.objectValidity.remove(pObj);
    }

    public final void removeObjectAndEdges(SMGObject pObj) {
        this.removeObject(pObj);
        Iterator<SMGEdgeHasValue> hvIter = this.hvEdges.iterator();
        Iterator<SMGEdgePointsTo> ptIter = this.ptEdges.values().iterator();
        while (hvIter.hasNext()) {
            if (hvIter.next().getObject() != pObj) continue;
            hvIter.remove();
        }
        while (ptIter.hasNext()) {
            if (ptIter.next().getObject() != pObj) continue;
            ptIter.remove();
        }
    }

    public final void addObject(SMGObject pObj, boolean pValidity) {
        this.objects.add(pObj);
        this.objectValidity.put(pObj, pValidity);
    }

    public final void addValue(Integer pValue) {
        this.values.add(pValue);
    }

    public final void addPointsToEdge(SMGEdgePointsTo pEdge) {
        this.ptEdges.put(pEdge.getValue(), pEdge);
    }

    public final void addHasValueEdge(SMGEdgeHasValue pEdge) {
        this.hvEdges.add(pEdge);
    }

    public final void removeHasValueEdge(SMGEdgeHasValue pEdge) {
        this.hvEdges.remove(pEdge);
    }

    public final void removePointsToEdge(Integer pValue) {
        this.ptEdges.remove(pValue);
    }

    public void setValidity(SMGRegion pObject, boolean pValidity) {
        if (!this.objects.contains(pObject)) {
            throw new IllegalArgumentException("Object [" + pObject + "] not in SMG");
        }
        this.objectValidity.put(pObject, pValidity);
    }

    public void replaceHVSet(Set<SMGEdgeHasValue> pNewHV) {
        this.hvEdges.clear();
        this.hvEdges.addAll(pNewHV);
    }

    public void addNeqRelation(Integer pV1, Integer pV2) {
        this.neq.addRelation(pV1, pV2);
    }

    public final SMGObject getNullObject() {
        return NULL_OBJECT;
    }

    public final int getNullValue() {
        return 0;
    }

    public final String valuesToString() {
        return "values=" + this.values.toString();
    }

    public final String hvToString() {
        return "hasValue=" + this.hvEdges.toString();
    }

    public final String ptToString() {
        return "pointsTo=" + this.ptEdges.toString();
    }

    public final Set<Integer> getValues() {
        return Collections.unmodifiableSet(this.values);
    }

    public final Set<SMGObject> getObjects() {
        return Collections.unmodifiableSet(this.objects);
    }

    public final Set<SMGEdgeHasValue> getHVEdges() {
        return Collections.unmodifiableSet(this.hvEdges);
    }

    public final Iterable<SMGEdgeHasValue> getHVEdges(SMGEdgeHasValueFilter pFilter) {
        return Iterables.filter(Collections.unmodifiableSet(this.hvEdges), pFilter.asPredicate());
    }

    public final SMGEdgeHasValue getUniqueHV(SMGEdgeHasValueFilter pFilter, boolean pCheck) {
        Iterator<SMGEdgeHasValue> it = this.getHVEdges(pFilter).iterator();
        SMGEdgeHasValue hv = it.next();
        if (pCheck && it.hasNext()) {
            throw new IllegalArgumentException("Applying filter does not result in unique HV edge");
        }
        return hv;
    }

    public final Set<SMGEdgePointsTo> getPTEdges() {
        return Collections.unmodifiableSet(new HashSet<SMGEdgePointsTo>(this.ptEdges.values()));
    }

    public final SMGObject getObjectPointedBy(Integer pValue) {
        if (!this.values.contains(pValue)) {
            throw new IllegalArgumentException("Value [" + pValue + "] not in SMG");
        }
        if (this.ptEdges.containsKey(pValue)) {
            return this.ptEdges.get(pValue).getObject();
        }
        return null;
    }

    public final boolean isObjectValid(SMGObject pObject) {
        if (!this.objects.contains(pObject)) {
            throw new IllegalArgumentException("Object [" + pObject + "] not in SMG");
        }
        return this.objectValidity.get(pObject);
    }

    public BitSet getNullBytesForObject(SMGObject pObj) {
        BitSet bs = new BitSet(pObj.getSize());
        bs.clear();
        SMGEdgeHasValueFilter objectFilter = SMGEdgeHasValueFilter.objectFilter(pObj).filterHavingValue(this.getNullValue());
        for (SMGEdgeHasValue edge : this.getHVEdges(objectFilter)) {
            bs.set(edge.getOffset(), edge.getOffset() + edge.getSizeInBytes());
        }
        return bs;
    }

    public boolean isPointer(Integer value) {
        return this.ptEdges.containsKey(value);
    }

    public SMGEdgePointsTo getPointer(Integer value) {
        if (this.ptEdges.containsKey(value)) {
            return this.ptEdges.get(value);
        }
        throw new IllegalArgumentException("Asked for a PT edge of a non-pointer");
    }

    public boolean isCoveredByNullifiedBlocks(SMGEdgeHasValue pEdge) {
        return this.isCoveredByNullifiedBlocks(pEdge.getObject(), pEdge.getOffset(), pEdge.getSizeInBytes());
    }

    public boolean isCoveredByNullifiedBlocks(SMGObject pObject, int pOffset, CType pType) {
        return this.isCoveredByNullifiedBlocks(pObject, pOffset, pType.getSize());
    }

    private boolean isCoveredByNullifiedBlocks(SMGObject pObject, int pOffset, int size) {
        BitSet objectNullBytes = this.getNullBytesForObject(pObject);
        int expectedMinClear = pOffset + size;
        return objectNullBytes.nextClearBit(pOffset) >= expectedMinClear;
    }

    public void mergeValues(int pV1, int pV2) {
        if (pV1 == pV2) {
            return;
        }
        if (pV2 == 0) {
            this.mergeValues(pV2, pV1);
        }
        this.neq.mergeValues(pV1, pV2);
        this.removeValue(pV2);
        HashSet<SMGEdgeHasValue> newHvEdges = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValue hv : this.hvEdges) {
            if (hv.getValue() != pV2) {
                newHvEdges.add(hv);
                continue;
            }
            newHvEdges.add(new SMGEdgeHasValue(hv.getSizeInBytes(), hv.getOffset(), hv.getObject(), pV1));
        }
        this.hvEdges.clear();
        this.hvEdges.addAll(newHvEdges);
    }

    public boolean haveNeqRelation(Integer pV1, Integer pV2) {
        return this.neq.neqExists(pV1, pV2);
    }

    public Set<Integer> getNeqsForValue(Integer pV) {
        return this.neq.getNeqsForValue(pV);
    }

    public void putExplicit(SMGValues.SMGKnownSymValue pKey, SMGValues.SMGKnownExpValue pValue) {
        this.explicitValues.put(pKey, pValue);
    }

    public SMGValues.SMGExplicitValue getExplicit(SMGValues.SMGKnownSymValue pKey) {
        if (this.explicitValues.containsKey(pKey)) {
            return this.explicitValues.get(pKey);
        }
        return SMGValues.SMGUnknownValue.getInstance();
    }

    public void clearExplicit(SMGValues.SMGKnownSymValue pKey) {
        this.explicitValues.remove(pKey);
    }

    public boolean isIdenticalTo(SMG pOther) {
        return this.objects.equals(pOther.objects) && this.values.equals(pOther.values) && this.hvEdges.equals(pOther.hvEdges) && this.ptEdges.equals(pOther.ptEdges) && this.objectValidity.equals(pOther.objectValidity) && this.neq.equals(pOther.neq) && this.explicitValues.equals(pOther.explicitValues);
    }
}

