/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.collect.Iterables;
import cz.afri.smg.graphs.SMG;
import cz.afri.smg.graphs.SMGEdge;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.objects.SMGObject;
import java.util.ArrayList;

final class SMGConsistencyVerifier {
    private SMGConsistencyVerifier() {
    }

    private static boolean verifySMGProperty(boolean pResult, String pMessage) {
        return pResult;
    }

    private static boolean verifyNullObject(SMG pSmg) {
        Integer nullValue = null;
        for (Integer value : pSmg.getValues()) {
            if (pSmg.getObjectPointedBy(value) != pSmg.getNullObject()) continue;
            nullValue = value;
            break;
        }
        if (nullValue == null) {
            return false;
        }
        if (pSmg.getObjectPointedBy(pSmg.getNullValue()) != pSmg.getNullObject()) {
            return false;
        }
        if (pSmg.getNullValue() != nullValue.intValue()) {
            return false;
        }
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pSmg.getNullObject());
        if (pSmg.getHVEdges(filter).iterator().hasNext()) {
            return false;
        }
        if (pSmg.isObjectValid(pSmg.getNullObject())) {
            return false;
        }
        return pSmg.getNullObject().getSize() == 0;
    }

    private static boolean verifyInvalidRegionsHaveNoHVEdges(SMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            SMGEdgeHasValueFilter filter;
            if (pSmg.isObjectValid(obj) || !pSmg.getHVEdges(filter = SMGEdgeHasValueFilter.objectFilter(obj)).iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    private static boolean checkSingleFieldConsistency(SMGObject pObject, SMG pSmg) {
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject);
        for (SMGEdgeHasValue hvEdge : pSmg.getHVEdges(filter)) {
            if (hvEdge.getOffset() + hvEdge.getSizeInBytes() <= pObject.getSize()) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyFieldConsistency(SMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            if (SMGConsistencyVerifier.checkSingleFieldConsistency(obj, pSmg)) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyEdgeConsistency(SMG pSmg, Iterable<? extends SMGEdge> pEdges) {
        ArrayList toVerify = new ArrayList();
        Iterables.addAll(toVerify, pEdges);
        while (toVerify.size() > 0) {
            SMGEdge edge = (SMGEdge)toVerify.get(0);
            toVerify.remove(0);
            if (!pSmg.getObjects().contains(edge.getObject())) {
                return false;
            }
            if (!pSmg.getValues().contains(edge.getValue())) {
                return false;
            }
            for (SMGEdge otherOdge : toVerify) {
                if (edge.isConsistentWith(otherOdge)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean verifyObjectConsistency(SMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            try {
                pSmg.isObjectValid(obj);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            if (obj.getSize() < 0) {
                return false;
            }
            if (pSmg.isObjectValid(obj) || !obj.isAbstract()) continue;
            return false;
        }
        return true;
    }

    public static boolean verifySMG(SMG pSmg) {
        boolean toReturn = true;
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyNullObject(pSmg), "null object invariants hold");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyInvalidRegionsHaveNoHVEdges(pSmg), "invalid regions have no outgoing edges");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyFieldConsistency(pSmg), "field consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyEdgeConsistency(pSmg, pSmg.getHVEdges()), "Has Value edge consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyEdgeConsistency(pSmg, pSmg.getPTEdges()), "Points To edge consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyObjectConsistency(pSmg), "Validity consistency");
        return toReturn;
    }
}

