/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import cz.afri.smg.graphs.SMGEdge;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.types.CType;

public class SMGEdgeHasValue
extends SMGEdge {
    private final CType type;
    private final int offset;

    public SMGEdgeHasValue(CType pType, int pOffset, SMGObject pObject, int pValue) {
        super(pValue, pObject);
        this.type = pType;
        this.offset = pOffset;
    }

    public SMGEdgeHasValue(int pSizeInBytes, int pOffset, SMGObject pObject, int pValue) {
        super(pValue, pObject);
        this.type = CType.createTypeWithLength(pSizeInBytes);
        this.offset = pOffset;
    }

    public final String toString() {
        return "sizeof(" + this.type.toString() + ")b @ " + this.getObject().getLabel() + "+" + this.offset + "b has value " + this.getValue();
    }

    public final int getOffset() {
        return this.offset;
    }

    public final CType getType() {
        return this.type;
    }

    public final int getSizeInBytes() {
        return this.type.getSize();
    }

    @Override
    public final boolean isConsistentWith(SMGEdge other) {
        if (!(other instanceof SMGEdgeHasValue)) {
            return false;
        }
        if (this.getObject() == other.getObject() && this.offset == ((SMGEdgeHasValue)other).offset && this.type == ((SMGEdgeHasValue)other).type) {
            return this.getValue() == other.getValue();
        }
        return true;
    }

    public final boolean overlapsWith(SMGEdgeHasValue other) {
        if (this.getObject() != other.getObject()) {
            String message = "Call of overlapsWith() on Has-Value edges pair not originating from the same object";
            throw new IllegalArgumentException(message);
        }
        int otStart = other.getOffset();
        int otEnd = otStart + other.getType().getSize();
        return this.overlapsWith(otStart, otEnd);
    }

    public final boolean overlapsWith(int pOtStart, int pOtEnd) {
        int myStart = this.offset;
        int myEnd = myStart + this.type.getSize();
        if (myStart < pOtStart) {
            return myEnd > pOtStart;
        }
        if (pOtStart < myStart) {
            return pOtEnd > myStart;
        }
        return true;
    }

    public final boolean isCompatibleField(SMGEdgeHasValue other) {
        return this.type.equals(other.type) && this.offset == other.offset;
    }

    public final boolean isCompatibleFieldOnSameObject(SMGEdgeHasValue other) {
        return this.type.getSize() == other.type.getSize() && this.offset == other.offset && this.getObject() == other.getObject();
    }

    public final int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.offset;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SMGEdgeHasValue other = (SMGEdgeHasValue)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

