/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.base.Predicate;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.types.CType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SMGEdgeHasValueFilter {
    private SMGObject object = null;
    private Integer value = null;
    private boolean valueComplement = false;
    private Integer offset = null;
    private CType type = null;

    public static SMGEdgeHasValueFilter objectFilter(SMGObject pObject) {
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        filter.filterByObject(pObject);
        return filter;
    }

    public final SMGEdgeHasValueFilter filterByObject(SMGObject pObject) {
        this.object = pObject;
        return this;
    }

    public final SMGEdgeHasValueFilter filterHavingValue(Integer pValue) {
        this.value = pValue;
        this.valueComplement = false;
        return this;
    }

    public final SMGEdgeHasValueFilter filterNotHavingValue(Integer pValue) {
        this.value = pValue;
        this.valueComplement = true;
        return this;
    }

    public final SMGEdgeHasValueFilter filterAtOffset(Integer pOffset) {
        this.offset = pOffset;
        return this;
    }

    public final SMGEdgeHasValueFilter filterByType(CType pType) {
        this.type = pType;
        return this;
    }

    public final boolean holdsFor(SMGEdgeHasValue pEdge) {
        if (this.object != null && this.object != pEdge.getObject()) {
            return false;
        }
        if (this.value != null) {
            if (this.valueComplement && pEdge.getValue() == this.value.intValue()) {
                return false;
            }
            if (!this.valueComplement && pEdge.getValue() != this.value.intValue()) {
                return false;
            }
        }
        if (this.offset != null && this.offset.intValue() != pEdge.getOffset()) {
            return false;
        }
        return this.type == null || this.type.equals(pEdge.getType());
    }

    public final Set<SMGEdgeHasValue> filterSet(Set<SMGEdgeHasValue> pEdges) {
        HashSet<SMGEdgeHasValue> returnSet = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValue edge : pEdges) {
            if (!this.holdsFor(edge)) continue;
            returnSet.add(edge);
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public final Predicate<SMGEdgeHasValue> asPredicate() {
        return new Predicate<SMGEdgeHasValue>(){

            public boolean apply(SMGEdgeHasValue pEdge) {
                return SMGEdgeHasValueFilter.this.holdsFor(pEdge);
            }
        };
    }
}

