/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGObjectNode;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGObjectVisitor;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.objects.sll.SMGSingleLinkedList;
import cz.afri.smg.objects.tree.SimpleBinaryTree;

class SMGNodeDotVisitor
extends SMGObjectVisitor {
    private final ReadableSMG smg;
    private SMGObjectNode node = null;

    public SMGNodeDotVisitor(ReadableSMG pSmg) {
        this.smg = pSmg;
    }

    private String defaultDefinition(String pColor, String pShape, String pStyle, SMGObject pObject) {
        return "color=" + pColor + ", shape=" + pShape + ", style=" + pStyle + ", label =\"" + pObject.toString() + "\"";
    }

    @Override
    public void visit(SMGRegion pRegion) {
        String style;
        String color;
        String shape = "rectangle";
        if (this.smg.isObjectValid(pRegion)) {
            color = "black";
            style = "solid";
        } else {
            color = "red";
            style = "dotted";
        }
        this.node = new SMGObjectNode("region", this.defaultDefinition(color, shape, style, pRegion));
    }

    @Override
    public void visit(SMGSingleLinkedList pSll) {
        String shape = "rectangle";
        String color = "blue";
        String style = "dashed";
        this.node = new SMGObjectNode("sll", this.defaultDefinition(color, shape, style, pSll));
    }

    @Override
    public void visit(SimpleBinaryTree pTree) {
        String shape = "rectangle";
        String color = "green";
        String style = "dashed";
        this.node = new SMGObjectNode("tree", this.defaultDefinition(color, shape, style, pTree));
    }

    @Override
    public void visit(SMGObject pObject) {
        if (pObject.notNull()) {
            pObject.accept(this);
        } else {
            this.node = new SMGObjectNode("NULL");
        }
    }

    public SMGObjectNode getNode() {
        return this.node;
    }
}

