/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import cz.afri.smg.graphs.CLangStackFrame;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGNodeDotVisitor;
import cz.afri.smg.graphs.SMGObjectNode;
import cz.afri.smg.graphs.SMGValues;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class SMGPlotter {
    private final HashMap<SMGObject, SMGObjectNode> objectIndex = new HashMap();
    private static int nulls = 0;
    private int offset = 0;

    public static void debuggingPlot(ReadableSMG pSmg, String pId) throws IOException {
        SMGPlotter plotter = new SMGPlotter();
        PrintWriter writer = new PrintWriter(pId + ".dot", "UTF-8");
        writer.write(plotter.smgAsDot(pSmg, pId, pId));
        writer.close();
    }

    public static String convertToValidDot(String original) {
        return original.replaceAll("[:]", "_");
    }

    public String smgAsDot(ReadableSMG smg, String name, String location) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph gr_" + name.replace('-', '_') + "{\n");
        this.offset += 2;
        sb.append(this.newLineWithOffset("label = \"Location: " + location.replace("\"", "\\\"") + "\";"));
        this.addStackSubgraph(smg, sb);
        SMGNodeDotVisitor visitor = new SMGNodeDotVisitor(smg);
        for (SMGObject sMGObject : smg.getHeapObjects()) {
            if (!this.objectIndex.containsKey(sMGObject)) {
                visitor.visit(sMGObject);
                this.objectIndex.put(sMGObject, visitor.getNode());
            }
            if (!sMGObject.notNull()) continue;
            sb.append(this.newLineWithOffset(this.objectIndex.get(sMGObject).getDefinition()));
        }
        this.addGlobalObjectSubgraph(smg, sb);
        for (Integer n : smg.getValues()) {
            if (n.intValue() == smg.getNullValue()) continue;
            SMGValues.SMGExplicitValue explicitValue = smg.getExplicit(SMGValues.SMGKnownSymValue.valueOf(n));
            String explicitValueString = explicitValue.isUnknown() ? "" : " : " + String.valueOf(explicitValue.getAsLong());
            sb.append(this.newLineWithOffset(SMGPlotter.smgValueAsDot(n, explicitValueString)));
        }
        for (SMGEdgeHasValue sMGEdgeHasValue : smg.getHVEdges()) {
            sb.append(this.newLineWithOffset(this.smgHVEdgeAsDot(sMGEdgeHasValue)));
        }
        for (SMGEdgePointsTo sMGEdgePointsTo : smg.getPTEdges()) {
            if (sMGEdgePointsTo.getValue() == smg.getNullValue()) continue;
            sb.append(this.newLineWithOffset(this.smgPTEdgeAsDot(sMGEdgePointsTo)));
        }
        sb.append("}");
        return sb.toString();
    }

    private void addStackSubgraph(ReadableSMG pSmg, StringBuilder pSb) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack {"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("label=\"Stack\";"));
        int i = pSmg.getStackFrames().size();
        for (CLangStackFrame stackItem : pSmg.getStackFrames()) {
            this.addStackItemSubgraph(stackItem, pSb, i);
            --i;
        }
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private void addStackItemSubgraph(CLangStackFrame pStackFrame, StringBuilder pSb, int pIndex) {
        pSb.append(this.newLineWithOffset("subgraph cluster_stack_" + pStackFrame.getFunctionDeclaration().getName() + "{"));
        this.offset += 2;
        pSb.append(this.newLineWithOffset("fontcolor=blue;"));
        pSb.append(this.newLineWithOffset("label=\"#" + pIndex + ": " + pStackFrame.getFunctionDeclaration().toString() + "\";"));
        HashMap<String, SMGRegion> toPrint = new HashMap<String, SMGRegion>();
        toPrint.putAll(pStackFrame.getVariables());
        SMGRegion returnObject = pStackFrame.getReturnObject();
        if (returnObject != null) {
            toPrint.put("___cpa_temp_result_var_", returnObject);
        }
        pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(toPrint, String.valueOf(pIndex))));
        this.offset -= 2;
        pSb.append(this.newLineWithOffset("}"));
    }

    private String smgScopeFrameAsDot(Map<String, SMGRegion> pNamespace, String pStructId) {
        StringBuilder sb = new StringBuilder();
        sb.append("struct" + pStructId + "[shape=record,label=\" ");
        ArrayList<String> nodes = new ArrayList<String>();
        for (Map.Entry<String, SMGRegion> entry : pNamespace.entrySet()) {
            String key = entry.getKey();
            SMGObject obj = entry.getValue();
            if (key.equals("node")) {
                key = "node1";
            }
            nodes.add("<item_" + key + "> " + obj.toString());
            this.objectIndex.put(obj, new SMGObjectNode("struct" + pStructId + ":item_" + key));
        }
        sb.append(Joiner.on((String)" | ").join(nodes));
        sb.append("\"];\n");
        return sb.toString();
    }

    private void addGlobalObjectSubgraph(ReadableSMG pSmg, StringBuilder pSb) {
        if (pSmg.getGlobalObjects().size() > 0) {
            pSb.append(this.newLineWithOffset("subgraph cluster_global{"));
            this.offset += 2;
            pSb.append(this.newLineWithOffset("label=\"Global objects\";"));
            pSb.append(this.newLineWithOffset(this.smgScopeFrameAsDot(pSmg.getGlobalObjects(), "global")));
            this.offset -= 2;
            pSb.append(this.newLineWithOffset("}"));
        }
    }

    private static String newNullLabel() {
        return "value_null_" + ++nulls;
    }

    private String smgHVEdgeAsDot(SMGEdgeHasValue pEdge) {
        if (pEdge.getValue() == 0) {
            String newNull = SMGPlotter.newNullLabel();
            return newNull + "[shape=plaintext, label=\"NULL\"];" + this.objectIndex.get(pEdge.getObject()).getName() + " -> " + newNull + "[label=\"[" + pEdge.getOffset() + "]\"];";
        }
        return this.objectIndex.get(pEdge.getObject()).getName() + " -> value_" + pEdge.getValue() + "[label=\"[" + pEdge.getOffset() + "]\"];";
    }

    private String smgPTEdgeAsDot(SMGEdgePointsTo pEdge) {
        return "value_" + pEdge.getValue() + " -> " + this.objectIndex.get(pEdge.getObject()).getName() + "[label=\"+" + pEdge.getOffset() + "b\"];";
    }

    private static String smgValueAsDot(int pValue, String pExplicit) {
        return "value_" + pValue + "[label=\"#" + pValue + pExplicit + "\"];";
    }

    private static String neqRelationAsDot(Integer v1, Integer v2) {
        String targetNode;
        String returnString = "";
        if (v2.equals(0)) {
            targetNode = SMGPlotter.newNullLabel();
            returnString = targetNode + "[shape=plaintext, label=\"NULL\", fontcolor=\"red\"];\n";
        } else {
            targetNode = "value_" + v2;
        }
        return returnString + "value_" + v1 + " -> " + targetNode + "[color=\"red\", fontcolor=\"red\", label=\"neq\"]";
    }

    private String newLineWithOffset(String pLine) {
        return Strings.repeat((String)" ", (int)this.offset) + pLine + "\n";
    }
}

