/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.graphs;

import com.google.common.base.Preconditions;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.types.CType;
import java.math.BigInteger;

public class SMGValues {

    public static interface SMGSymbolicValue
    extends SMGValue {
    }

    static class SMGAddress {
        public static final SMGAddress UNKNOWN = new SMGAddress(null, SMGUnknownValue.getInstance());
        private final SMGObject object;
        private final SMGExplicitValue offset;

        protected SMGAddress(SMGObject pObject, SMGExplicitValue pOffset) {
            Preconditions.checkNotNull((Object)pOffset);
            this.object = pObject;
            this.offset = pOffset;
        }

        public final boolean isUnknown() {
            return this.object == null || this.offset.isUnknown();
        }

        public final SMGAddress add(SMGExplicitValue pAddedOffset) {
            if (this.object == null || this.offset.isUnknown() || pAddedOffset.isUnknown()) {
                return UNKNOWN;
            }
            return SMGAddress.valueOf(this.object, this.offset.add(pAddedOffset));
        }

        public SMGExplicitValue getOffset() {
            return this.offset;
        }

        public final SMGObject getObject() {
            return this.object;
        }

        public static SMGAddress valueOf(SMGObject object, SMGExplicitValue offset) {
            return new SMGAddress(object, offset);
        }

        public final String toString() {
            if (this.isUnknown()) {
                return "Unkown";
            }
            return "Object: " + this.object.toString() + " Offset: " + this.offset.toString();
        }

        public static SMGAddress valueOf(SMGObject pObj, int pOffset) {
            return new SMGAddress(pObj, SMGKnownExpValue.valueOf(pOffset));
        }
    }

    static final class SMGKnownAddVal
    extends SMGKnownSymValue
    implements SMGAddressValue {
        private final SMGKnownAddress address;

        private SMGKnownAddVal(BigInteger pValue, SMGKnownAddress pAddress) {
            super(pValue);
            Preconditions.checkNotNull((Object)pAddress);
            this.address = pAddress;
        }

        public static SMGKnownAddVal valueOf(SMGObject pObject, SMGKnownExpValue pOffset, SMGKnownSymValue pAddress) {
            return new SMGKnownAddVal(pAddress.getValue(), SMGKnownAddress.valueOf(pObject, pOffset));
        }

        @Override
        public SMGKnownAddress getAddress() {
            return this.address;
        }

        public static SMGKnownAddVal valueOf(BigInteger pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(pValue, pAddress);
        }

        public static SMGKnownAddVal valueOf(SMGKnownSymValue pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(pValue.getValue(), pAddress);
        }

        public static SMGKnownAddVal valueOf(int pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), pAddress);
        }

        public static SMGKnownAddVal valueOf(long pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), pAddress);
        }

        public static SMGKnownAddVal valueOf(int pValue, SMGObject object, int offset) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), SMGKnownAddress.valueOf(object, offset));
        }

        @Override
        public String toString() {
            return "Value: " + super.toString() + " " + this.address.toString();
        }

        @Override
        public SMGKnownExpValue getOffset() {
            return this.address.getOffset();
        }

        @Override
        public SMGObject getObject() {
            return this.address.getObject();
        }

        private static final class SMGKnownAddress
        extends SMGAddress {
            private SMGKnownAddress(SMGObject pObject, SMGKnownExpValue pOffset) {
                super(pObject, pOffset);
            }

            public static SMGKnownAddress valueOf(SMGObject pObject, int pOffset) {
                return new SMGKnownAddress(pObject, SMGKnownExpValue.valueOf(pOffset));
            }

            public static SMGKnownAddress valueOf(SMGObject object, SMGKnownExpValue offset) {
                return new SMGKnownAddress(object, offset);
            }

            @Override
            public SMGKnownExpValue getOffset() {
                return (SMGKnownExpValue)super.getOffset();
            }
        }
    }

    static final class SMGField {
        private static final SMGField UNKNOWN = new SMGField(SMGUnknownValue.getInstance(), CType.unknownType());
        private final SMGExplicitValue offset;
        private final CType type;

        public SMGField(SMGExplicitValue pOffset, CType pType) {
            Preconditions.checkNotNull((Object)pOffset);
            Preconditions.checkNotNull((Object)pType);
            this.offset = pOffset;
            this.type = pType;
        }

        public SMGExplicitValue getOffset() {
            return this.offset;
        }

        public CType getType() {
            return this.type;
        }

        public boolean isUnknown() {
            return this.offset.isUnknown();
        }

        public String toString() {
            return "offset: " + this.offset + "Type:" + this.type.toString();
        }

        public static SMGField getUnknownInstance() {
            return UNKNOWN;
        }
    }

    static final class SMGUnknownValue
    implements SMGSymbolicValue,
    SMGExplicitValue,
    SMGAddressValue {
        private static final SMGUnknownValue INSTANCE = new SMGUnknownValue();

        SMGUnknownValue() {
        }

        public String toString() {
            return "UNKNOWN";
        }

        public static SMGUnknownValue getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public SMGAddress getAddress() {
            return SMGAddress.UNKNOWN;
        }

        @Override
        public BigInteger getValue() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public int getAsInt() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public long getAsLong() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public SMGExplicitValue negate() {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue xor(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue or(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue and(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue divide(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue add(SMGExplicitValue pRVal) {
            return INSTANCE;
        }

        @Override
        public SMGExplicitValue getOffset() {
            return INSTANCE;
        }

        @Override
        public SMGObject getObject() {
            return null;
        }
    }

    public static final class SMGKnownExpValue
    extends SMGKnownValue
    implements SMGExplicitValue {
        public static final SMGKnownExpValue ONE = new SMGKnownExpValue(BigInteger.ONE);
        public static final SMGKnownExpValue ZERO = new SMGKnownExpValue(BigInteger.ZERO);

        private SMGKnownExpValue(BigInteger pValue) {
            super(pValue);
        }

        @Override
        public boolean equals(Object pObj) {
            if (!(pObj instanceof SMGKnownExpValue)) {
                return false;
            }
            return super.equals(pObj);
        }

        @Override
        public int hashCode() {
            int result = 5;
            result = 31 * result + super.hashCode();
            return result;
        }

        @Override
        public SMGExplicitValue negate() {
            return SMGKnownExpValue.valueOf(this.getValue().negate());
        }

        @Override
        public SMGExplicitValue xor(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().xor(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue or(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().or(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue and(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().and(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().shiftLeft(pRVal.getAsInt()));
        }

        @Override
        public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().multiply(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue divide(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().divide(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().subtract(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue add(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().add(pRVal.getValue()));
        }

        public static SMGKnownExpValue valueOf(int pValue) {
            if (pValue == 0) {
                return ZERO;
            }
            if (pValue == 1) {
                return ONE;
            }
            return new SMGKnownExpValue(BigInteger.valueOf(pValue));
        }

        public static SMGKnownExpValue valueOf(long pValue) {
            if (pValue == 0L) {
                return ZERO;
            }
            if (pValue == 1L) {
                return ONE;
            }
            return new SMGKnownExpValue(BigInteger.valueOf(pValue));
        }

        public static SMGKnownExpValue valueOf(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            if (pValue.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (pValue.equals(BigInteger.ONE)) {
                return ONE;
            }
            return new SMGKnownExpValue(pValue);
        }
    }

    public static class SMGKnownSymValue
    extends SMGKnownValue
    implements SMGSymbolicValue {
        public static final SMGKnownSymValue ZERO = new SMGKnownSymValue(BigInteger.ZERO);
        public static final SMGKnownSymValue ONE = new SMGKnownSymValue(BigInteger.ONE);
        public static final SMGKnownSymValue TRUE = new SMGKnownSymValue(BigInteger.valueOf(-1L));
        public static final SMGKnownSymValue FALSE = ZERO;

        protected SMGKnownSymValue(BigInteger pValue) {
            super(pValue);
        }

        public static SMGKnownSymValue valueOf(int pValue) {
            if (pValue == 0) {
                return ZERO;
            }
            if (pValue == 1) {
                return ONE;
            }
            return new SMGKnownSymValue(BigInteger.valueOf(pValue));
        }

        public static SMGKnownSymValue valueOf(long pValue) {
            if (pValue == 0L) {
                return ZERO;
            }
            if (pValue == 1L) {
                return ONE;
            }
            return new SMGKnownSymValue(BigInteger.valueOf(pValue));
        }

        public static SMGKnownSymValue valueOf(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            if (pValue.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (pValue.equals(BigInteger.ONE)) {
                return ONE;
            }
            return new SMGKnownSymValue(pValue);
        }

        @Override
        public final boolean equals(Object pObj) {
            if (!(pObj instanceof SMGKnownSymValue)) {
                return false;
            }
            return super.equals(pObj);
        }

        @Override
        public final int hashCode() {
            int result = 17;
            result = 31 * result + super.hashCode();
            return result;
        }
    }

    static abstract class SMGKnownValue {
        private final BigInteger value;

        private SMGKnownValue(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = pValue;
        }

        private SMGKnownValue(long pValue) {
            this.value = BigInteger.valueOf(pValue);
        }

        private SMGKnownValue(int pValue) {
            this.value = BigInteger.valueOf(pValue);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof SMGKnownValue)) {
                return false;
            }
            SMGKnownValue otherValue = (SMGKnownValue)pObj;
            return this.value.equals(otherValue.value);
        }

        public int hashCode() {
            int result = 5;
            int c = this.value.hashCode();
            return result * 31 + c;
        }

        public final BigInteger getValue() {
            return this.value;
        }

        public final int getAsInt() {
            return this.value.intValue();
        }

        public final long getAsLong() {
            return this.value.longValue();
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean isUnknown() {
            return false;
        }
    }

    public static interface SMGExplicitValue
    extends SMGValue {
        public SMGExplicitValue negate();

        public SMGExplicitValue xor(SMGExplicitValue var1);

        public SMGExplicitValue or(SMGExplicitValue var1);

        public SMGExplicitValue and(SMGExplicitValue var1);

        public SMGExplicitValue shiftLeft(SMGExplicitValue var1);

        public SMGExplicitValue multiply(SMGExplicitValue var1);

        public SMGExplicitValue divide(SMGExplicitValue var1);

        public SMGExplicitValue subtract(SMGExplicitValue var1);

        public SMGExplicitValue add(SMGExplicitValue var1);
    }

    static interface SMGAddressValue
    extends SMGSymbolicValue {
        @Override
        public boolean isUnknown();

        public SMGAddress getAddress();

        public SMGExplicitValue getOffset();

        public SMGObject getObject();
    }

    static interface SMGValue {
        public boolean isUnknown();

        public BigInteger getValue();

        public int getAsInt();

        public long getAsLong();
    }
}

