/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.join;

import cz.afri.smg.graphs.CLangStackFrame;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGFactory;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.join.SMGJoinStatus;
import cz.afri.smg.join.SMGJoinSubSMGs;
import cz.afri.smg.join.SMGNodeMapping;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.types.CType;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public final class SMGJoin {
    private boolean defined = false;
    private SMGJoinStatus status = SMGJoinStatus.EQUAL;
    private final WritableSMG smg;

    public static void performChecks(boolean pOn) {
        SMGJoinSubSMGs.performChecks(pOn);
    }

    public SMGJoin(ReadableSMG pSMG1, ReadableSMG pSMG2) {
        Object frameInSMG1;
        WritableSMG opSMG1 = SMGFactory.createWritableCopy(pSMG1);
        WritableSMG opSMG2 = SMGFactory.createWritableCopy(pSMG2);
        this.smg = SMGFactory.createWritableSMG();
        SMGNodeMapping mapping1 = new SMGNodeMapping();
        SMGNodeMapping mapping2 = new SMGNodeMapping();
        Map<String, SMGRegion> globalsInSmg1 = opSMG1.getGlobalObjects();
        ArrayDeque<CLangStackFrame> stackInSmg1 = opSMG1.getStackFrames();
        Map<String, SMGRegion> globalsInSmg2 = opSMG2.getGlobalObjects();
        ArrayDeque<CLangStackFrame> stackInSmg2 = opSMG2.getStackFrames();
        HashSet<String> globalVars = new HashSet<String>();
        globalVars.addAll(globalsInSmg1.keySet());
        globalVars.addAll(globalsInSmg2.keySet());
        for (String globalVar : globalVars) {
            SMGRegion globalInSMG1 = globalsInSmg1.get(globalVar);
            SMGRegion sMGRegion = globalsInSmg2.get(globalVar);
            if (globalInSMG1 == null || sMGRegion == null) {
                return;
            }
            SMGRegion finalObject = this.smg.addGlobalVariable(CType.createTypeWithLength(globalInSMG1.getSize()), globalInSMG1.getLabel());
            mapping1.map(globalInSMG1, finalObject);
            mapping2.map(sMGRegion, finalObject);
        }
        Iterator<CLangStackFrame> smg1stackIterator = stackInSmg1.descendingIterator();
        Iterator<CLangStackFrame> smg2stackIterator = stackInSmg2.descendingIterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            frameInSMG1 = smg1stackIterator.next();
            CLangStackFrame cLangStackFrame = smg2stackIterator.next();
            this.smg.addStackFrame(((CLangStackFrame)frameInSMG1).getFunctionDeclaration());
            HashSet<String> localVars = new HashSet<String>();
            localVars.addAll(((CLangStackFrame)frameInSMG1).getVariables().keySet());
            localVars.addAll(cLangStackFrame.getVariables().keySet());
            for (String localVar : localVars) {
                if (!((CLangStackFrame)frameInSMG1).containsVariable(localVar) || !cLangStackFrame.containsVariable(localVar)) {
                    return;
                }
                SMGRegion localInSMG1 = ((CLangStackFrame)frameInSMG1).getVariable(localVar);
                SMGRegion localInSMG2 = cLangStackFrame.getVariable(localVar);
                SMGRegion finalObject = this.smg.addLocalVariable(CType.createTypeWithLength(localInSMG1.getSize()), localInSMG1.getLabel());
                mapping1.map(localInSMG1, finalObject);
                mapping2.map(localInSMG2, finalObject);
            }
        }
        for (Map.Entry entry : globalsInSmg1.entrySet()) {
            SMGObject destinationGlobal;
            SMGObject globalInSMG2;
            SMGObject globalInSMG1 = (SMGObject)entry.getValue();
            SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, mapping1, mapping2, globalInSMG1, globalInSMG2 = (SMGObject)globalsInSmg2.get(entry.getKey()), destinationGlobal = mapping1.get(globalInSMG1));
            if (!jss.isDefined()) {
                return;
            }
            this.status = jss.getStatus();
        }
        smg1stackIterator = stackInSmg1.iterator();
        smg2stackIterator = stackInSmg2.iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            frameInSMG1 = smg1stackIterator.next();
            CLangStackFrame cLangStackFrame = smg2stackIterator.next();
            for (String localVar : ((CLangStackFrame)frameInSMG1).getVariables().keySet()) {
                SMGObject destinationLocal;
                SMGRegion localInSMG2;
                SMGRegion localInSMG1 = ((CLangStackFrame)frameInSMG1).getVariable(localVar);
                SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, mapping1, mapping2, localInSMG1, localInSMG2 = cLangStackFrame.getVariable(localVar), destinationLocal = mapping1.get(localInSMG1));
                if (!jss.isDefined()) {
                    return;
                }
                this.status = jss.getStatus();
            }
        }
        this.defined = true;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public ReadableSMG getJointSMG() {
        return this.smg;
    }
}

