/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.join;

import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGValueFactory;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.join.SMGNodeMapping;
import cz.afri.smg.objects.SMGObject;

final class SMGJoinMapTargetAddress {
    private WritableSMG smg;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private Integer value;

    public SMGJoinMapTargetAddress(ReadableSMG pSMG1, ReadableSMG pSMG2, WritableSMG destSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, Integer pAddress1, Integer pAddress2) {
        this.smg = destSMG;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        SMGObject target = destSMG.getNullObject();
        SMGEdgePointsTo pt = pSMG1.getPointer(pAddress1);
        if (pt.getObject().notNull()) {
            target = pMapping1.get(pt.getObject());
        }
        Iterable<SMGEdgePointsTo> edges = this.smg.getPTEdges();
        for (SMGEdgePointsTo edge : edges) {
            if (edge.getObject() != target || edge.getOffset() != pt.getOffset()) continue;
            this.value = edge.getValue();
            return;
        }
        this.value = SMGValueFactory.getNewValue();
        this.smg.addValue(this.value);
        this.smg.addPointsToEdge(new SMGEdgePointsTo(this.value, target, pt.getOffset()));
        this.mapping1.map(pAddress1, this.value);
        this.mapping2.map(pAddress2, this.value);
    }

    public WritableSMG getSMG() {
        return this.smg;
    }

    public SMGNodeMapping getMapping1() {
        return this.mapping1;
    }

    public SMGNodeMapping getMapping2() {
        return this.mapping2;
    }

    public Integer getValue() {
        return this.value;
    }
}

