/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.join;

import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.join.SMGJoinMapTargetAddress;
import cz.afri.smg.join.SMGJoinMatchObjects;
import cz.afri.smg.join.SMGJoinStatus;
import cz.afri.smg.join.SMGJoinSubSMGs;
import cz.afri.smg.join.SMGNodeMapping;
import cz.afri.smg.objects.SMGObject;

final class SMGJoinTargetObjects {
    private SMGJoinStatus status;
    private boolean defined = false;
    private boolean recoverable = false;
    private ReadableSMG inputSMG1;
    private ReadableSMG inputSMG2;
    private WritableSMG destSMG;
    private Integer value;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;

    private static boolean matchOffsets(SMGJoinTargetObjects pJto, SMGEdgePointsTo pt1, SMGEdgePointsTo pt2) {
        if (pt1.getOffset() != pt2.getOffset()) {
            pJto.defined = false;
            pJto.recoverable = true;
            return true;
        }
        return false;
    }

    private static boolean checkAlreadyJoined(SMGJoinTargetObjects pJto, SMGObject pObj1, SMGObject pObj2, Integer pAddress1, Integer pAddress2) {
        if (!pObj1.notNull() && !pObj2.notNull() || pJto.mapping1.containsKey(pObj1) && pJto.mapping2.containsKey(pObj2) && pJto.mapping1.get(pObj1) == pJto.mapping2.get(pObj2)) {
            SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(pJto.inputSMG1, pJto.inputSMG2, pJto.destSMG, pJto.mapping1, pJto.mapping2, pAddress1, pAddress2);
            pJto.defined = true;
            pJto.destSMG = mta.getSMG();
            pJto.mapping1 = mta.getMapping1();
            pJto.mapping2 = mta.getMapping2();
            pJto.value = mta.getValue();
            return true;
        }
        return false;
    }

    private static boolean checkObjectMatch(SMGJoinTargetObjects pJto, SMGObject pObj1, SMGObject pObj2) {
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(pJto.status, pJto.inputSMG1, pJto.inputSMG2, pJto.mapping1, pJto.mapping2, pObj1, pObj2);
        if (!mo.isDefined()) {
            pJto.defined = false;
            pJto.recoverable = true;
            return true;
        }
        pJto.status = mo.getStatus();
        return false;
    }

    public SMGJoinTargetObjects(SMGJoinStatus pStatus, ReadableSMG pSMG1, ReadableSMG pSMG2, WritableSMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, Integer pAddress1, Integer pAddress2) {
        SMGObject target2;
        this.inputSMG1 = pSMG1;
        this.inputSMG2 = pSMG2;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        this.destSMG = pDestSMG;
        this.status = pStatus;
        SMGEdgePointsTo pt1 = this.inputSMG1.getPointer(pAddress1);
        SMGEdgePointsTo pt2 = this.inputSMG2.getPointer(pAddress2);
        if (SMGJoinTargetObjects.matchOffsets(this, pt1, pt2)) {
            return;
        }
        SMGObject target1 = pt1.getObject();
        if (SMGJoinTargetObjects.checkAlreadyJoined(this, target1, target2 = pt2.getObject(), pAddress1, pAddress2)) {
            return;
        }
        if (SMGJoinTargetObjects.checkObjectMatch(this, target1, target2)) {
            return;
        }
        SMGObject newObject = target1.join(target2);
        this.destSMG.addHeapObject(newObject);
        if (this.mapping1.containsKey(target1)) {
            throw new UnsupportedOperationException("Delayed join not yet implemented");
        }
        this.mapping1.map(target1, newObject);
        this.mapping2.map(target2, newObject);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pAddress1, pAddress2);
        this.destSMG = mta.getSMG();
        this.mapping1 = mta.getMapping1();
        this.mapping2 = mta.getMapping2();
        this.value = mta.getValue();
        SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, target1, target2, newObject);
        if (jss.isDefined()) {
            this.defined = true;
            this.status = jss.getStatus();
        }
    }

    public boolean isDefined() {
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public ReadableSMG getInputSMG1() {
        return this.inputSMG1;
    }

    public WritableSMG getDestinationSMG() {
        return this.destSMG;
    }

    public SMGNodeMapping getMapping1() {
        return this.mapping1;
    }

    public Integer getValue() {
        return this.value;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public ReadableSMG getInputSMG2() {
        return this.inputSMG2;
    }

    public SMGNodeMapping getMapping2() {
        return this.mapping2;
    }
}

