/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.join;

import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGValueFactory;
import cz.afri.smg.graphs.SMGValues;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.join.SMGJoinStatus;
import cz.afri.smg.join.SMGJoinTargetObjects;
import cz.afri.smg.join.SMGNodeMapping;

final class SMGJoinValues {
    private SMGJoinStatus status;
    private ReadableSMG inputSMG1;
    private ReadableSMG inputSMG2;
    private WritableSMG destSMG;
    private Integer value;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private boolean defined = false;

    private static boolean joinValuesIdentical(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        if (pV1 == pV2) {
            pJV.value = pV1;
            pJV.defined = true;
        }
        return pV1.equals(pV2);
    }

    private static boolean joinValuesAlreadyJoined(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        if (pJV.mapping1.containsKey(pV1) && pJV.mapping2.containsKey(pV2) && pJV.mapping1.get(pV1).equals(pJV.mapping2.get(pV2))) {
            pJV.value = pJV.mapping1.get(pV1);
            pJV.defined = true;
            return true;
        }
        return false;
    }

    private static boolean joinValuesNonPointers(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        if (!pJV.inputSMG1.isPointer(pV1) && !pJV.inputSMG2.isPointer(pV2)) {
            if (pJV.mapping1.containsKey(pV1) || pJV.mapping2.containsKey(pV2)) {
                return true;
            }
            SMGValues.SMGExplicitValue exp1 = pJV.inputSMG1.getExplicit(SMGValues.SMGKnownSymValue.valueOf(pV1));
            SMGValues.SMGExplicitValue exp2 = pJV.inputSMG2.getExplicit(SMGValues.SMGKnownSymValue.valueOf(pV2));
            Integer newValue = SMGValueFactory.getNewValue();
            pJV.destSMG.addValue(newValue);
            pJV.mapping1.map(pV1, newValue);
            pJV.mapping2.map(pV2, newValue);
            pJV.defined = true;
            pJV.value = newValue;
            if (!exp1.isUnknown() && !exp2.isUnknown()) {
                SMGValues.SMGKnownExpValue knownExp1 = (SMGValues.SMGKnownExpValue)exp1;
                SMGValues.SMGKnownExpValue knownExp2 = (SMGValues.SMGKnownExpValue)exp2;
                if (knownExp1.equals(knownExp2)) {
                    pJV.destSMG.putExplicit(SMGValues.SMGKnownSymValue.valueOf(newValue), knownExp1);
                } else {
                    pJV.status = SMGJoinStatus.updateStatus(pJV.status, SMGJoinStatus.INCOMPARABLE);
                }
            } else if (exp1.isUnknown() && !exp2.isUnknown()) {
                pJV.status = SMGJoinStatus.updateStatus(pJV.status, SMGJoinStatus.LEFT_ENTAIL);
            } else if (exp2.isUnknown() && !exp1.isUnknown()) {
                pJV.status = SMGJoinStatus.updateStatus(pJV.status, SMGJoinStatus.RIGHT_ENTAIL);
            }
            return true;
        }
        return false;
    }

    private static boolean joinValuesMixedPointers(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        return !pJV.inputSMG1.isPointer(pV1) || !pJV.inputSMG2.isPointer(pV2);
    }

    private static boolean joinValuesPointers(SMGJoinValues pJV, Integer pV1, Integer pV2) {
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(pJV.status, pJV.inputSMG1, pJV.inputSMG2, pJV.destSMG, pJV.mapping1, pJV.mapping2, pV1, pV2);
        if (jto.isDefined()) {
            pJV.status = jto.getStatus();
            pJV.inputSMG1 = jto.getInputSMG1();
            pJV.inputSMG2 = jto.getInputSMG2();
            pJV.destSMG = jto.getDestinationSMG();
            pJV.mapping1 = jto.getMapping1();
            pJV.mapping2 = jto.getMapping2();
            pJV.value = jto.getValue();
            pJV.defined = true;
            return true;
        }
        if (jto.isRecoverable()) {
            return false;
        }
        pJV.defined = false;
        return true;
    }

    public SMGJoinValues(SMGJoinStatus pStatus, ReadableSMG pSMG1, ReadableSMG pSMG2, WritableSMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, Integer pValue1, Integer pValue2) {
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        this.status = pStatus;
        this.inputSMG1 = pSMG1;
        this.inputSMG2 = pSMG2;
        this.destSMG = pDestSMG;
        if (SMGJoinValues.joinValuesAlreadyJoined(this, pValue1, pValue2)) {
            return;
        }
        if (SMGJoinValues.joinValuesNonPointers(this, pValue1, pValue2)) {
            return;
        }
        if (SMGJoinValues.joinValuesMixedPointers(this, pValue1, pValue2)) {
            return;
        }
        if (SMGJoinValues.joinValuesPointers(this, pValue1, pValue2)) {
            return;
        }
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public ReadableSMG getInputSMG1() {
        return this.inputSMG1;
    }

    public ReadableSMG getInputSMG2() {
        return this.inputSMG2;
    }

    public WritableSMG getDestinationSMG() {
        return this.destSMG;
    }

    public Integer getValue() {
        return this.value;
    }

    public SMGNodeMapping getMapping1() {
        return this.mapping1;
    }

    public SMGNodeMapping getMapping2() {
        return this.mapping2;
    }

    public boolean isDefined() {
        return this.defined;
    }
}

