/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.join;

import cz.afri.smg.objects.SMGObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class SMGNodeMapping {
    private final Map<SMGObject, SMGObject> objectMap = new HashMap<SMGObject, SMGObject>();
    private final Map<Integer, Integer> valueMap = new HashMap<Integer, Integer>();

    public int hashCode() {
        return Objects.hash(this.objectMap, this.valueMap);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SMGNodeMapping)) {
            return false;
        }
        SMGNodeMapping other = (SMGNodeMapping)obj;
        return Objects.equals(this.objectMap, other.objectMap) && Objects.equals(this.valueMap, other.valueMap);
    }

    public SMGNodeMapping() {
    }

    public SMGNodeMapping(SMGNodeMapping origin) {
        this.objectMap.putAll(origin.objectMap);
        this.valueMap.putAll(origin.valueMap);
    }

    public Integer get(Integer i) {
        return this.valueMap.get(i);
    }

    public SMGObject get(SMGObject o) {
        return this.objectMap.get(o);
    }

    public void map(SMGObject key, SMGObject value) {
        this.objectMap.put(key, value);
    }

    public void map(Integer key, Integer value) {
        this.valueMap.put(key, value);
    }

    public boolean containsKey(Integer key) {
        return this.valueMap.containsKey(key);
    }

    public boolean containsKey(SMGObject key) {
        return this.objectMap.containsKey(key);
    }

    public boolean containsValue(SMGObject value) {
        return this.objectMap.containsValue(value);
    }
}

