/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.objects.sll;

import cz.afri.smg.SMGConcretisation;
import cz.afri.smg.objects.SMGAbstractObject;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGObjectVisitor;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.objects.sll.SMGSingleLinkedListConcretisation;

public final class SMGSingleLinkedList
extends SMGAbstractObject {
    private int length;
    private int bindingOffset;

    public SMGSingleLinkedList(SMGRegion pPrototype, int pOffset, int pLength) {
        super(pPrototype.getSize(), "SLL");
        this.bindingOffset = pOffset;
        this.length = pLength;
    }

    public SMGSingleLinkedList(SMGSingleLinkedList pOriginal) {
        super(pOriginal);
        this.bindingOffset = pOriginal.bindingOffset;
        this.length = pOriginal.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.bindingOffset;
    }

    public int addLength(int pLen) {
        this.length += pLen;
        return this.length;
    }

    public String toString() {
        return "SLL(size=" + this.getSize() + ", bindingOffset=" + this.bindingOffset + ", len=" + this.length + ")";
    }

    @Override
    public void accept(SMGObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean matchGenericShape(SMGAbstractObject pOther) {
        return pOther instanceof SMGSingleLinkedList;
    }

    @Override
    public boolean matchSpecificShape(SMGAbstractObject pOther) {
        if (!this.matchGenericShape(pOther)) {
            return false;
        }
        SMGSingleLinkedList otherSLL = (SMGSingleLinkedList)pOther;
        return this.bindingOffset == otherSLL.bindingOffset && this.getSize() == otherSLL.getSize();
    }

    @Override
    protected SMGConcretisation createConcretisation() {
        return new SMGSingleLinkedListConcretisation(this);
    }

    @Override
    public boolean isMoreGeneral(SMGObject pOther) {
        if (!pOther.isAbstract()) {
            return true;
        }
        if (!this.matchSpecificShape((SMGAbstractObject)pOther)) {
            throw new IllegalArgumentException("isMoreGeneral called on incompatible abstract objects");
        }
        return this.length < ((SMGSingleLinkedList)pOther).length;
    }

    @Override
    public SMGSingleLinkedList join(SMGObject pOther) {
        if (!pOther.isAbstract()) {
            return new SMGSingleLinkedList(this);
        }
        if (this.matchSpecificShape((SMGAbstractObject)pOther)) {
            SMGSingleLinkedList otherSll = (SMGSingleLinkedList)pOther;
            if (this.getLength() < otherSll.getLength()) {
                return new SMGSingleLinkedList(this);
            }
            return new SMGSingleLinkedList(otherSll);
        }
        throw new UnsupportedOperationException("join() called on incompatible abstract objects");
    }
}

