/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.objects.sll;

import cz.afri.smg.SMGAbstractionCandidate;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGFactory;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.objects.sll.SMGSingleLinkedList;
import cz.afri.smg.types.CPointerType;
import cz.afri.smg.types.CType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;

class SMGSingleLinkedListCandidate
implements SMGAbstractionCandidate {
    private final SMGObject start;
    private final int offset;
    private int length;

    public SMGSingleLinkedListCandidate(SMGObject pStart, int pOffset, int pLength) {
        this.start = pStart;
        this.offset = pOffset;
        this.length = pLength;
    }

    @Override
    public final int getScore() {
        return 0;
    }

    @Override
    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="We need to iterate over keys here")
    public final ReadableSMG execute(ReadableSMG pSMG) {
        WritableSMG newSMG = SMGFactory.createWritableCopy(pSMG);
        SMGSingleLinkedList sll = new SMGSingleLinkedList((SMGRegion)this.start, this.offset, this.length);
        newSMG.addHeapObject(sll);
        HashMap<SMGEdgePointsTo, SMGEdgePointsTo> toReplace = new HashMap<SMGEdgePointsTo, SMGEdgePointsTo>();
        for (SMGEdgePointsTo pt : newSMG.getPTEdges()) {
            if (!pt.getObject().equals(this.start)) continue;
            SMGEdgePointsTo newPt = new SMGEdgePointsTo(pt.getValue(), sll, pt.getOffset());
            toReplace.put(pt, newPt);
        }
        for (SMGEdgePointsTo pt : toReplace.keySet()) {
            newSMG.removePointsToEdge(pt.getValue());
            newSMG.addPointsToEdge((SMGEdgePointsTo)toReplace.get(pt));
        }
        SMGObject node = this.start;
        Integer value = null;
        SMGEdgeHasValue edgeToFollow = null;
        for (int i = 0; i < this.length; ++i) {
            if (value != null) {
                newSMG.removePointsToEdge(value);
                newSMG.removeValue(value);
            }
            SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(node).filterAtOffset(this.offset);
            Iterable<SMGEdgeHasValue> outboundEdges = newSMG.getHVEdges(filter);
            edgeToFollow = null;
            for (SMGEdgeHasValue outbound : outboundEdges) {
                CType fieldType = outbound.getType();
                if (!(fieldType instanceof CPointerType)) continue;
                edgeToFollow = outbound;
            }
            if (edgeToFollow == null) {
                edgeToFollow = new SMGEdgeHasValue(CPointerType.getVoidPointer(), this.offset, node, newSMG.getNullValue());
            }
            value = edgeToFollow.getValue();
            newSMG.removeHeapObject(node);
            node = newSMG.getPointer(value).getObject();
        }
        SMGEdgeHasValue newOutbound = new SMGEdgeHasValue(edgeToFollow.getType(), this.offset, (SMGObject)sll, (int)value);
        newSMG.addHasValueEdge(newOutbound);
        return newSMG;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final void addLength(int pLength) {
        this.length += pLength;
    }

    public final boolean isCompatibleWith(SMGSingleLinkedListCandidate pOther) {
        return this.offset == pOther.offset && this.start.getSize() == pOther.start.getSize();
    }

    public final SMGObject getStart() {
        return this.start;
    }

    public final String toString() {
        return "SLL CANDIDATE(start=" + this.start + ", offset=" + this.offset + ", length=" + this.length + ")";
    }
}

