/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.objects.sll;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import cz.afri.smg.SMGConcretisation;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGFactory;
import cz.afri.smg.graphs.SMGValueFactory;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.objects.sll.SMGSingleLinkedList;
import cz.afri.smg.types.CPointerType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;

class SMGSingleLinkedListConcretisation
implements SMGConcretisation {
    private final SMGSingleLinkedList sll;

    public SMGSingleLinkedListConcretisation(SMGSingleLinkedList pSll) {
        this.sll = pSll;
    }

    @Override
    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="We need to iterate over keys here")
    public final HashSet<ReadableSMG> execute(ReadableSMG pSMG) {
        HashSet<ReadableSMG> resultSet = new HashSet<ReadableSMG>();
        WritableSMG newSMG = SMGFactory.createWritableCopy(pSMG);
        SMGRegion region = new SMGRegion(this.sll.getSize(), this.sll.getLabel() + "_element");
        newSMG.addHeapObject(region);
        HashMap<SMGEdgePointsTo, SMGEdgePointsTo> toReplace = new HashMap<SMGEdgePointsTo, SMGEdgePointsTo>();
        for (SMGEdgePointsTo pt : newSMG.getPTEdges()) {
            if (!pt.getObject().equals(this.sll)) continue;
            SMGEdgePointsTo newPt = new SMGEdgePointsTo(pt.getValue(), region, this.sll.getOffset());
            toReplace.put(pt, newPt);
        }
        for (SMGEdgePointsTo pt : toReplace.keySet()) {
            newSMG.removePointsToEdge(pt.getValue());
            newSMG.addPointsToEdge((SMGEdgePointsTo)toReplace.get(pt));
        }
        Integer newValue = SMGValueFactory.getNewValue();
        newSMG.addValue(newValue);
        SMGEdgeHasValue newValueHv = new SMGEdgeHasValue(new CPointerType(), this.sll.getOffset(), (SMGObject)region, (int)newValue);
        newSMG.addHasValueEdge(newValueHv);
        SMGEdgePointsTo newValuePt = new SMGEdgePointsTo(newValue, this.sll, this.sll.getOffset());
        newSMG.addPointsToEdge(newValuePt);
        if (this.sll.getLength() > 0) {
            this.sll.addLength(-1);
        } else {
            Integer value;
            WritableSMG newSMGWithoutSll = SMGFactory.createWritableCopy(pSMG);
            if (Iterables.isEmpty(newSMGWithoutSll.getHVEdges(SMGEdgeHasValueFilter.objectFilter(this.sll).filterAtOffset(this.sll.getOffset()).filterByType(CPointerType.getVoidPointer())))) {
                value = SMGValueFactory.getNewValue();
                newSMGWithoutSll.addValue(value);
            } else {
                value = newSMGWithoutSll.getUniqueHV(SMGEdgeHasValueFilter.objectFilter(this.sll).filterAtOffset(this.sll.getOffset()).filterByType(CPointerType.getVoidPointer()), false).getValue();
            }
            for (SMGEdgePointsTo pt : newSMGWithoutSll.getPTEdges()) {
                if (!pt.getObject().equals(this.sll)) continue;
                SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter().filterHavingValue(pt.getValue());
                SMGEdgeHasValue oldHv = newSMGWithoutSll.getUniqueHV(filter, false);
                SMGEdgeHasValue newHv = new SMGEdgeHasValue(CPointerType.getVoidPointer(), this.sll.getOffset(), oldHv.getObject(), (int)value);
                newSMGWithoutSll.addHasValueEdge(newHv);
                newSMGWithoutSll.removeHasValueEdge(oldHv);
                newSMGWithoutSll.removePointsToEdge(oldHv.getValue());
                newSMGWithoutSll.removeValue(oldHv.getValue());
            }
            SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(this.sll);
            HashSet toRemove = Sets.newHashSet(newSMGWithoutSll.getHVEdges(filter));
            for (SMGEdgeHasValue hv : toRemove) {
                newSMGWithoutSll.removeHasValueEdge(hv);
            }
            newSMGWithoutSll.removeHeapObject(this.sll);
            resultSet.add(newSMGWithoutSll);
        }
        resultSet.add(newSMG);
        return resultSet;
    }

    public final SMGSingleLinkedList getSll() {
        return this.sll;
    }
}

