/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.objects.sll;

import com.google.common.collect.Iterables;
import cz.afri.smg.SMGAbstractionCandidate;
import cz.afri.smg.SMGAbstractionFinder;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.sll.SMGSingleLinkedListCandidate;
import cz.afri.smg.types.CPointerType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SMGSingleLinkedListFinder
implements SMGAbstractionFinder {
    private static final int THRESHOLD_DEFAULT = 10;
    private ReadableSMG smg;
    private Map<SMGObject, Map<Integer, SMGSingleLinkedListCandidate>> candidates = new HashMap<SMGObject, Map<Integer, SMGSingleLinkedListCandidate>>();
    private Map<Integer, Integer> inboundPointers = new HashMap<Integer, Integer>();
    private final int seqLengthThreshold;

    public SMGSingleLinkedListFinder() {
        this.seqLengthThreshold = 10;
    }

    public SMGSingleLinkedListFinder(int pSeqLengthThreshold) {
        this.seqLengthThreshold = pSeqLengthThreshold;
    }

    @Override
    public final Set<SMGAbstractionCandidate> traverse(ReadableSMG pSmg) {
        this.smg = pSmg;
        this.buildInboundPointers();
        for (SMGObject object : this.smg.getHeapObjects()) {
            this.startTraversal(object);
        }
        HashSet<SMGSingleLinkedListCandidate> returnSet = new HashSet<SMGSingleLinkedListCandidate>();
        for (Map<Integer, SMGSingleLinkedListCandidate> objCandidates : this.candidates.values()) {
            for (SMGSingleLinkedListCandidate candidate : objCandidates.values()) {
                if (candidate.getLength() <= this.seqLengthThreshold) continue;
                returnSet.add(candidate);
            }
        }
        return Collections.unmodifiableSet(returnSet);
    }

    private void buildInboundPointers() {
        for (SMGEdgePointsTo pt : this.smg.getPTEdges()) {
            int pointer = pt.getValue();
            Iterable<SMGEdgeHasValue> hvEdges = this.smg.getHVEdges(new SMGEdgeHasValueFilter().filterHavingValue(pointer));
            this.inboundPointers.put(pointer, Iterables.size(hvEdges));
        }
    }

    private void startTraversal(SMGObject pObject) {
        if (this.candidates.containsKey(pObject)) {
            return;
        }
        this.candidates.put(pObject, new HashMap());
        for (SMGEdgeHasValue hv : this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject))) {
            if (!this.smg.isPointer(hv.getValue())) continue;
            SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(pObject, hv.getOffset(), 1);
            this.candidates.get(pObject).put(hv.getOffset(), candidate);
            this.continueTraversal(hv.getValue(), candidate);
        }
    }

    private void continueTraversal(int pValue, SMGSingleLinkedListCandidate pCandidate) {
        SMGSingleLinkedListCandidate myCandidate;
        Integer offset;
        SMGEdgePointsTo pt = this.smg.getPointer(pValue);
        SMGObject object = pt.getObject();
        if (!this.candidates.containsKey(object)) {
            this.startTraversal(object);
        }
        if (this.inboundPointers.get(pValue) > 1) {
            return;
        }
        Map<Integer, SMGSingleLinkedListCandidate> objectCandidates = this.candidates.get(object);
        if (!objectCandidates.containsKey(offset = Integer.valueOf(pCandidate.getOffset())) && this.smg.isCoveredByNullifiedBlocks(object, offset, CPointerType.getVoidPointer())) {
            objectCandidates.put(offset, new SMGSingleLinkedListCandidate(object, offset, 1));
        }
        if (objectCandidates.containsKey(offset) && pCandidate.isCompatibleWith(myCandidate = objectCandidates.get(offset))) {
            objectCandidates.remove(offset);
            pCandidate.addLength(myCandidate.getLength());
        }
    }
}

