/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.objects.tree;

import cz.afri.smg.SMGAbstractionCandidate;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.graphs.SMGEdgePointsTo;
import cz.afri.smg.graphs.SMGFactory;
import cz.afri.smg.graphs.WritableSMG;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.SMGRegion;
import cz.afri.smg.objects.tree.SimpleBinaryTree;
import cz.afri.smg.objects.tree.TreeBinding;
import cz.afri.smg.types.CPointerType;
import java.util.ArrayDeque;
import java.util.Deque;

class SimpleBinaryTreeCandidate
implements SMGAbstractionCandidate {
    private final TreeBinding binding;
    private int depth;
    private final SMGObject root;
    private Boolean suitable = null;

    public SimpleBinaryTreeCandidate(SMGObject pRoot, int pLowOffset, int pHighOffset, int pDepth) {
        this.root = pRoot;
        this.depth = pDepth;
        this.binding = new TreeBinding(pLowOffset, pHighOffset, this.root.getSize());
    }

    public final String toString() {
        return "SimpleBinaryTreeCandidate [binding=" + this.binding + ", depth=" + this.depth + ", root=" + this.root + ", suitable=" + this.suitable + "]";
    }

    @Override
    public final int getScore() {
        return 0;
    }

    private void cleanSubtreeAtOffset(WritableSMG pSMG, Deque<SMGObject> pStack, SMGObject pOrigin, int pOffset) {
        SMGEdgeHasValue hvLower = pSMG.getUniqueHV(SMGEdgeHasValueFilter.objectFilter(pOrigin).filterAtOffset(pOffset), true);
        SMGEdgePointsTo ptLower = pSMG.getPointer(hvLower.getValue());
        pSMG.removeHasValueEdge(hvLower);
        if (ptLower.getValue() != pSMG.getNullValue()) {
            pSMG.removePointsToEdge(ptLower.getValue());
            pSMG.removeValue(ptLower.getValue());
            pStack.push(ptLower.getObject());
        }
    }

    private void cleanAbstractedObjects(WritableSMG pNewSMG) {
        ArrayDeque<SMGObject> stack = new ArrayDeque<SMGObject>();
        stack.push(this.root);
        while (!stack.isEmpty()) {
            SMGObject toDelete = (SMGObject)stack.pop();
            this.cleanSubtreeAtOffset(pNewSMG, stack, toDelete, this.binding.getLowerOffset());
            this.cleanSubtreeAtOffset(pNewSMG, stack, toDelete, this.binding.getHigherOffset());
            pNewSMG.removeHeapObject(toDelete);
        }
    }

    @Override
    public final ReadableSMG execute(ReadableSMG pSMG) {
        WritableSMG newSMG = SMGFactory.createWritableCopy(pSMG);
        SimpleBinaryTree tree = new SimpleBinaryTree(new SMGRegion(this.root.getSize(), "TREE"), this.binding.getLowerOffset(), this.binding.getHigherOffset(), this.depth);
        newSMG.addHeapObject(tree);
        newSMG.addHasValueEdge(new SMGEdgeHasValue(CPointerType.getVoidPointer(), this.binding.getLowerOffset(), (SMGObject)tree, newSMG.getNullValue()));
        newSMG.addHasValueEdge(new SMGEdgeHasValue(CPointerType.getVoidPointer(), this.binding.getHigherOffset(), (SMGObject)tree, newSMG.getNullValue()));
        for (SMGEdgePointsTo pt : pSMG.getPTEdges()) {
            if (!pt.getObject().equals(this.root)) continue;
            newSMG.addPointsToEdge(new SMGEdgePointsTo(pt.getValue(), tree, pt.getOffset()));
        }
        this.cleanAbstractedObjects(newSMG);
        return newSMG;
    }

    public final TreeBinding getBinding() {
        return this.binding;
    }

    public final int getDepth() {
        return this.depth;
    }

    public final boolean isSuitable() {
        if (this.suitable == null) {
            throw new IllegalStateException("isSuitable() called without previous suitability check");
        }
        return this.suitable;
    }

    public final boolean isProcessed() {
        return this.suitable != null;
    }

    public final void setSuitable() {
        this.suitable = Boolean.TRUE;
    }

    public final void setUnsuitable() {
        this.suitable = Boolean.FALSE;
    }

    public final void absorb(SimpleBinaryTreeCandidate pOne, SimpleBinaryTreeCandidate pTwo) {
        pOne.setUnsuitable();
        pTwo.setUnsuitable();
        this.depth = pOne.getDepth() > pTwo.getDepth() ? (this.depth += pOne.getDepth()) : (this.depth += pTwo.getDepth());
    }
}

