/*
 * Decompiled with CFR 0.152.
 */
package cz.afri.smg.objects.tree;

import cz.afri.smg.SMGAbstractionCandidate;
import cz.afri.smg.SMGAbstractionFinder;
import cz.afri.smg.graphs.ReadableSMG;
import cz.afri.smg.graphs.SMGEdgeHasValue;
import cz.afri.smg.graphs.SMGEdgeHasValueFilter;
import cz.afri.smg.objects.SMGObject;
import cz.afri.smg.objects.tree.SimpleBinaryTreeCandidate;
import cz.afri.smg.objects.tree.TreeBinding;
import cz.afri.smg.types.CPointerType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class SimpleBinaryTreeFinder
implements SMGAbstractionFinder {
    private ReadableSMG smg;
    private Map<SMGObject, Map<TreeBinding, SimpleBinaryTreeCandidate>> bindings = new HashMap<SMGObject, Map<TreeBinding, SimpleBinaryTreeCandidate>>();

    SimpleBinaryTreeFinder() {
    }

    public final String toString() {
        return "SimpleBinaryTreeFinder";
    }

    private void collectObviousBindingsOnObject(SMGObject pObject) {
        Iterable<SMGEdgeHasValue> outerEdges = this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject));
        Iterable<SMGEdgeHasValue> innerEdges = this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject));
        HashMap<TreeBinding, SimpleBinaryTreeCandidate> objectBindings = new HashMap<TreeBinding, SimpleBinaryTreeCandidate>();
        this.bindings.put(pObject, objectBindings);
        for (SMGEdgeHasValue outer : outerEdges) {
            if (!this.smg.isPointer(outer.getValue())) continue;
            for (SMGEdgeHasValue inner : innerEdges) {
                if (!this.smg.isPointer(inner.getValue()) || outer.overlapsWith(inner)) continue;
                SimpleBinaryTreeCandidate candidate = new SimpleBinaryTreeCandidate(pObject, outer.getOffset(), inner.getOffset(), 1);
                objectBindings.put(candidate.getBinding(), candidate);
            }
        }
    }

    private void collectObviousBindings() {
        for (SMGObject object : this.smg.getHeapObjects()) {
            this.collectObviousBindingsOnObject(object);
        }
    }

    private SMGObject getSuccessorOnOffset(SMGObject pNode, int pOffset) {
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pNode).filterAtOffset(pOffset);
        Iterable<SMGEdgeHasValue> edgesOnOffset = this.smg.getHVEdges(filter);
        if (edgesOnOffset.iterator().hasNext()) {
            return this.smg.getObjectPointedBy(edgesOnOffset.iterator().next().getValue());
        }
        if (this.smg.isCoveredByNullifiedBlocks(pNode, pOffset, CPointerType.getVoidPointer())) {
            return this.smg.getNullObject();
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private SimpleBinaryTreeCandidate processCandidateOnNode(SimpleBinaryTreeCandidate pCandidate, SMGObject pNode) {
        SimpleBinaryTreeCandidate candidate;
        TreeBinding binding = pCandidate.getBinding();
        if (!pNode.notNull()) {
            SimpleBinaryTreeCandidate candidate2 = new SimpleBinaryTreeCandidate(pNode, binding.getLowerOffset(), binding.getHigherOffset(), 0);
            candidate2.setSuitable();
            return candidate2;
        }
        Map<TreeBinding, SimpleBinaryTreeCandidate> myCandidates = this.bindings.get(pNode);
        if (!myCandidates.containsKey(binding)) {
            myCandidates.put(binding, new SimpleBinaryTreeCandidate(pNode, binding.getLowerOffset(), binding.getHigherOffset(), 1));
        }
        if (!(candidate = myCandidates.get(binding)).isProcessed()) {
            SMGObject lowNode = this.getSuccessorOnOffset(pNode, binding.getLowerOffset());
            SMGObject highNode = this.getSuccessorOnOffset(pNode, binding.getHigherOffset());
            SimpleBinaryTreeCandidate lowCandidate = this.processCandidateOnNode(candidate, lowNode);
            SimpleBinaryTreeCandidate highCandidate = this.processCandidateOnNode(candidate, highNode);
            if (lowCandidate.isSuitable() && highCandidate.isSuitable()) {
                candidate.setSuitable();
                candidate.absorb(lowCandidate, highCandidate);
            } else {
                candidate.setUnsuitable();
            }
        }
        return myCandidates.get(binding);
    }

    private void processNode(SMGObject pObject) {
        for (SimpleBinaryTreeCandidate candidate : this.bindings.get(pObject).values()) {
            if (candidate.isProcessed()) continue;
            this.processCandidateOnNode(candidate, pObject);
        }
    }

    private void processAllNodes() {
        for (SMGObject object : this.smg.getHeapObjects()) {
            this.processNode(object);
        }
    }

    @Override
    public final Set<SMGAbstractionCandidate> traverse(ReadableSMG pSmg) {
        this.smg = pSmg;
        this.collectObviousBindings();
        this.processAllNodes();
        HashSet<SMGAbstractionCandidate> found = new HashSet<SMGAbstractionCandidate>();
        for (Map<TreeBinding, SimpleBinaryTreeCandidate> map : this.bindings.values()) {
            for (SimpleBinaryTreeCandidate candidate : map.values()) {
                if (!candidate.isSuitable() || candidate.getDepth() <= 2) continue;
                found.add(candidate);
            }
        }
        return found;
    }
}

