package cz.applifting.appgraph.accessibility

import androidx.compose.foundation.focusable
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.semantics.contentDescription
import androidx.compose.ui.semantics.semantics
import cz.applifting.appgraph.decorations.XAxisLabels
import cz.applifting.appgraph.decorations.YAxisLabels

@Composable
fun AccessibilityCanvasOverlay(
    dataContentDescriptionList: List<String>,
    xAxisLabels: XAxisLabels,
    yAxisLabels: YAxisLabels,
    modifier: Modifier = Modifier,
) {
    Row(modifier = modifier) {
        dataContentDescriptionList.forEachIndexed { idx, value ->
            //draws striped bg color might need for debug
//            val bgColor = if (idx % 2 == 0) Color.Red.copy(0.2f) else Color.Green.copy(0.2f)
            Spacer(modifier = Modifier
                .fillMaxHeight()
                .weight(1f)
                    //see above
//                .background(bgColor)
                .focusable()
                .semantics {
                    contentDescription =
                        "${xAxisLabels.xAxisPointPrefixDescription} ${xAxisLabels.labels[idx].contentDescription} ${xAxisLabels.xAxisPointSuffixDescription} $value ${yAxisLabels.yAxisPointDescriptionSuffix}"
                })
        }
    }
}