package cz.applifting.appgraph.accessibility

import androidx.compose.foundation.focusable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.semantics.contentDescription
import androidx.compose.ui.semantics.semantics
import cz.applifting.appgraph.decorations.XAxisLabels
import cz.applifting.appgraph.decorations.YAxisLabels

@Composable
fun ChartAccessibilityContainer(
    dataContentDescriptionList: List<String>,
    xAxisLabels: XAxisLabels,
    yAxisLabels: YAxisLabels,
    canvasPaddingValues: PaddingValues,
    modifier: Modifier = Modifier,
    basicChartContentDescription: String,
    dataSizeContentDescription: String,
    canvas: @Composable () -> Unit = {}
) {
    var cd  = "$basicChartContentDescription ${xAxisLabels.xAxisContentDescription} ${yAxisLabels.yAxisContentDescription} $dataSizeContentDescription"
    if (cd.isBlank()) cd =""

    Box(modifier = modifier
        .focusable()
        .semantics {
            contentDescription = cd
        }
    ) {
        canvas()

        AccessibilityCanvasOverlay(
            dataContentDescriptionList,
            xAxisLabels,
            yAxisLabels,
            Modifier.fillMaxSize().padding(canvasPaddingValues)
        )
    }
}