package cz.applifting.appgraph.charts.common

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import cz.applifting.appgraph.decorations.YAxisLabelsPosition

/**
 * Basic chart style common to all the charts
 *
 * @property paddingValues - outer padding of the chart container
 * @property canvasPaddingValues - padding directly on the canvas, The chart values are drawn between these paddings.
 * The chart labels are drawn INTO these paddings.
 * @property height - height of the canvas
 * @property isYAxisLabelVisible
 * @property isXAxisLabelVisible
 * @property isHeaderVisible
 * @property drawCanvasPaddings - if true draws canvas paddings to the chart. Used for debugging
 * @property backgroundColor - background color of the chart. Needs to be set when using [PointStyle.OutlinedPoint] and
 * [PointStyle.ImagePointStyle] because it is used for erasing content.
 * @property xAxisTextColor - default textColor if default XAxisLabels are used
 * @property yAxisTextColor - default text color if default yAxisLabels are used
 */
open class BasicChartStyle(
    val paddingValues: PaddingValues = PaddingValues(
        all = 12.dp
    ),
    val canvasPaddingValues: PaddingValues = PaddingValues(
        start = 20.dp, end = 20.dp, top = 0.dp, bottom = 20.dp
    ),
    val height: Dp = 300.dp,

    val isYAxisLabelVisible: Boolean = true,
    val isXAxisLabelVisible: Boolean = true,
    val isHeaderVisible: Boolean = false,
    val drawCanvasPaddings: Boolean = false,

    val backgroundColor: Color = Color.Transparent,
    val xAxisTextColor: Int = android.graphics.Color.BLACK,
    val yAxisTextColor: Int = android.graphics.Color.BLACK,

    val yAxisLabelsPosition: YAxisLabelsPosition = YAxisLabelsPosition.LEFT
) {

}