package cz.applifting.appgraph.charts.common

import cz.applifting.appgraph.charts.utils.GraphHelper

sealed class YScale {
    fun chartYToCanvasY(y: Float, basicChartDrawer: BasicChartDrawer): Float {
        return basicChartDrawer.paddingTopPx + (basicChartDrawer.gridHeight * (1 - ((y - min) / (max - min))))
    }
    open fun setupValuesFromData(data: List<Number>) {}

    protected abstract var min: Float
    protected abstract var max: Float

    fun getLabels(count: Int = 5): List<Float> {

        val labels = mutableListOf<Float>()

        val step = (max - min) / (count - 1)

        for (i in 0 until count) {
            labels.add(min + i*step)
        }

        return labels
    }

    class ZeroToMaxScale(): YScale() {
        override fun setupValuesFromData(data: List<Number>) {
           max = GraphHelper.getAbsoluteMax(data).toFloat()
        }

        override var min = 0f
        override var max = 100f
    }

    class  CustomScale(
        override var min: Float,
        override var max: Float,
    ): YScale()

    class MinMaxAsNearestValue(
        val modValue: Float,
        dataMin: Float,
        dataMax: Float
    ): YScale() {

        override var min = 0f
        override var max = 100f

        init {
            max = dataMax - dataMax.mod(modValue) + modValue
            min = dataMin - dataMin.mod(modValue)
        }
    }
}