package cz.applifting.appgraph.charts.doublePointChart

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import cz.applifting.appgraph.charts.common.PointStyle
import cz.applifting.appgraph.color.DeepPurple
import cz.applifting.appgraph.color.GraphAccent

/**
 * Class for styling double point chart data points
 * @property bottomPointStyle - style for minimum point
 * @property topPointStyle - style for maximum point
 */
data class DoublePointChartDataPointStyle(

    val bottomPointStyle: PointStyle = PointStyle.FilledPoint(4.dp, GraphAccent),
    val topPointStyle: PointStyle = PointStyle.FilledPoint(4.dp, GraphAccent),

    val lineColor: Color = DeepPurple,
    val lineWidth: Dp = 2.dp,
)