package cz.applifting.appgraph.charts.utils

import cz.applifting.appgraph.charts.common.BasicChartDrawer

/**
 * Translates chart x coord where 1 is above first datapoint or at the beginning of the first data point (barchart) to
 * canvas where 0 is left corner
 */
fun chartXToCanvasX(x: Float, basicChartDrawer: BasicChartDrawer): Float =
    basicChartDrawer.paddingLeftPx + basicChartDrawer.xDataOffset + basicChartDrawer.xItemSpacing * x

/**
 * translates y-coord from current y-scale to y  on canvas where 0 is at the top
 */
fun chartYtoCanvasY(y: Float, basicChartDrawer: BasicChartDrawer): Float =
    basicChartDrawer.yScale.chartYToCanvasY(y, basicChartDrawer)