package cz.applifting.appgraph.decorations

import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.geometry.Size
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.drawscope.DrawScope
import cz.applifting.appgraph.charts.common.BasicChartDrawer
import cz.applifting.appgraph.charts.common.drawBackgroundHighlight
import cz.applifting.appgraph.charts.utils.chartYtoCanvasY

/**
 * Component that draws [color] along the width of the canvas starting at [yStart] and ending at [yEnd] according to current
 * y-scale
 */
data class BackgroundHighlight (
    val yStart: Float,
    val yEnd: Float,
    val color: Color,
): CanvasDrawable {
    override fun drawToCanvas(basicChartDrawer: BasicChartDrawer) {
        basicChartDrawer.scope.drawBackgroundHighlight(
            this,
           basicChartDrawer
        )
    }
}